; Copyright 2002-2009 by Autodesk, Inc. All Rights Reserved.
;
; Permission to use, copy, modify, and distribute this software
; for any purpose and without fee is hereby granted, provided that
; the above copyright notice appears in all copies and that both
; the copyright notice and the limited warranty and restricted rights
; notice below appear in all supporting documentation.
;
; AUTODESK, INC. PROVIDES THIS PROGRAM "AS IS" AND WITH ALL FAULTS.
; AUTODESK, INC. SPECIFICALLY DISCLAIMS ANY IMPLIED WARRANTY OF
; MERCHANTABILITY OR FITNESS FOR A PARTICULAR USE.  AUTODESK, INC.
; DOES NOT WARRANT THAT THE OPERATION OF THE PROGRAM WILL BE
; UNINTERRUPTED OR ERROR FREE.
;
; Use, duplication, or disclosure by the U.S. Government is subject to
; restrictions set forth in FAR 52.227-19 (Commercial Computer
; Software - Restricted Rights) and DFAR 252.227-7013(c)(1)(ii)
; (Rights in Technical Data and Computer Software), as applicable.
;
; 18-Oct-07 NEHolt; if TAG1 value defined in spreadsheet, then mark the tagged component attribute as "Fixed"
;                   Also do more complete search for the wdio.dcl support file.
; 04-Oct-07 NEHolt; install location of wdio.lsp moved. Modified search for this file to use "(findfile wdio.lsp)" 
;                   in two marked places in the code.
; 10-Aug-07 NEHolt; added support for "extra" attrib pairs assigned to the main module by piggy-backing
;                   them into one of the columns dedicated to the main module (except for the
;                   catalog CODE column).
; 18-Jul-07 NEHolt; added support for "NEW_DWG" flag in the CODE part number column. This flags
;                   program to jump to the next drawing (leaving any remaining ladders on the 
;                   current drawing blank). Note: existing "SKIP" flag just jumps to next
;                   column.
; 06-Dec-06 NEHolt; support for in-line component inserts that don't have exit wire connection in line
;      with symbol insertion point (i.e. wire needs to "jog" to reconnection and continue on to the
;      PLC I/O wire connection point)
; 29-Aug-06 NEHolt; added param to (c:wdio_autorun...) to allow starting dwg to be defined
; 25-Aug-06 NEHolt; major rework of main and setup dialogs
; 10-Mar-06 NEHolt; force ATTREQ mode to 0 when inserting WD_M block
; 09-Feb-06 NEHolt; added support to move Output I/O desc text to bottom of horizontal ladder
; 08-Feb-06 NEHolt; "SPACER" flag in spreadsheet causing broken module to break too soon. 
; 15-Jan-06 NEHolt; chg GBL_wdio_cfg_fnam to GBL_wd_wdio_cfg_fnam so that PDS will "remember" it
;       and restore it if MDI mode is active and change active drawing
; 12-Jan-06 NEHolt; problem with inserting full PLC units as single block insert
; 29-Dec-05 NEHolt; replaced call to (wd_1_get_registry_slist) with (c:ace_getlocalelistsep); fixed problem
;       with module not sensing active dwg's "Use Full mm" scale setting.
; 14-May-05 NEHolt; delim char for "comma delim" csv files - pull from registry
; 16-Feb-05 LeeH; (640019) Remove saving of functions as global variables; and 
;                 (637501) Check to make sure the drawing is open before trying to close it
; 14-Feb-05 NEHolt; minor chg for SDI mode "overwrite" existing dwg vs no existing dwg
; 11-Feb-05 NEHolt; clean up for MDI mode run with downstream dwgs happen to already be open
; 07-Feb-05 JDZ: Modified Dimensions of starting ladder; ladder width; Ladder 2 Ladder Distance
; 07-Feb-05 JDZ: Added Template File ACAD_ELECTRICAL.DWT; Modfied Signal Style to 4
; 15-Dec-04 NEHolt spreadsheet header column labels not lines up with data
; 10-Sep-04 PanQ; Add a function to save global variables to ARX and add change script to load wdio.lsp before run wdio_doit command
; 06-Aug-04 NEHolt; added "nil" return check on (wd_mdb_GetRecCount) call
; 16-Jul-04 PanQ; Change to support MDI
; 01-Jun-04 NEHolt; missing backslash on template browse button path
; 10-May-04 LeeH; globalized replace of 'strcase' with 'ace_strcase'
; 31-Mar-04 LeeH; moved "6th device" from "wdio_dev_dlg" to "wdio_dev_dlg_2nd"
; 17-Mar-04 NEHolt; unglobalized message strings
; 20-Feb-04 NEHolt; replaced obsolete "split" file name utility with call to (c:wd_split_fnam <path/fnam>)
; 22-Jan-04 NEHolt; on subsequent run of utility, start XLS file selection dialog with previous path/filename
; 20-Jan-04 NEHolt; add error check to make sure addr_ix is defined to avoid a "-1 argument" error message
; 09-Dec-03 NEHolt; changes in two places to prepare for support of unified PLC data file in mdb format
; 18-Nov-03 NEHolt; typo causing LOC attrib not being placed on connected components.
; 30-Oct-03 NEHolt; if the spreadsheet's PLC module catalog "CODE" number includes a leading
;    "*" prefix then this routine will "explode" the inserted circuitry just after the "module"
;    is inserted. It will then try to find a full-unit PLC module among the exploded entities
;    and continue on. Note: in the associated plc*.dat file, the "\K=" entry will need to match
;    with the spreadsheet code "*XXXXX", so the ".dat" entry will also need to be "\K=*XXXXX".
;    Parent schem and PLC components that are part of the exploded circuit will be retagged
;    automatically, if possible.
; 29-Oct-03 NEHolt; For IN or OUT points that have two or more wire connection points
;    associated with the "TAGAxx" attribute, use the XY coordinate of the closest
;    wire connection point to the "TAGAxx" attribute as the baseline coord for the in-line
;    devices. 
; 26-Oct-03 NEHolt; Search for defined template drawing in normal AcadE search path locations when it 
;    is a ".dwg" file instead of a ".dwt" template.
; 25-Oct-03 NEHolt; 2nd half of a "full unit" insert not triggering in-line device insert if first
;    address attribute suffix  > "08". Fixed. If existing template starts with line reference numbers
;    in place and the number of columns matches what the user has selected in the wdio config, then
;    no longer try to insert new line reference columns over the top of the existing ones. For mapping
;    the PLC "tag" value from spreadsheet to the inserted module, now also look for target attribute
;    names "TAG1" and "TAG2".
; 13-Oct-03 NEHolt; "Misplaced dot on input" error message when reading some ".wdi" settings files.
;    Need leading zero on decimal values that don't have a digit to left of decimal. Fixed.
; 29-Sep-03 NEHolt; SS-PLC I/O Generator "SKIP" feature doesn't work when skip flag is hit on 2nd+ 
;    module in a given ladder. Fixed.
; 29-Sep-03 NEHolt; in-line devices for IN or OUT modules - check farther for nearby
;    wire passing by. Check outward 1/2 rung spacing if original in-line device does
;    not turn up an underlying wire.
; 15-Aug-03 NEHolt; added check for "plcpost" user post-processing utilities to be run 
;    after each dwg is generated.
; 14-Aug-03 NEHolt; suppress insert of blank wire numbers
; 11-Aug-03 NEHolt; provision for GBL_wd_scl_plc_borderonly to have a value of 0
; 02-Aug-03 NEHolt; reworked code to restore ATTREQ system variable to original value
;    after build is complete.
; 27-Jul-03 NEHolt; changed default "rung_spacing" value from 0.75 to 1.0
; 11-Jul-03 NEHolt; allow extra attributes to be piggy-backed into cells of in-line device spreadsheet
;    columns other than the one for BLKNAM. Format is "mainval;attrnam2=attrval2;attrnam3=attrval3..."
;    Ex: value in D1TAG column:  "LS101;TERM01=3;TERM02=L2"  "LS101" goes to TAG1 or TAG2,
;    "3" goes to attrib "TERM01" and "L2" goes to attribute "TERM02". Multi-BOM entries are auto-written
;    to WD xdata values if no target attribute is present (ex: "...;MFG01=AB;CAT01=700P-100A1").
; 14-Jun-03 Mauro Sist; globalized with "(set_tile ...)" calls for dialog  controls
; 09-May-03 Mauro Sist; globalized with "(c:wd_msg ...)" calls for messages/prompts
; 19-Feb-03 NEHolt; if "suppress side rails" flag turned on then suppress attempt to insert
;    src/dest arrow symbols at where top/bottom of ladders would be.
; 18-Feb-03 NEHolt; Difficulty inserting template ".dwt" file into an existing 
;    starting drawing. Suppress prompt on first dwg for permission to insert template
; 04-Feb-03 NEHolt; Src/Dest arrows at top/bottom of each ladder sometimes not inserted. Fixed.
; 16-Jan-03 NEHolt; auto-cross reference daisychained src/dest arrows inserted on ladders
; 13-Jan-03 NEHolt; increased max column count to 60 and widened some scroll "max_value=" settings 
;    in the wdio.dcl file to accomodate this change.
; 03-Dec-02 NEHolt; renamed "wd_1_strchr" to "wdio_1_strchr"  and "wd_1_get_attr_val_nam_en" to
;    wdio_1_get_attr_val_nam_en" to avoid duplicate name conflict
; 15-Nov-02 NEHolt; 4th command line argument of (c:wdio_autorun...) entry point to allow
;    xls or mdb table name passed
; 17-Oct-02 ScottH added support for nine connected devices
; 13-Jul-02 NEHolt; 3rd command line argument of (c:wdio_autorun...) entry point can
;    now either be a list of continuations dwgs past the starting drawing (format
;    (list "dwgfnam2" "dwgfnam3" ...) or it can be a list of lists where the first
;    item in the sublist is the continuation drawing file name and the 2nd thru nth
;    are attrib name / attrib value combos for annotation on to the drawing's WD_M
;    block (ex:  (list (list "dwgfnam2" "IEC_INST=inst02" "IEC_LOC=loc02") (list "dwgfnam3"
;    "IEC_INST=inst03" "IEC_LOC=loc03") (list ...))
; 09-Jul-02 NEHolt; bug fix; added new "Suppress rungs" toggle on the "Ladder" setup
;    subdialog.
; 19-Jun-02 NEHolt; added 3rd command line argument. Can now pass a "list" of dwg
;    file names to use for continuation past the starting drawing. The syntax is
;    (c:wdio_autorun (list <xls file name> <.wdi file name> (list "dwg02" "dwg03"..)))
;    If the list is omitted then the starting dwg file name is incremented as
;    required. If the list is not long enough to take care of all of the dwgs that
;    are generated, then the last name in the list is incremented as required.
; 14-Jun-02 NEHolt; added support for inserting JUMPERS between adjacent rungs. Encode
;    the jumper as one of the six available in-line devices. Use the "|" characer as
;    the symbol block name for the jumper. To optionally control removal of wire connections 
;    left and right on the upper wire and lower wire, follow the "|" character with four
;    characters to cover upper left, upper right, lower left, and lower right wire
;    connections. Use "W" to keep the wire connection and "X" to remove. For example,
;    a block name of "|WWXW" will insert a jumper and trim the lower left wire connection.
;    "|XWXW" will trim away the left-hand wire connections of both top and bottom. Just
;    a "|" for the block name is the same as "|WWWW", all wire connections retained.
; 07-Jun-02 NEHolt; added support for Module TAG-ID field in spreadsheet.
; 06-Jun-02 NEHolt; generate a list of extra drawings created (full file names
;    of drawings past the opening drawing. Retun in global GBL_wdio_new_dwgs_created 
; 31-May-02 NEHolt; if "c:wdio_autorun" call then suppress any prompt for "Missing
;    module, okay to continue?" (default to YES) and "Okay to insert template?" (default
;    to NO). 
; 30-May-02 NEHolt; if using MDB table to drive I/O generation, no longer have to have
;    a blank record between the end of one module and the beginning of the next. Just
;    have to have a non-blank CODE value show up in the record to trigger the
;    beginning of the new module. Also, the SLOT and GROUP column values sent to the
;    PLC gen routine were in reverse order. Fixed.
; 26-May-02 NEHolt; added support for calling this routine with command line parameters
;    to trigger it to run without user prompting. Syntax is (c:wdio_autorun paramlst)
;    where paramlst = (list xls_filename wdi_filename). If wdi_filename is nil then utility
;    uses hard-coded defaults.
; 24-May-02 NEHolt; added support for using "SIG" arrow symbols as in-line devices defined
;    in the spreadsheet. Example block name is "HA1S3" for an arrow symbol that cuts and
;    removes the line to the left of the insert point. The SIGCODE value encoded in the
;    in-line device's "Component TAG" column of spreadsheet. Optional arrow symbol's DESC1
;    text in the desc column and optional cross-ref text in the device location column.
; 07-Jun-02 NEHolt; added support for PLC Module "TAG" tag-ID column in spreadsheet
; 23-May-02 NEHolt; added support for PLC Module "LOC" and "INST" columns in the spreadsheet.
;    Added support for running this utility using Microsoft Access data table (.mdb file).
; 07-May-02 NEHolt; added scale 16.0 for IEC insert, added "Apply scl to PLC border only"
;    toggle on the "Ladder" setup subdialog.
; 05-May-02 NEHolt; implemented support for "IEC-style" horizontal ladders
; 12-Apr-02 NEHolt; typo causing "Do not erase unused, blank rungs" option to
;    not work. Fixed.
; 11-Apr-02 NEHolt; not processing terminals "HT1*" to include pin number. Fixed.
; 27-Mar-02 NEHolt; minor addition to allow either "SHEET" or "SHEET_" attrib
;    to be the target for sheet number update on the WD_M block.
; 18-Mar-02 NEHolt; rare instance of customer's spreadsheet causing the
;    "wd_mdb_open" return "fail to open" when, in fact, the file is
;    open. Removed the check for the return flag. Capture any problem
;    with subsequent call to get the list of "tables" in the spreadsheet.
; 25-Feb-02 SHauger; added support for arrow style selection "ss-->plc"
; 21-Feb-02 SHauger; added support for INST attribute mapping
; 15-Feb-02 NEHolt; rare instance where spreadsheet trying to be opened
;    two times. Default to "." as prototype/template drawing if none defined
;    (instead of using "" as the prototype/template).
; 04-Feb-02 NEHolt; made the insert of DEST arrow at top of 2nd+ ladder
;    columns more reliable. 
; 26-Jan-02 NEHolt; combined wdioa.lsp and wdiob.lsp into this single file. Added
;    option to "scale" parametric symbol graphics. Follows GBL_wd_scl_plcbld
;    global scaling factor.
; 14-Dec-01 NEHolt; Sometimes would quit when the "Show unused connections"
;    toggle was selected "ON". Fixed. Made some additional changes to try
;    to avoid rare lock-up when "Ladder Ref: 1st ref num" dialog appears.
; 10-Dec-01 NEHolt; "User" hex line ref symbols not incrementing from
;    one ladder to the next.
; 15-Oct-01 NEHolt; Ladder setup for "User block" or "Ref nums with
;    ruling" not taking effect when drawings generated. Fixed.
; 11-Oct-01 NEHolt; Bad DXF code (10) error on generating output mod.
;    Fixed.
; 04-Oct-01 NEHolt; added "Do not erase unused, blank rungs" toggle
;    to the Ladders Config dialog.
; 15-Aug-01 NEHolt; CSV input file format would skip modules if the
;    "blank" line between module entries had embedded spaces in one
;    or more of the "blank" fields. Fixed.
; 16-Jun-01 NEHolt; XLS file input now defaults to RSLogix XLS file
;    if one was created during this AutoCAD session.
; 28-Feb-01 NEHolt; now preserve 1st dwg's WD CONFIG "Feature scale"
;    and "Unit scale" values from one drawing to the next. Eliminated
;    "Scale" and "Text size" edit boxes on "Gen Config" dialog.
; 19-Feb-01 NEHolt; one change to more accurately determine if 2nd+
;    module can fit into the current ladder.
; 07-Feb-01 NEHolt; eliminate opening the XLS file twice; cleaned up
;    Setting dialog a bit. Automatically move PLC OUTPUT description text
;    over to right hand side of ladder.
; 25-Jan-01 NEHolt; not detecting settings file flag for template use.
;    Auto prompt to save settings changes.
; 11-Jan-01 NEHolt; if CSV file format input and first line is labels
;    and not a blank space between labels and beginning of data then
;    the first module could be missed. Fixed. Multiple blank lines
;    can also cause CSV file format input to skip a module. Fixed.
; 28-Dec-00 NEHolt; problem if first line of spreadsheet data was first
;    line for first module's data instead of column labels (caused first
;    module to be skipped). Now do a better check on first line of data.
; 13-Dec-00 NEHolt/Alan Henthorne; start out with layer set to "0"
; 11-Dec-00 NEHolt; better search for loading wdioa.lsp and wdiob.lsp.
;    Display "alert" box if either file or if wdio.dcl cannot be found
;    in WD support file path or in ACAD support file paths. Also do a
;    cleaner exit if user hits "cancel" instead of going on from one
;    drawing to the next.
; 10-Oct-00 PMM ; separated into 3 files
; 03-Aug-00 NEHolt; one change for "bad argument" if first module is a "SKIP"
; 18-Jul-00 NEHolt; added option to force ladders to insert with hex line ref
;    symbols (instead of line ref numbers). See "(setq refnums 3)" below. Also
;    increment user-entered beginning SHEET number attribute (on the WD_M
;    block) as go from one dwg to the next.
; 14-Jul-00 "Skip, dwg to dwg cnt" not working past 2nd drawing when
;    running Spreadsheet-->PLC I/O utility in "Free run" mode. Fixed. 
; 28-Jun-00 NEHolt; changed order of checking to see what type of module
;    is being inserted (in, out, or both). Now program first checks the
;    type "\T=" value (ex: \T=DI  or \T=IO or \T=DO). If this fails, it
;    checks the short description "\D=" value looking for substrings
;    DI, DO, IO, AI, AO, INP*, OUT*. If this fails, it looks at the "\V="
;    voltage column (if exists) and does the same substring searches. If
;    this fails, it defaults to "In/Out" and puts module down center of column.
; 27-Jun-00 NEHolt; added addition checks when data pulled in from
;    an ".xls" file. Make sure data is all character string data and
;    not a mixture with some integer or real values included.
; 22-Jun-00 NEHolt; added support for annotating stand-alone terminal
;    symbols with terminal number. Encode the TAG column in spreadsheet
;    like this  TAGSTRIP_value:TERM_number. Routine will break out the
;    text after the ":" char and apply it to the TERM01 attribute on the
;    terminal, if present. The text before the ":" will go to the TAGSTRIP
;    attribute. If not a terminal or no TERM01 on the terminal block, then
;    the entire text will go to the TAG* attribute.
; 14-Jun-00 NEHolt; prefill beginning line ref number edit box on the first
;    drawing with "1" (instead of leaving it blank).
; 13-Jun-00 NEHolt; added support for auto-break option when the
;    "\SPECIAL=BREAK" flag is encounterd in a module's block of data
; 31-May-00 NEHolt; preserve TAG name and annotate on to split PLC pieces
; 25-May-00 NEHolt; added COL to COL ref number skip count option (instead
;    of each successive column on a drawing beginning with the very next
;    available line ref number.
; 04-May-00 NEHolt; skip a ladder column (leave it blank) when a given
;    module is not found.
; 02-May-00 NEHolt; added support for "BREAK" in the spreadsheet's ADDR
;    column and "SKIP" in the spreadsheet's CODE part number column (to
;    leave a column blank and skip to the next).
; 10-Apr-00 NEHolt; don't auto-reload "wdio.lsp" after first drawing in
;    case user has created a separate, modified version with same name.
;    Minor change to code that determines if module is input or output.
; 28-Mar-00 NEHolt; added call to (c:wd_setup_d_match_p) to force each
;    new drawing's WD_M block settings to match those carried in the current
;    project's ".wdp" list file.
; 13-Mar-00 NEHolt; experimental.. option to insert circuit instead of
;    series connected device.
; 21-Feb-00 NEHolt/PMMurnen; prompt user for prototype/template
;    for first drawing if a prototype/template is defined below.
;    Moved some settings from Ladder/Config dialog to the "starting"
;    line reference dialog.
; 20-Feb-00 PMMurnen; allow direct read from Excel ".xls" file (in addition
;    to reading from comma-delim ".csv" file)
; 17-Feb-00 NEHolt; conflict with "Skip line ref nums" option. General cleanup.
; 06-Jan-00 NEHolt; undeclared variable problem. Changed xx to i_xx to clean
;    up problem when "sequential component tagging" mode is the drawing's
;    default.
; 04-Jan-00 NEHolt; added R2000 check for SDI mode
; 29-Dec-99 PMMurnen; added option to build modules in same ladder if fit
; 20-Dec-99 NEHolt; Rack/Slot/Group data not getting annotate ed from
;    spreadsheet to module. Fixed in four places.
; 06-Nov-99 NEHolt; added support for "|" embedded in connected device
;    DESC value to break into mult lines of DESC text. Changed user
;    settings for plc_output_device_x_offset and plc_input_x_offset so
;    that values are now measured from right-hand of ladder (not left).
; 14-Oct-99 NEHolt; increased from 4 to 6 series connected devices. Added
;    spreadsheet column support for device DESC1 value (for each of the six).
;    Added support for "SPACER" in addr column to stretch module by one
;    rung distance.
; 28-Sep-99 PMMurnen; optimize for LISPINIT 0, carry variables from one
;    drawing to next.
; 23-Sep-99 NEHolt; filter out word "POINT" when trying to determine if
;    module is an input or output or combo. Giving false hits on combo
;    when it should be an output module.
; 16-Jul-99 NEHolt; chk for embedded space in "useprototype" file name
; 25-Jun-99 NEHolt; chk for embedded space in file name, put quotes around
;    if so.
; 31-May-99 NEHolt; added support for multiple devices tied to each I/O pt
; 18-Feb-99 NEHolt; Now do a better job looking for wd_m.dwg block if it
;    is not found on the drawing at program startup.
; 19-Jun-98 NEHolt; added dwg to dwg ladder ref skip option
; 18-Jun-98 NEHolt; fixed typo in "rung skip" dialog box entry
; 05-Apr-98 NEHolt; Use c:wd_increment_str to increment dwg file names
;    when 2+ drawings required. Option to remove I/O point wiring that has
;    no component assignment (automatically remove "shorts").
; 18-Nov-97 NEHolt; added "Device blk nam" poplist subdialog in wdio.dcl
; 13-Nov-97 NEHolt; some code at top of main routine had to be moved
;    below the "read tmp file" code for R13. Added "group" and "remote term
;    panel" columns.
; 07-Nov-97 NEHolt; provision for use of single PLC block (instead of
;    parametric build from individual parts and pieces)
; 18-Aug-97 NEHolt; provision for "%%A+" spcl address encoding in PLC*.DAT
; 12-Aug-97 NEHolt; added R14 compatibility. Added check to make sure
;    start with drawing with name at least three characters long. Added
;    support to insert connected component MFG,CAT,ASSYCODE values
; 27-Jul-97 NEHolt; misc changes and fixes
; 15-Jul-97 NEHolt; Added more features; more forgiving of what input
;    data file looks like
; 26-Jun-97 NEHolt; Missed "LOC" attrib annotation on components. Added.
; 25-Apr-97 NEHolt; Copyright (c)1997 N8 Solutions, Inc.; created for
;    PLC I/O auto-gen for Rockwell/Allen-Bradley.  419-843-3310
; -----
; -----
(defun user_settings ( / )

; ***  U s e r   S e t t i n g s  -- adjust as required

  ; The following give column index numbers for various pieces of data
  ; pulled from spreadsheet, mdb table, or comma-delimited ascii file. Index 
  ; numbers start at one (1 = 1st column of spreadsheet, 2=2nd,...). Use "0"
  ; for any column index number that doesn't exist in the spreadsheet or mdb table
  ; (ex: (setq comp_loc_ix 0) if there is no component "LOCATION" column
  (setq plc_code_ix 1)  ; PLC catalog code in 1st column of data file
  (setq rack_ix 2) ; PLC rack number column
; ** 12-Mar-07 NEHolt reversed order  - 913659 
  (setq group_ix 4) ; PLC group number column
  (setq slot_ix 3) ; PLC slot number column
; ** 12-Mar-07 NEHolt.end  
  (setq addr_ix 5) ; PLC I/O address column
  (setq wire_tag_ix 5) ; make wire nums same as I/O address
  (setq remote_tp_ix 6) ; PLC remote term panel ID
  (setq desc1_ix 7) ; PLC I/O description column
  (setq desc2_ix 8) ; PLC I/O 2nd line of description
  (setq desc3_ix 9) ; PLC I/O 3rd line of description
  (setq desc4_ix 10) ; PLC I/O 4th line of description
  (setq desc5_ix 11) ; PLC I/O 5th line of description
  (setq volt_ix 12) ; Input or Output module (ex: "INPUTS" or "IN" or "DI")
  (setq comp_tag_ix1 13) ; Connected component TAG name column (ex: "LS123")
  (setq comp_desc_ix1 14) ; Connected comp DESC1|DESC2|DESC3 name column
  (setq comp_blk_ix1 15) ; Connected component block name (ex: "HLS11")
  (setq comp_loc_ix1 16) ; Connected component LOC code column (ex: "FIELD")
  (setq comp_inst_ix1 0) ; Connected component INST code column (ex: "FIELD") ; ** 22-Feb-02 SAH
  (setq comp_mfg_ix1 0) ; Connected component MFG name column (ex: "AB")
  (setq comp_cat_ix1 0) ; Connected component CAT num (ex: "800TP123")
  (setq comp_asm_ix1 0) ; Connected component ASSYCODE code column
  (setq comp_tag_ix2 17) ; 2nd series connected component TAG name column
  (setq comp_desc_ix2 18) ; Connected comp DESC1 name column
  (setq comp_blk_ix2 19) ; 2nd series connected component block name
  (setq comp_loc_ix2 20) ; 2nd series connected component LOC code
  (setq comp_inst_ix2 0) ; 2nd series connected component INST code ; ** 22-Feb-02 SAH
  (setq comp_mfg_ix2 0) ;
  (setq comp_cat_ix2 0) ;
  (setq comp_asm_ix2 0) ;
  (setq comp_tag_ix3 21) ; 3rd series connected component TAG name column
  (setq comp_desc_ix3 22) ; Connected comp DESC1 name column
  (setq comp_blk_ix3 23) ; 3rd series connected component block name
  (setq comp_loc_ix3 24) ; 3rd series connected component LOC code
  (setq comp_inst_ix3 0) ; 3nd series connected component INST code ; ** 22-Feb-02 SAH
  (setq comp_mfg_ix3 0) ;
  (setq comp_cat_ix3 0) ;
  (setq comp_asm_ix3 0) ;
  (setq comp_tag_ix4 25) ; 4th series connected component TAG name column
  (setq comp_desc_ix4 26) ; Connected comp DESC1 name column
  (setq comp_blk_ix4 27) ; 4th series connected component block name
  (setq comp_loc_ix4 28) ; 4th series connected component LOC code
  (setq comp_inst_ix4 0) ; 4nd series connected component INST code ; ** 22-Feb-02 SAH
  (setq comp_mfg_ix4 0) ;
  (setq comp_cat_ix4 0) ;
  (setq comp_asm_ix4 0) ;
  (setq comp_tag_ix5 29) ; 5th series connected component TAG name column
  (setq comp_desc_ix5 30) ; Connected comp DESC1 name column
  (setq comp_blk_ix5 31) ; 5th series connected component block name
  (setq comp_loc_ix5 32) ; 5th series connected component LOC code
  (setq comp_inst_ix5 0) ; 5nd series connected component INST code ; ** 22-Feb-02 SAH
  (setq comp_mfg_ix5 0) ;
  (setq comp_cat_ix5 0) ;
  (setq comp_asm_ix5 0) ;
  (setq comp_tag_ix6 33) ; 6th series connected component TAG name column
  (setq comp_desc_ix6 34) ; Connected comp DESC1 name column
  (setq comp_blk_ix6 35) ; 6th series connected component block name
  (setq comp_loc_ix6 36) ; 6th series connected component LOC code
  (setq comp_inst_ix6 0) ; 6nd series connected component INST code ; ** 22-Feb-02 SAH
  (setq comp_mfg_ix6 0) ;
  (setq comp_cat_ix6 0) ;
  (setq comp_asm_ix6 0) ;
  ; ** 17-Oct-02 ScottH  added below
  (setq comp_tag_ix7 37) ; 7th series connected component TAG name column
  (setq comp_desc_ix7 38) ; Connected comp DESC1 name column
  (setq comp_blk_ix7 39) ; 7th series connected component block name
  (setq comp_loc_ix7 40) ; 7th series connected component LOC code
  (setq comp_inst_ix7 0) ; 7th series connected component INST code
  (setq comp_mfg_ix7 0) ;
  (setq comp_cat_ix7 0) ;
  (setq comp_asm_ix7 0) ;
  (setq comp_tag_ix8 41) ; 8th series connected component TAG name column
  (setq comp_desc_ix8 42) ; Connected comp DESC1 name column
  (setq comp_blk_ix8 43) ; 8th series connected component block name
  (setq comp_loc_ix8 44) ; 8th series connected component LOC code
  (setq comp_inst_ix8 0) ; 8th series connected component INST code
  (setq comp_mfg_ix8 0) ;
  (setq comp_cat_ix8 0) ;
  (setq comp_asm_ix8 0) ;
  (setq comp_tag_ix9 45) ; 9th series connected component TAG name column
  (setq comp_desc_ix9 46) ; Connected comp DESC1 name column
  (setq comp_blk_ix9 47) ; 9th series connected component block name
  (setq comp_loc_ix9 48) ; 9th series connected component LOC code
  (setq comp_inst_ix9 0) ; 9th series connected component INST code
  (setq comp_mfg_ix9 0) ;
  (setq comp_cat_ix9 0) ;
  (setq comp_asm_ix9 0) ;
  ; * * *
; ** 23-May-02 NEHolt added below
  (setq plc_inst_ix 0) ; PLC module's INST value
  (setq plc_loc_ix 0) ; PLC module's LOC value
; ** 07-Jun-02 NEHolt
  (setq plc_mod_tag_ix 0) ; PLC module's TAG-ID value
; ** 13-Oct-06 Mei added for Unity Pro variable name and type  
  (setq unity_varname_ix 49)
  (setq unity_vartype_ix 50)
; **
  (setq scale 1.0)  ; insert components at this scale
  ; *** 12-Oct-00 PMM
  (setq tsize 0.125)
  (setvar "TEXTSIZE" tsize) ; default non-attrib text size

; ** 07-Feb-05 jdz
  ; Modified coordinates to match up with D-Size DEMO Template; value was 2.0, 9.0 - 1.5, 21.5
  ; Hard code the coordinates of the upper left-hand corner of the
  ; first (or only) ladder that you want inserted on to your blank drawing.
  ; Ex: (setq first_ladder_XY_org '(2.0 9.0))
  (setq first_ladder_XY_org '(1.5 21.5)) ; upper left XY of 1st ladder

  ; Modified values of ladder width & distance to match up with D-Size DEMO Template; (width 8.5 - 10 / Dist 12.0 - 15.0)
  (setq ladder_cnt 2) ; number of ladders per drawing
  (setq ladder_width 10.0) ; ladder width
  (setq ladder_2_ladder_dist 15.0) ; horiz dist from ladder to ladder

; ** 18-Jul-00 NEHolt
  ; Uncomment the (setq refnums...) line below to force ladder ref nums to a specific
  ; mode: 1 for line ref numbers, 2 for line ref with ruling, 3 for user "hex"
  ; symbol references, 4 for X-Y grid referencing (i.e. no line ref numbers)
  ; Comment the line out to let it default to whatever is set on the "WD_M"
  ; block present or inserted on to the drawing.
;;;  (setq refnums 3) ; 3 = use HEX line reference numbers along edge of ladder


  (setq rung_spacing 1.0) ; vertical spacing from one rung to the next
  (setq usr_rv rung_spacing) ; I/O vertical spacing (normally set to same
     ; value as "rung_spacing"
  (setq ladder_rung_cnt 21) ; number of rungs per ladder column
  (setq rung_skip 0) ; draw every other rung
                     ; = 0 to draw all,  = 1 to skip every other rung, =-1 to suppress all rungs                     
                     ; = -2 to suppress bus and rungs 

  (setq max_pnt_cnt_per_ldr 19) ; max number of points to insert per column
  (setq plc_style 1) ; PLC "style" number
  (setq arrow_style 4) ; SRC/DEST "style" number (for hot/neutral bus arrows)

  (setq plc_input_x_offset 1.0) ; offset from right for input module
  (setq plc_output_x_offset 1.0) ; offset from left for output module
  ; Connected INPUT devices -- insert offset from left side of ladder
  (setq plc_input_device_x_offset 1.0)
  ; Connected OUTPUT devices -- insert offset right-most device measured from
  ; left side of ladder
  (setq plc_output_device_x_offset 0.25)
; ** 27-May-99 NEHolt
  ; Increment distance between multiple devices inserted in series
  (setq plc_series_device_spacing 0.75)
; **

  ; Keep I/O connected wire if no component inserted (1=yes,keep, 0=no,erase)
  (setq plc_keep_shorted_wire 0)
  
  (setq suppress_rails nil) ; ** 06-Jun-02 NEHolt draw the side rails of ladder
  (setq suppress_rungs nil) ; ** 09-Jul-02 NEHolt insert ladder "rungs" on ladder

  ; Start plc module down "x" rung refs from top of ladder
  ; "(setq plc_insert_y_offset_rungs_down 0)" means start at top rung)
  (setq plc_insert_y_offset_rungs_down 1)

  ; When the utility must go to a new drawing, you can instruct it to
  ; use a specific prototype drawing. Enter full path below. Use "/"
  ; forward slashes or "\\" double backslashes!. For no prototype,
  ; set the value to ".". For the default, set the value below to "".  ; ** 15-Feb-02
  ; Make sure your prototype has NO ladders pre-inserted on it.
  (setq useprototype "ACAD_ELECTRICAL.dwt") ; ** 15-Feb-02 NEHolt
  ; *** 29-Dec-99 PMM
  (setq always_start_at_top "0") ; start each module at the top of the next ladder
  (setq rung_skip_btwn_module 2) ; used if trying to fit modules in same ladder
;  (setq always_start_at_top "1") ; put module in current ladder if completely fits
;  (setq always_start_at_top "2") ; put module in current ladder, allow splits
; ** 05-May-02 NEHolt
  (setq h_or_v_rungs "H") ; horiz rungs, vertical ladders is the default
)
; --
(defun wdio_err (s) ; error handler
  (if (/= s (c:wd_msg "GEN036" nil "Function cancelled"))
      (princ (strcat "\n" (c:wd_msg "SS2DWG011" nil "Error:") " " s))
  )
  (command "_.UNDO" "_E")
  (if GBL_wd_#cmdecho (setvar "CMDECHO" GBL_wd_#cmdecho))      ; Restore saved modes
  (if GBL_wd_#osmode (setvar "OSMODE" GBL_wd_#osmode))
  (if GBL_wd_wdio_#attreq (setvar "ATTREQ" GBL_wd_wdio_#attreq)) ; ** 02-Aug-03 NEHolt
  (if GBL_wd_#blipmode (setvar "BLIPMODE" GBL_wd_#blipmode))
  (if GBL_wd_#snapmode (setvar "SNAPMODE" GBL_wd_#snapmode))

  ;16-Jul-2004 PanQ, Change for MDI
  (if (AND #lispinit (= (getvar "SDI") 1)) (setvar "LISPINIT" #lispinit)) ; *** 28-Sep-99
  ;**

  ;16-Jul-2004 PanQ, Change for MDI
  ;(setq *error* err_old)            ; Restore standard *error* handler
; ** 16-Feb-05 LeeH  
  (if (= (getvar "SDI") 1)
    (setq *error* err_old)            ; Restore standard *error* handler
  )
; **
  (princ)
)


; --
(defun wdio_chk4_longfname ( str / hit rtrn slen ix )
  ; Look for embedded spaces in file name. Put double quotes around if so
  (setq rtrn str)
  (setq hit nil)
  (if str
    (progn
      (setq slen (strlen str))
      (setq ix 1)
      (while (AND (not hit) (< ix slen))
        (if (= (substr str ix 1) " ") (setq hit 1)) ; found space
        (setq ix (1+ ix))
      )
      (if (AND hit (/= (substr str 1 1) "\""))
         (setq rtrn (strcat "\"" str "\""))) ; add double quote delims
  ) )
  rtrn
)
; -- ** 26-May-02 NEHolt
(defun c:wdio ( / )
  (setq GBL_wd_wdio_autorun nil) ; remember called normally
  (wdio_main nil)
  (princ)
)
; --
(defun c:wdio_autorun ( param_lst / )
  ; "param_lst" = list
  ;   nth 0 = xls or csv input file to use
  ;   nth 1 = nil or ".wdi" settings file to use 
  ;   nth 2 = nil or list of dwg file names to use for 2nd+ dwgs generated.
  ;           If =nil then will increment the last char of the starting dwg name.
  ;   nth 3 = mdb or xls "table" name, nil or missing defaults to "Sheet1" if present
  ;   nth 4 = Starting drawing file name: nil=use active named drawing 
  ;   nth 5 = "other_options": nil=none; 
  ;                            1's bit set=pause to display main dialog
  ;                            2's bit set=save new dwgs to active project
  ;
  (setq GBL_wd_wdio_autorun 1) ; remember called from this entry point
  (wdio_main param_lst)
  (princ)
)
; --
(defun wdio_main ( param_lst / xitflg picking pickit save_GBL_wd_scl_plcbld save_GBL_wd_scl_plc_borderonly)
  ; -- internal --
  (defun read_xls_mdb_csv_file ( ss_fnam_ext ss_fnam / xlst csv_delim_ch ss rtn )                                
    (if Aw_debug (princ "\nIN:read_xls_mdb_csv_file"))
    (cond
      ((OR (= ss_fnam_ext "XLS")(= ss_fnam_ext "MDB")) 
        (if (AND (not tabnam) (not xlsdata)) ; haven't read it yet
          (progn
            (setq tabnam (wdio_get_tabnam ss_fnam ss_fnam_ext))
            (if (not tabnam) (exit))
            (princ (strcat "\n " (c:wd_msg "FPMDB009" (list tabnam) "Table: %1")))
            (setq x (wdio_read_xls_or_mdb_data ss_fnam tabnam ss_fnam_ext))
            (setq xlsdata (car x))            
            (setq fieldnames (cadr x)) ; ** 13-Nov-05 Mei ; ** 12-Mar-07 NEHolt - 914341 reuse original variable "fldnams"
            
        ) )
      )
      (T ; CSV ascii text format
        (setq f nil)
        (if ss_fnam
          (progn ; open the file for "read"
            (setq f (open ss_fnam "r"))
        ) )
    ) )
    (setq mod_data '())
    (setq plc_module_found '())
    (setq plc_data_found '())
    (setq parallel_skip_lst '())
    (setq mod_data_parallel_skip '())
    (setq spacer_skipcnt nil)
    ; Read in the spreadsheet data, either XLS/MDB or CSV ascii text format
    (if (AND ladder_first_ref (OR (/= f nil) (= ss_fnam_ext "XLS")(= ss_fnam_ext "MDB"))) 
      (progn
        (setq xitflg nil)
        (setq csv_data '())
        (setq plc_data '())
        (setq doing_module nil)
        (setq last_was_spacer 1) ; preset
        ; Check each line of spreadsheet csv data file
        (setq iii 0) 
        (setq csv_delim_ch (c:ace_getlocalelistsep)) ; Get csv_delim_ch 
        (while (not xitflg)
          (setq dline nil)
          (if (OR (= ss_fnam_ext "XLS")(= ss_fnam_ext "MDB"))
            (progn ; Excel or Access format
              (setq lst (nth iii xlsdata))
              (if lst (setq dline (wdio_lst_to_delim_str lst ",")))
            )
          ; ELSE
            (progn ; CSV ascii format
              (setq dline (read-line f))
              (if dline
                (progn
                  (setq lst (c:wd_delim_str_to_lst dline csv_delim_ch)) 
                  (if lst
                    (progn
                      (setq xx nil)
                      (foreach x lst ; remove any leading blanks
                        (if x
                          (progn
                            (while (AND (> (strlen x) 0) (= (substr x 1 1) " "))
                              (setq x (substr x 2))
                        ) ) )      
                        (setq xx (cons x xx))
                      )                  
                      (setq lst (reverse xx))
                  ) )

                  ; CSV read and blank line, fake in a blank list
                  (if (not lst) (setq lst (list "" "" "" "" "" "" "" "" "" "" "" "" "" "" "" "" "" "" "" "" "" "")))
                  (if (AND (= iii 0) (> plc_code_ix 0)) ; First line of data
                    (progn ; Check first line of data, could either be the
                         ; column labels or 1st line of 1st module's data
                         ; or a blank line
                      (setq fieldnames lst) ; ** 24-Nov-06 Mei Added for Unity Pro    ; ** 12-Mar-07 NEHolt reuse "fldnams"
                      (setq plc_code (nth (1- plc_code_ix) lst))
                      ; Look for data for this potential plc_code                                            
                      (if (OR (= plc_code "CODE") ; ** 05-May-02 ignore first line if part number is "CODE"                      
                              (not (c:wd_find_sel_plc (list plc_code plc_style fullmm))))
                        (progn ; appears first line is labels, get next line
                          (setq dline (read-line f))
                          (if dline
                            (progn
                              (setq lst (c:wd_delim_str_to_lst dline csv_delim_ch))
                              (if (not lst) (setq lst (list "")))
          ) ) ) ) ) ) ) ) ) )
          (if (= dline nil) (setq xitflg 1)) ; flag to exit when EOF hit
          ; Process the line of data just read in from XLS/MDB or CSV ascii text file
          (if (not xitflg)
            (progn
              (if (OR (wcmatch (ace_strcase (car lst)) "SKIP*")
                      (wcmatch (ace_strcase (car lst)) "NEW_DWG*")) ; ** 18-Jul-07 NEHolt
                (progn ; Hit a "SKIP" plc_code part number. Trigger one
                  ; ladder skip before starting next module. Fake in
                  ; a blank line before and after the "SKIP" entry
                  ; to make sure that this new "module" is recoginized
                  (setq xlst (list (cons "" (cdr lst)) lst (cons "" (cdr lst))))
                )
              ; ELSE
                (setq xlst (list lst)) ; Any other line (other than "SKIP")
              )
              (foreach lst xlst  ; process the single line (or 3 if "SKIP")
                (setq plc_code nil)
                ; Look for PLC catalog number code in this line of data
                (if (AND (> plc_code_ix 0) lst (nth (1- plc_code_ix) lst))
                  (setq plc_code (nth (1- plc_code_ix) lst)))
                  
                (setq addr_val nil)
                (if (AND (> addr_ix 0) lst (nth (1- addr_ix) lst))
                  (setq addr_val (ace_strcase (nth (1- addr_ix) lst)))) ; get ADDR value

; ** 02-May-00 NEHolt
              (cond
                ((not plc_code)
                   (setq last_was_spacer 1)
                   (setq doing_module nil)
                )
                ((wcmatch (ace_strcase plc_code) "SKIP*")
                   (setq last_was_spacer 1)
                )
                ((= plc_code "")
                  (setq last_was_spacer 1)
                  (if (OR
                         (AND (> addr_ix 0) (/= (nth (1- addr_ix) lst) ""))
                         (AND (> desc1_ix 0) (/= (nth (1- desc1_ix) lst) "")))
                    (progn ; assume not a spacer line
                      (setq last_was_spacer nil)
              ) ) ) )
; **
              (if (AND plc_code last_was_spacer (/= plc_code ""))
                (progn ; hit beginning of next module
                  (setq last_was_spacer nil)
                  (setq doing_module 1)
                  (if csv_data
                    (progn ; save previous data
                      (if plc_data
                        (progn ; found data. Save it.
                          (setq mod_data (cons (cons plc_data (reverse csv_data))
                                 mod_data))
                          (setq csv_data '())
                          (if spacer_skipcnt (setq parallel_skip_lst (cons spacer_skipcnt parallel_skip_lst)))
                          (setq parallel_skip_lst (reverse parallel_skip_lst))
                          (setq mod_data_parallel_skip (cons parallel_skip_lst mod_data_parallel_skip))
                          (setq parallel_skip_lst '())
                          (setq spacer_skipcnt nil)
                      ) )
                      (setq plc_data '())
                  ) )
                  (cond
                    ((/= plc_code nil)                                                           
                      ; Look for data for this module
                      ; Check if searched for this one already
                      (if (setq x (member plc_code plc_module_found))
                        (progn
                          (setq plc_data (nth (- (length plc_module_found)
                                 (length x)) plc_data_found))
                        )
                      ; ELSE
                        (progn ; not found previously. Look for it.
; ** 02-May-00 NEHolt
                          (if (OR (wcmatch (ace_strcase plc_code) "SKIP*")
                                  (wcmatch (ace_strcase plc_code) "NEW_DWG*"))
                            (progn ; "SKIP" in the part number column. Flag
                                   ; to skip to next ladder column
                              (if (wcmatch (ace_strcase plc_code) "SKIP*")     
                                (setq plc_data (list (list "SKIP" nil nil)))
                              ; ELSE
                                (setq plc_data (list (list "NEW_DWG" nil nil)))
                              )  
                            )
                          ; ELSE
                            (progn
; ** 29-Dec-05 NEHolt                            
                              (if (not fullmm)
                                (progn ; need to confirm whether "Full mm" mode is set on active drawing
; ** 07-Feb-06 NEHolt
                                  ; Quietly add WD_M block to active dwg if it is not present
                                   (setq ss (ssget "_X" '((-4 . "<AND")(0 . "INSERT")(2 . "WD_M")(-4 . "AND>")) ))
                                   (if (= ss nil)
                                     (progn ; WD_M block not present. Insert it.
                                       (if (setq x (c:wd_does_block_exist "WD_M")) ; look in AcadE paths for wd_m.dwg
                                         (progn ; Found path to wd_m.dwg, insert it
; ** 10-Mar-06 NEHolt force attribute prompt mode "OFF"                                         
                                           (setq xx (getvar "ATTREQ"))
                                           (setvar "ATTREQ" 0) 
; **                                            
                                           (command "_.INSERT" x "0,0" "" "" "")
                                           (if xx (setvar "ATTREQ" xx)) ; ** 10-Mar-06 NEHolt restore
                                           (princ (strcat "\n " (c:wd_msg "IO016" nil "Inserted WD_M block") " "))
                                           (princ x)
                                           ; If an AcadE project is active then make this new drawing's WD_M block
                                           ; setting match those carried in the overall project "wdp" file.
                                           (c:wd_setup_d_match_p)
                                   ) ) ) ) 
; ** 07-Feb-06 NEHolt.en
                                  (c:wd_reread_dwg_params)
                                  (if (AND GBL_wd_m (nth 50 GBL_wd_m))
                                    (progn ; check if "Full mm" bit set in WD CONFIG for this dwg     
                                      (setq x (atoi (nth 50 GBL_wd_m)))
                                      (if (= (logand x 1) 1) (setq fullmm 1))
                              ) ) ) )
; ** 29-Dec-05 NEHolt.en                                                              
                              (setq plc_data (c:wd_find_sel_plc (list plc_code plc_style fullmm)))  ; ** 09-Dec-03 NEHolt added "plc_style"                              

                          ) )
; **

                          ; Save this entry for possible reuse later, even
                          ; if not found
; ** 04-May-00 NEHolt
                          (if (not plc_data)
                            (progn
                              (princ (c:wd_msg "IO005" (list plc_code) "No match found in PLC database for: \"%1\""))
                              (if (AND (/= plc_code "CODE")
                                       (not (member plc_code notfoundlst)))
                                (setq notfoundlst (cons plc_code notfoundlst))
                              )
                              ; module data not found. Substitute a "SKIP"
                              (setq plc_code "SKIP")
                              (setq plc_data (list (list "SKIP" nil nil)))
                            )
                          ; ELSE
                            (princ (strcat " " (c:wd_msg "IO004" (list plc_code) "found %1")))
                          )
                          (setq plc_module_found (cons plc_code plc_module_found))
                          (setq plc_data_found (cons plc_data plc_data_found))
; **
                    ) ) ) 
                  ; ELSE
                    (setq plc_data '())
                  )
                  (if plc_data
                    (progn ; found block of data for this PLC catalog num
                      ; *** 01-Mar-99 PMM if showing unused connections,
                      ; \SPECIAL=INCLUDE then use (nth 2 plc_data)                   
                      (if (AND GBL_wd_iflg (= GBL_wd_iflg "1")
                                           (nth 2 plc_data)) ; ** 14-Dec-01 NEHolt
                        (progn
                          (setq plc_data (list (car plc_data) (nth 2 plc_data)))
                      ) )    
                      ; ***
                      (setq point_cnt (length (cadr plc_data)))
                      (setq csv_data (cons (list lst) csv_data)) ; save this spreadsheet row entry
; ** 17-Feb-00 NEHolt
;                      (setq skipcnt 0)
                      (setq spacer_skipcnt 0)
; **
                      (setq doing_module 1)
                    )
                  ; ELSE
                    (progn ; didn't find data -- assume break between modules
                      (setq doing_module nil)
                      (setq last_was_spacer 1)
                ) ) )
              ; ELSE
                (progn
                  (if doing_module
                    (progn
                      (if (AND addr_val (/= addr_val "")(wcmatch addr_val "SPACE*"))
                        (progn ; hit "SPACER" marker in addr column. Assume that
                               ; must skip a rung after prev I/O addr point
; ** 17-Feb-00 NEHolt
;                          (if skipcnt (setq skipcnt (1+ skipcnt)))
                          (if spacer_skipcnt (setq spacer_skipcnt (1+ spacer_skipcnt)))
; **
                          (setq x (car csv_data))
                          (setq x (cons lst x))
                          (setq csv_data (cons x (cdr csv_data)))
                        )
                      ; ELSE
                        (progn
                          ; Save prev addr point's parallel skip count
; ** 17-Feb-00 NEHolt
;                          (if skipcnt (setq parallel_skip_lst (cons skipcnt parallel_skip_lst)))
                          (if spacer_skipcnt (setq parallel_skip_lst (cons spacer_skipcnt parallel_skip_lst)))

;                          (setq skipcnt 0) ; reset
                          (setq spacer_skipcnt 0) ; reset
; **
                          (setq csv_data (cons (list lst) csv_data)) ; save this spreadsheet row entry
)
          ) ) ) ) ) ) ) )
          (setq iii (1+ iii)) ; *** 14-Feb-00 PMM
        ) ; end while
        (if (AND (/= ss_fnam_ext "XLS")(/= ss_fnam_ext "MDB"))
          (close f)
        )
        (setq f nil)

        (if csv_data
          (progn
            (if (not plc_data)
              ; error, didn't find match in any PLC data file
              (princ (c:wd_msg "GEN003" nil "not found"))
            ; ELSE  save final data
              (progn
                (setq mod_data (cons (cons plc_data (reverse csv_data)) mod_data))
; ** 17-Feb-00 NEHolt
;                (if skipcnt (setq parallel_skip_lst (cons skipcnt parallel_skip_lst)))
               (if spacer_skipcnt (setq parallel_skip_lst (cons spacer_skipcnt parallel_skip_lst)))
; **
                (setq parallel_skip_lst (reverse parallel_skip_lst))
                (setq mod_data_parallel_skip (cons parallel_skip_lst mod_data_parallel_skip))
                (setq parallel_skip_lst '())
; ** 17-Feb-00 NEHolt
;                (setq skipcnt nil)
                (setq spacer_skipcnt nil)
; ****
              )
            )
        ) )
      )
    )
    (setq mod_data_parallel_skip (reverse mod_data_parallel_skip))
    (if mod_data (setq mod_data (reverse mod_data))) ; put back in original order
    (if (not mod_data)
      (progn ; No data
; ** 23-Oct-07 NEHolt - 991766
        (setq x (findfile "wdio.dcl"))
        (if (not x) (setq x (findfile (strcat wdio_sup_path "wdio.dcl"))))
        (if x
          (progn      
            (setq dcl_id (load_dialog x))
; ** 23-Oct-07 NEHolt.end        
            (if (new_dialog "wdio_nodata_found" dcl_id)
              (start_dialog)
              (unload_dialog dcl_id)
        ) ) )
        (setq mod_data nil) ; flag to quit now
    ) )
    (if (AND mod_data notfoundlst
             (/= GBL_wd_wdio_autorun 1)) 
      (progn ; one or more module codes not found AND not running "AUTORUN" version
        ; show a dialog of list in case want to quit
; ** 23-Oct-07 NEHolt - 991766
        (setq x (findfile "wdio.dcl"))
        (if (not x) (setq x (findfile (strcat wdio_sup_path "wdio.dcl"))))
        (if x
          (progn      
            (setq dcl_id (load_dialog x))
; ** 23-Oct-07 NEHolt.end        
            (if (new_dialog "wdio_notfound" dcl_id)
              (progn
                (setq cncl nil)
                (start_list "notfound")
                (mapcar 'add_list notfoundlst)
                (end_list)
                (action_tile "cancel" "(setq cncl 1)(done_dialog)")
                (action_tile "accept" "(done_dialog)")
                (start_dialog)
                (unload_dialog dcl_id)
                (if cncl 
                  (progn
                    (setq mod_data nil) ; quit
            ) ) ) )
          )
        ) 
    ) )
    (if Aw_debug (princ "\nOUT:read_xls_mdb_csv_file"))
    mod_data ; nil= quit now, no good data or problem
  )
; -- ** 25-Jan-01 NEHolt made it a subroutine
  (defun chk4_prototype_use ( / x xx )
    (if (AND useprototype (/= useprototype "")
                          (/= useprototype ".")) ; ** 15-Feb-02 NEHolt
      (progn ; prototype/template dwg is defined. Ask user if this utility
             ; needs to insert the prototype on to this first drawing.
; ** 18-Feb-03 NEHolt             
        ; Difficulty in AutoCAD inserting a ".dwt" template file into an existing dwg
        (setq x (c:wd_split_fnam useprototype)) ; ** 20-Feb-04 NEHolt
        (if (AND x (= (ace_strcase (caddr x)) ".DWG")) ; template is a ".dwg" file, not a ".dwt" file              
          (progn ; OK to prompt user for permission to insert template dwg now on starting dwg
; **        

            (if (setq xx (c:wd_does_block_exist useprototype))(setq useprototype xx)) ; remember prototype "dwg" full path name ** 26-Oct-03 NEHolt

            (setq x (findfile "wdio.dcl"))
            (if (not x) (setq x (findfile (strcat wdio_sup_path "wdio.dcl"))))
            (if (not x)
              (progn
                (princ (c:wd_msg "GEN074" (list "wdio.dcl") "File %1 not found"))
                (quit)
            ) )        
            (setq dcl_id2 (load_dialog x))
            (setq x nil)
            (if (not (new_dialog "wdio_ins_template" dcl_id2))
              (progn
                (if (= (ace_strcase (getstring (strcat "\n" (c:wd_msg "IO027" nil "Insert template now (Y/N)? :")))) (c:wd_msg "GEN088" nil "Y"))
                  (setq x 1)
              ) )
            ; ELSE
              (progn ; use dialog
                (action_tile "accept" "(setq x 1)(done_dialog)")
                (action_tile "no" "(setq x nil)(done_dialog)")
                (start_dialog)
                (unload_dialog dcl_id2)
            ) )
            (if x
              (progn
                (setq x (getvar "ATTREQ"))
                (setvar "ATTREQ" 0) ; so it doesn't prompt for ATTRIB values
                (if useprototype ; ** 26-Oct-03 NEHolt
                  (progn
                    (command "_.INSERT" (strcat "*" useprototype) "0,0")                 
                    (setq xx 6)
                    (while (AND (> xx 0)(/= (getvar "CMDACTIVE") 0))
                      (command "")(setq xx (1- xx)))
                    (setvar "ATTREQ" x) ; restore original setting
                    (command "_.ZOOM" "_EXTENTS") ; ** 26-Oct-03 NEHolt
        ) ) ) ) ) )
    ) )
  )
  ; --
  (defun wdio_autorun_set_settings ( param_lst / x rtn) 
    (if Aw_debug (princ "\nIN:wdio_autorun_set_settings"))   
    (if (not GBL_wd_iflg) (setq GBL_wd_iflg "0")) ; default to not show unused
    (setq colskipcnt 1)
    (setq skipcnt 1)

    (setq dwg_pause "N")
    (setq ladder_first_ref "1")
    (setq dwg_ladder_first_ref "1")
    (setq indx "1")
    (setq sheet_str "")
    (setq use_colskip 0)
    (setq use_skip 0)
    (setq GBL_wd_PLC_autobreak "1")
    (setq rung_skip_btwn_module 2)
    (setq always_start_at_top "0")
    (setq do_module_spacing 0)
    (setq h_or_v_rungs "V") ; "V"=vert rungs, horiz ladders, "H"=horiz rungs, vert ladders    
    
    (user_settings) ; read in default, hard-coded settings

    (if (AND (nth 1 param_lst)(/= (nth 1 param_lst) nil) (/= (nth 1 param_lst) ""))
      (progn
        (setq cfg_fnam (nth 1 param_lst)) ; passed ".wdi" file name
        ; Make sure has wdi extension
        (setq x (c:wd_split_fnam cfg_fnam))
        (setq cfg_fnam (strcat (car x) (cadr x) ".wdi"))
        (princ (strcat "\n " (c:wd_msg "IO009" (list cfg_fnam) "Settings \".wdi\" file: %1")))
        (wd_wdio_read_settings_data cfg_fnam) ; read file's settings into memory
    ) )
; ** 29-Aug-06 NEHolt    
    ; Figure out starting drawing file name
    
    (setq rtn 1) ; default good return, no dialogs
    (if (setq x (nth 5 param_lst))
      (progn     
        (if (= (type x) 'STR)(setq x (atoi x)))
        (if (= (logand x 2) 2)
          (setq GBL_wd_wdio_add2proj "1") ; flag to add new dwgs to active project
        ; ELSE
          (setq GBL_wd_wdio_add2proj "0")
        )  
        (if (= (logand x 1) 1)
          (setq rtn 2) ; open starting dialog, otherwise auto-start with no dialogs
    ) ) )             
    (if (not (nth 4 param_lst))
      (progn ; no "starting drawing" passed. Use active drawing but it needs to be a
             ; "named" drawing.
; ** 28-Jan-08 Mei	    
        (if (and x (= (logand x 1) 1)) ; open starting dialog
          (setq GBL_wd_wdio_start_fnam "") ; check the use active drawing check box
        ; else
          (progn
            (if (= (getvar "DWGTITLED") 1)
              (progn
                (setq x (wd_4_all_slashes_backward (getvar "DWGPREFIX"))) ; current dwg path
                (setq xx (c:wd_split_fnam (getvar "DWGNAME"))) ; cur dwg name
                (setq GBL_wd_wdio_start_fnam (strcat x (cadr xx) (caddr xx)))
              )
          ; ELSE
            (progn ; problem, cannot start with unnamed drawing
              (if (/= rtn 2)
                (progn ; no opening dialogs, go ahead and exit now
                  (princ "\n")
                  (princ (c:wd_msg "GEN021" nil "This is an unnamed drawing. SAVE the drawing and then re-run the command"))
                  (princ "\n")
                  (setq rtn nil) ; flag problem
          ) ) )
        ) ) )	
      )
    ; ELSE
      (progn ; Starting drawing file name passed in command line
        (setq GBL_wd_wdio_start_fnam (nth 4 param_lst))
      )
    )
        
    (if Aw_debug (princ "\nOUT:wdio_autorun_set_settings"))   
    rtn ; nil=problem, 1=okay to run (no dialogs), 2=okay to auto-run (show dialogs)
; ** 29-Aug-06 NEHolt.en    
  )
; --

; ** 22-Aug-06 NEHolt
  (defun wd_wdio_main_dialog ( firstdwg / x cancel_1 dclfnam dcl_id xitflg)
    ; "firstdwg" = 1 if dlg display on start-up of utility, first drawing
    ;            = nil for 2nd+ dwg dialog display for next dwg line ref, etc.
    (defun do_module_spacing ( md which / )
      (mode_tile "txt_mspac1" md)
      (mode_tile "txt_mspac2" md)
      (mode_tile "mod_2_mod_spacing" md)
      (cond
        ((= which 1)
          (set_tile "fit_module" "0")
          (set_tile "split_module" "0")
        )
        ((= which 2)
          (set_tile "start_at_top" "0")
          (set_tile "split_module" "0")
        )
        ((= which 3)
          (set_tile "start_at_top" "0")
          (set_tile "fit_module" "0")
        )
      )
    )
    ; --
    (defun disable_line_ref ( / )
      (mode_tile "firstaddr" 1)
      (mode_tile "indx" 1) 
      (mode_tile "colcont" 1)
      (mode_tile "colskip" 1)
      (mode_tile "colskipcnt" 1)
      (mode_tile "cont" 1)
      (mode_tile "skip" 1)
      (mode_tile "skipcnt" 1)
    ) 
    ; --
    (defun wdio_setfnam_editbox ( cfg / fullname x xx ixx hit)
      (if (not (setq fullname cfg))(setq fullname ""))
      (cond
        ((= fullname "")
          (set_tile "setfnam" "")
          (set_tile "setfnam1" "") ; 1st line of full path
          (set_tile "setfnam2" "") ; 2nd line of full path
        )
        (T
          (setq x (c:wd_split_fnam fullname))
          (if (AND (cadr x)(caddr x))
            (progn
              (set_tile "setfnam" (strcat (cadr x) (caddr x)))
              ; Split a long file name across both "setfnam1" and "setfnam2"
              (cond
                ((= (car x) "")
                  (set_tile "setfnam1" "")
                  (set_tile "setfnam2" "")
                )
                ((< (strlen (car x)) 95)
                  (set_tile "setfnam1" (car x))
                  (set_tile "setfnam2" "")
                )
                (T
                  (setq x (wd_4_all_slashes_backward (car x))) ; x=just the path, no file name
                  (setq hit nil)
                  (foreach xx (list 80 70 60 50 40)
                    (if (AND (not hit)
                             (setq ixx (wd_1_strchr2 x "\\" xx nil))
                             (< ixx 90))
                      (progn    
                        (setq hit 1)
                        (set_tile "setfnam1" (substr x 1 ixx))
                        (set_tile "setfnam2" (substr x (1+ ixx)))
                  ) ) )   
              ) )    
          ) )
        )
    ) )
    ; -- Settings file name "Browse..." button
    (defun browse_setup_button ( / old )
      (setq old GBL_wd_wdio_cfg_fnam) ; save old value before do file selection
      (wd_wdio_read_settings nil)      
      (if (/= val GBL_wd_wdio_cfg_fnam)
        ; re-check status of radio buttons and toggles
        (wdio_main_set_tile_module_placement) ; set radio buttons and toggles in "Module Placement" part of main dialog
      )  
      (wdio_setfnam_editbox GBL_wd_wdio_cfg_fnam)
    )  
    ; -- Settings edit box change
    (defun read_setfnam_editbox ( val / x old )
      ; User entered value into or erased or changed focus out of this "Settings:" edit box
      (setq old GBL_wd_wdio_cfg_fnam)    
      (setq x (wd_wdio_read_settings val))
      (if (/= old GBL_wd_wdio_cfg_fnam)
        (progn ; re-check status of radio buttons and toggles
          (wdio_main_set_tile_module_placement) ; set radio buttons and toggles in "Module Placement" part of main dialog
      ) )
      (if (AND (= x "")(/= val ""))
        (progn ; manually typed in file name probably not found, blank out the edit box
          (set_tile "setfnam" "")
          (set_tile "setfnam1" "")
          (set_tile "setfnam2" "")
        )
      ; ELSE
        (progn
          (wdio_setfnam_editbox x)
    ) ) ) 
    
    ; -- Drawing File Creation - "Starting file name" edit box change
    (defun wdio_startfnam_editbox ( dwgfnam / fullname x xx ixx hit)
      (if (not (setq fullname dwgfnam))(setq fullname ""))
      (cond
        ((= fullname "") ; Edit box is blank
          (set_tile "start_fnam" "")
          (set_tile "startpath1" "") ; 1st line of full path
          (set_tile "startpath2" "") ; 2nd line of full path
        )
        (T
          (setq x (c:wd_split_fnam fullname))
          (if (= (car x) "")
            (progn ; User entered dwg name but no path.
              (cond
                ((AND (OR (not GBL_wd_wdio_start_fnam)(= GBL_wd_wdio_start_fnam ""))
                      GBL_wd_prj)
                  ; Previous starting drawing file name not known. Default to
                  ; putting this drawing into the same folder as current project's
                  ; ".wdp" file.
                  (setq fullname (strcat (car (c:wd_split_fnam GBL_wd_prj)) fullname))
                )
                ((AND GBL_wd_wdio_start_fnam (/= GBL_wd_wdio_start_fnam ""))
                  ; Use path to previously defined drawing as path for this new one
                  (setq fullname (strcat (car (c:wd_split_fnam GBL_wd_wdio_start_fnam)) fullname))
                )
              )
              (setq x (c:wd_split_fnam fullname))
          ) )
                  
          (if (AND (cadr x)(caddr x))
            (progn ; drawing name 
              (setq GBL_wd_wdio_start_fnam (strcat (car x) (cadr x) ".dwg"))
              ;** 30-Mar-2007 LongFan: should not fill the edit box
              (set_tile "start_fnam" (strcat (cadr x) (caddr x)))              
              ;**

              ; Split a long file name across both "setfnam1" and "setfnam2"
              (cond
                ((= (car x) "")
                  (set_tile "startpath1" "")
                  (set_tile "startpath2" "")
                )
                ((< (strlen (car x)) 95)
                  (set_tile "startpath1" (car x))
                  (set_tile "startpath2" "")
                )
                (T
                  (setq x (wd_4_all_slashes_backward (car x))) ; x=just the path, no file name
                  (setq hit nil)
                  (foreach xx (list 80 70 60 50 40)
                    (if (AND (not hit)
                             (setq ixx (wd_1_strchr2 x "\\" xx nil))
                             (< ixx 90))
                      (progn    
                        (setq hit 1)
                        (set_tile "startpath1" (substr x 1 ixx))
                        (set_tile "startpath2" (substr x (1+ ixx)))
                  ) ) )   
              ) )    
          ) )
        )
    ) )    

    ; -- Starting drawing: "Use active drawing" toggle
    (defun start_fn_toggle ( val / x)
      (cond
        ((= val "1") ; toggle turned on to start with the active named drawing
          (setq sfn_active 1) ; default to starting with the active, named drawing
          (mode_tile "accept" 0) ; enable "Start" button
          (mode_tile "fcreate_x" 1) ; fuzz out Starting file name edit box and Browse... button
        )
        ((= val "0") ; toggle turned off.
          (mode_tile "fcreate_x" 0) ; enable file name edit box and browse button
          (setq sfn_active nil) ; don't start with active drawing
          (setq x (get_tile "start_fnam"))
          (if (= x "")
            (progn ; make sure "Start" button is fuzzed out
              (mode_tile "accept" 1)
            )
          ; ELSE
            (progn
              (mode_tile "accept" 0) ; enable "Start" button  
          ) )
        )
      )  
    ) 
    ; -- Starting drawing: file name edit box
    (defun start_fnam_editbox ( val / ) 
      ; File creation Edit box - user selected edit box and then changed focus
      (if (/= val "")(setq val (wd_1_rmv_leading_blnks (wd_1_rmv_trailing_blnks val))))
      (cond
        ((= val "")
          ; manually typed in file name probably not found, blank out the edit box
          (set_tile "startpath1" "")
          (set_tile "startpath2" "")
          (mode_tile "accept" 1) ; no dwg name in edit box, fuzz out Start button
        )
        (T          
          (wdio_startfnam_editbox val)
          (mode_tile "accept" 0) ; enable Start button
        ) 
      )        
    )   
    ; -- Starting drawing: "Browse..." button
    (defun sfn_browse_button ( / str dwgnam )
      ; Drawing creation "Browse" button
      ; Default starting folder: 1) previous start drawing's folder, 2) current project wdp file location
      (setq str nil)
      (if (AND (not str) GBL_wd_prj)(setq str (car (c:wd_split_fnam GBL_wd_prj))))
      (if (not str) (setq str ""))
      (setq x (getfiled (c:wd_msg "IOxxx" nil "Starting File Name") str "DWG" 1))      
      (if x 
        (progn
          (setq GBL_wd_wdio_start_fnam x)
          (start_fnam_editbox x)
        )
      )        
    )  
    ; --  
    (defun wdio_main_set_tile_module_placement ( / )
      ; adjust radio button and toggle status in "Module Placement"     
      ; part of main dialog       
      ;  allow XY Grid or X Zone no line numbers

      ; Column to Column radio buttons
      (if (= use_colskip 0)
        (progn
          (set_tile "colcont" "1") ; set "Next sequential number"
          (set_tile "colskip" "0") 
          (mode_tile "colskipcnt" 1)
        )
      ; ELSE
        (progn
          (set_tile "colskip" "1")
          (set_tile "colcont" "0")
          (mode_tile "colskipcnt" 0)
          (if colskipcnt 
            (set_tile "colskipcnt" (itoa colskipcnt))
          )
      ) )
                
      ; Drawing to Drawing radio buttons
      (if (= use_skip 0)
        (progn
          (set_tile "cont" "1") ; set "Next sequential" radio button
          (set_tile "skip" "0")
          (mode_tile "skipcnt" 1)
        )
      ; ELSE
        (progn
          (set_tile "skip" "1") ; "drawing to drawing count" radio button
          (set_tile "cont" "0")
          (mode_tile "skipcnt" 0)
          (if skipcnt 
            (set_tile "skipcnt" (itoa skipcnt))
          )
      ) )
;            ) )   
      (if (AND GBL_wd_iflg (= (type GBL_wd_iflg) 'STR)) 
        (set_tile "i_unused" GBL_wd_iflg))
      (if GBL_wd_PLC_autobreak (set_tile "predef_brks" GBL_wd_PLC_autobreak))
      (if (AND rung_skip_btwn_module (= (type rung_skip_btwn_module) 'INT)) 
        (set_tile "mod_2_mod_spacing" (itoa rung_skip_btwn_module))
      )
    
      (cond
        ((= always_start_at_top "0")
          (set_tile "start_at_top" "1")
          (do_module_spacing 1 1)
        )
        ((= always_start_at_top "1")
          (set_tile "fit_module" "1")
          (do_module_spacing 0 2)
        )
        (T
          (set_tile "split_module" "1")
          (do_module_spacing 0 3)
      ) )
    )              
    
    ; -- main --
    (if Aw_debug (princ "\nIN:wd_wdio_main_dialog"))
    (setq cancel_1 nil)
    (setq dclfnam (findfile "wdio.dcl"))
    (if (not dclfnam) (setq dclfnam (findfile (strcat wdio_sup_path "wdio.dcl"))))
    (if (not dclfnam)
      (progn
        (princ (c:wd_msg "GEN074" (list "wdio.dcl") "File %1 not found"))
        (setq cancel_1 1)
    ) )
    (if (not cancel_1)
      (progn 
      
        (setq xitflg nil)
        (while (not xitflg)
          (setq xitflg 1) ; default to exit. Will stay in loop if user "picks" for XY origin
        
          (setq dcl_id (load_dialog dclfnam))
          (if (new_dialog "wdio_main" dcl_id)
            (progn
          
              (if (not firstdwg)
                (progn ; 2nd+ dwg prompt, fuzz some stuff out
;                  (mode_tile "setfnam_x" 1) ; fuzz out "settings" part of top dialog
                  (mode_tile "sfn_active" 1) ; fuzz out "use active drawing" toggle
                  (mode_tile "ldr_setup" 0)
              ) )
              (wdio_setfnam_editbox GBL_wd_wdio_cfg_fnam)
              (action_tile "setfnam" "(read_setfnam_editbox $value)")
              (action_tile "wdi_browse" "(browse_setup_button)")
              (action_tile "ldr_setup" "(setq picking (wd_wdio_ladder_setup dclfnam firstdwg))(if (= picking 1)(done_dialog))")

              (if (not GBL_wd_iflg) (setq GBL_wd_iflg "0")) ; default to not show
              (setq rtrn nil)
; ** 22-Sep-06 NEHolt               
              (cond
                ((= dwg_pause "N") (set_tile "b_nopause" "1"))
                (T    
; ** 22-Sep-06 NEHolt.en                            
                  (set_tile "b_pause" "1")
              ) )    
              (if sheet_str (set_tile "sheet" sheet_str))
              ;  allow XY Grid or X Zone no line numbers
              (if (AND refnums (> refnums 3))
                (disable_line_ref)
              )  
              (setq dwg_pause "Y") 
              (if (OR (= ladder_first_ref "")(not ladder_first_ref)
                      (/= (type ladder_first_ref) 'STR)) 
                  (setq ladder_first_ref "1"))
              (if (AND ladder_first_ref (= (type ladder_first_ref) 'STR)) 
                 (set_tile "firstaddr" ladder_first_ref))
              (action_tile "firstaddr" (strcat
                "(setq ladder_first_ref $value)"
                "(setq dwg_ladder_first_ref $value)"))   
              (if (OR (not indx)
                      (/= (type indx) 'STR)) 
                (setq indx "1")
              )
              (set_tile "indx" indx)
              
              (if (not GBL_wd_wdio_add2proj)(setq GBL_wd_wdio_add2proj "0"))
              (set_tile "add2proj" GBL_wd_wdio_add2proj)
              (if (not GBL_wd_prj)(mode_tile "add2proj" 1)) ; fuzz out "Add new dwgs to active proj" toggle             
              (action_tile "add2proj" "(setq GBL_wd_wdio_add2proj $value)")
               
              (action_tile "indx" "(setq indx $value)(if (= (atoi indx) 0)(setq indx \"1\"))(set_tile \"indx\" indx)")
              (action_tile "sheet" "(setq sheet_str $value)")
              (action_tile "b_pause" "(set_tile \"b_nopause\" \"0\")(setq dwg_pause \"Y\")")
              (action_tile "b_nopause" "(set_tile \"b_pause\" \"0\")(setq dwg_pause \"N\")")
            
              (setq sfn_active nil)
              (if (AND GBL_wd_wdio_start_fnam (/= GBL_wd_wdio_start_fnam "")
                       (= (type GBL_wd_wdio_start_fnam) 'STR))
                (progn ; starting file name is defined
                  (start_fnam_editbox GBL_wd_wdio_start_fnam) ; make sure "Active dwg" toggle is OFF
                )
              ; ELSE
                (progn
                  (if (= (getvar "DWGTITLED") 1)
                    (progn ; active dwg is named
                      (mode_tile "fcreate_x" 1) ; disable drawing file name edit box and browse button
                      (set_tile "sfn_active" "1") ; set the "use active drawing" toggle
                      (setq sfn_active 1) ; default to starting with the active, named drawing
                    )
                  ; ELSE
                    (progn ; No dwg defined and active drawing is unnamed
                      (mode_tile "sfn_active" 1) ; fuzz the "Use active drawing" toggle
                      (mode_tile "fcreate_x" 0) ; unfuzz the dwg name edit box and browse button
                      (mode_tile "accept" 1)  ; fuzz out "Start" button
              ) ) ) )
              (wdio_main_set_tile_module_placement) ; set radio buttons/toggles under "Module Placement"
            
            
              (action_tile "colcont" (strcat
                "(mode_tile \"colskipcnt\" 1)(setq use_colskip 0)(set_tile \"colskip\" \"0\")"))
              (action_tile "colskip" (strcat
                "(mode_tile \"colskipcnt\" 0)(setq use_colskip 1)"
                "(set_tile \"colcont\" \"0\")"
                "(set_tile \"colskipcnt\" (itoa colskipcnt))"))
              (action_tile "colskipcnt" (strcat
                "(setq colskipcnt (atoi $value))"
                "(set_tile \"colskipcnt\" (itoa colskipcnt))"))
              (action_tile "cont" (strcat
                "(mode_tile \"skipcnt\" 1)(setq use_skip 0)(set_tile \"skip\" \"0\")"))
              (action_tile "skip" (strcat
                "(mode_tile \"skipcnt\" 0)(setq use_skip 1)"
                "(set_tile \"cont\" \"0\")"
                "(set_tile \"skipcnt\" (itoa skipcnt))"))
              (action_tile "skipcnt" (strcat
                "(setq skipcnt (atoi $value))"
                "(set_tile \"skipcnt\" (itoa skipcnt))"))
              (action_tile "cancel" "(setq cancel_1 1)")

              
              
              
              (action_tile "i_unused" "(setq GBL_wd_iflg $value)")
              (if (OR (not GBL_wd_PLC_autobreak) 
                       (/= (type GBL_wd_PLC_autobreak) 'STR)) 
                (setq GBL_wd_PLC_autobreak "1"))
              (set_tile "predef_brks" GBL_wd_PLC_autobreak)
              (action_tile "predef_brks" "(setq GBL_wd_PLC_autobreak $value)")
              (if flg
                (action_tile "help" "(c:wd_helptoc \"wddoc\" \"help_wdio_addr_1\")")
                (action_tile "help" "(c:wd_helptoc \"wddoc\" \"help_wdio_addr\")")
              )
              (action_tile "start_at_top"
                "(setq always_start_at_top \"0\") (do_module_spacing 1 1)")
              (action_tile "fit_module" (strcat "(setq always_start_at_top \"1\")"
                "(do_module_spacing 0 2) (mode_tile \"mod_2_mod_spacing\" 2)"))
              (action_tile "split_module" (strcat "(setq always_start_at_top \"2\")"
                "(do_module_spacing 0 3) (mode_tile \"mod_2_mod_spacing\" 2)"))
              (action_tile "mod_2_mod_spacing"
                "(setq rung_skip_btwn_module (atoi $value))")
              (action_tile "start_fnam" "(start_fnam_editbox $value)") ; File creation edit box	      
              (action_tile "sfn_browse" "(sfn_browse_button)") ; File creation "Browse..." button	      
              (action_tile "sfn_active" "(start_fn_toggle $value)") ; "Use active drawing" toggle
            
              (action_tile "sheet" "(setq sheet_str $value)") 
              (action_tile "save_wdi_1" "(wd_wdio_save_wdi_button)")
; ** 22-Sep-06 NEHolt - 829891              
              (if (= picking 2)
                (progn ; this is re-entry into dialog after closing to allow ladder "Pick" point
                  (setq picking nil)
                  (setq picking (wd_wdio_ladder_setup dclfnam firstdwg)) ; display the "Setup..." dialog
                  (if (= picking 1)(done_dialog)) ; dismiss dialog to allow user to pick ladder origin
              ) )    
; ** 22-Sep-06 NEHolt.en              
            
              (start_dialog)
              (unload_dialog dcl_id)
              (if cancel_1
                (progn
                  (setq rtrn nil)
                  (setq dwg_ladder_first_ref ladder_first_ref) ; save dwg's first ref
                )
              ; ELSE
                (progn ; user picked "Start" button
                  (if (= picking 1)
                    (progn ; user selected "Pick>>" button on the Setup subdialog                  
                      (setq picking nil)
                      (setq x (getpoint (strcat "\n" (c:wd_msg "IO026" nil "Specify point for upper left corner of 1st ladder:"))))
                      (if x
                        (progn
                          (setq first_ladder_XY_org (list (car x) (cadr x)))
                          (setq xitflg nil) ; stay in loop
                          (setq picking 2) ; this fill flag Seutp dialog redisplay - ** 22-Sep-06 NEHolt - 829891
                      ) )
                    )
                  ; ELSE
                    (progn
                      (if sfn_active
                        (progn ; Starting on active drawing. Save the full name of active drawing.
                          (setq x (wd_4_all_slashes_backward (getvar "DWGPREFIX"))) ; current dwg path
                          (setq xx (c:wd_split_fnam (getvar "DWGNAME"))) ; cur dwg name
                          (setq GBL_wd_wdio_start_fnam (strcat x (cadr xx) (caddr xx)))
                        )
                      )                      
                      (setq rtrn (list dclfnam ; the path/name of wdio.dcl support file
                                       sfn_active ; 1=start on active dwg
                                       GBL_wd_wdio_start_fnam)) ; starting full file name
                  ) )                     
                )  
    ) ) ) ) ) )
    (if Aw_debug (princ "\nOUT:wd_wdio_main_dialog"))
    rtrn ; nil=user cancel
  )
  ; --
  (defun wd_wdio_ladder_setup ( dclfnam firstdwg / dcl_id2 cancel xitflg x y val code)
    ; The "Setup" subdialog picked from the upper right-hand "Setup" button on main dialog
    ; -- internal
    (defun do_x ( / )
      (setq x (atof $value))
      (set_tile "pickx" (rtos x 2 3)) 
      (setq first_ladder_XY_org (list x (cadr first_ladder_XY_org)))
    )
    (defun do_y ( / )
      (setq x (atof $value))
      (set_tile "picky" (rtos x 2 3)) 
      (setq first_ladder_XY_org (list (car first_ladder_XY_org) x))
    )
    (defun dovertsp ( / )
      (setq x (atof $value))
      (if (> x 0.0)
        (progn
          (setq rung_spacing x)
          (setq usr_rv x)
          (set_tile "vertsp" (rtos x 2 3))
          (set_tile "usr_rv" (rtos x 2 3))
    ) ) )
    (defun wdio_do_plcscl_editbox ( val / )        
      (if (not (zerop (setq x (atof val))))
        (setq GBL_wd_scl_plcbld x)
      ; ELSE
        (progn ; bogus value
        )
      )  
    )  
    ; -- 
    (defun do_refs_radio_buttons ( / )
      (if (/= refnums 1)(set_tile "refnums" "0"))
      (if (/= refnums 2)(set_tile "refnums" "1"))
      (if (/= refnums 3)(set_tile "refnums" "2"))
      (if (/= refnums 4)(set_tile "refnums" "3"))
      (if (/= refnums 5)(set_tile "refnums" "4"))
    )    
    
    ; --
    (defun wdio_ldr_img ( code / x y sldpath ) ; Leader image
      (if (setq x (c:wd_getenv "WD_SLB"))
        (progn ; slide lib path defined in ".env"
          (setq sldpath x)
        )
      ; ELSE
        (setq sldpath GBL_wd_sup)
      )
      (if sldpath
        (progn
          (setq x (dimx_tile "ldr_i"))
          (setq y (dimy_tile "ldr_i"))

          (start_image "ldr_i")
          (fill_image 0 0 x y 0)
          ; Reuse slide image from main WD executable for ladder config setup
          (slide_image 0 0 x y (strcat sldpath "wd_local(s_ld" code "OR1)")) ; now insert the slide
          (end_image)
      ) )    
    )       
    ; --
    (defun template_editbox_display ( useprototype / x hit ixx xx)      
      (setq x nil)
      (if (AND useprototype (/= useprototype ""))
        (setq x (c:wd_split_fnam useprototype))
      )  
      (if (cadr x)
        (progn
          (set_tile "template" (cadr x))
; ** 27-Jul-07 NEHolt - 958228
          ; Split a long file name across both "template1" and "template2"
          (cond
            ((< (strlen (car x)) 50)
              (set_tile "template1" (car x))
              (set_tile "template2" "")
            )
            (T
              (setq x (wd_4_all_slashes_backward (car x))) ; x=just the path, no file name
              (setq hit nil)
              (foreach xx (list 50 40 30)
                (if (AND (not hit)
                         (setq ixx (wd_1_strchr2 x "\\" xx nil))
                         (< ixx 60))
                  (progn    
                    (setq hit 1)
                    (set_tile "template1" (substr x 1 ixx))
                    (set_tile "template2" (substr x (1+ ixx)))
              ) ) )   
          ) )  
; ** 27-Jul-07 NEHolt.en                                    
        )  
      ; ELSE
        (set_tile "template" "")
      )  
    ) 
    ; --
    (defun template_editbox_typeit ( val / x str xx )
      ; User entry of some value into the template edit box. Verify that this dwg or dwt exists.
      (if (= val "")
        (progn
          (setq useprototype "") ; no prototype/template
        )
      ; ELSE
        (progn
          (setq x (c:wd_split_fnam val))
          (if (= (caddr x) "") ; no extension, assume ".dwt"
            (setq val (strcat val ".dwt"))
          )
          (setq x (c:wd_split_fnam val))
          (cond
            ((= (strcase (caddr x)) ".DWT")
              (setq xx (findfile val))
              (if (not xx)
                (progn ; look specifically in the place where templates should be stored
                  (if (setq str (getenv "TemplatePath"))(setq str (strcat str "\\"))) ; ** 01-Jun-04 NEHolt
                  (if (not str) (setq str wdio_sup_path))
                  (if str (setq xx (findfile (strcat str (cadr x) ".dwt"))))
              ) )
              (if xx 
                (setq useprototype xx)
              ; ELSE
                (progn ; template dwt file not found
                  
              ) )     
            )
            (T ; assume ".dwg"
              (setq xx (c:ace_find_file val 16))
              (if xx
                (setq useprototype xx)
              ; ELSE
                (progn ; dwg template not found
                
                )  
              )
            )
          )
        )  
      )
      (template_editbox_display useprototype)
    )
    ; --
    (defun template_browse ( / str x)
      (if (setq str (getenv "TemplatePath"))(setq str (strcat str "\\"))) ; ** 01-Jun-04 NEHolt
      (if (not str) (setq str wdio_sup_path))
      (if (not str) (setq str ""))
      (setq x (getfiled (c:wd_msg "IO030" nil "Select Prototype/Template (.dwg or .dwt)") str "DWT;DWG" 0)) ; ** 18-Feb-03 NEHolt changed "Prototype" to "Template" ; ** 17-Mar-04 globalized
      (if x
        (progn
          (setq useprototype x)
          (template_editbox_display useprototype)
      ) )
    )  
    ; -- main
    (if Aw_debug (princ "\nIN:wd_wdio_ladder_setup"))
    (setq xitflg 1)
    (setq pickit nil)
    (setq cancel nil)
    (setq dcl_id2 (load_dialog dclfnam))
    (if (new_dialog "wdio_setup" dcl_id2)
      (progn
        (if (not firstdwg)
          (progn ; 2nd+ drawing, disable some buttons on this setup dialog
            (mode_tile "ss_columns" 1)
        ) )
        (setq x (rtos GBL_wd_scl_plcbld 2 3))         
        (set_tile "plcscl" x)
        
        
        
        
        (action_tile "plcscl" "(wdio_do_plcscl_editbox $value)")
        (action_tile "scl_1" "(setq GBL_wd_scl_plcbld 1.0)(set_tile \"plcscl\" \"1.0\")(set_tile \"scl_1\" \"0\")")
        (action_tile "scl_i2m" "(setq GBL_wd_scl_plcbld 25.4)(set_tile \"plcscl\" \"25.4\")(set_tile \"scl_i2m\" \"0\")")
        (action_tile "scl_m2i" "(setq GBL_wd_scl_plcbld 0.039)(set_tile \"plcscl\" \"0.039\")(set_tile \"scl_m2i\" \"0\")")
        (action_tile "scl_16" "(setq GBL_wd_scl_plcbld 16.0)(set_tile \"plcscl\" \"16.0\")(set_tile \"scl_16\" \"0\")")
        (if (not GBL_wd_scl_plc_borderonly)(setq GBL_wd_scl_plc_borderonly 1))
        (cond
          ((/= GBL_wd_scl_plc_borderonly 1)(set_tile "scl_borderonly" "0")) ; turn off toggle
          (T (set_tile "scl_borderonly" "1"))
        )
        (action_tile "scl_borderonly" "(if (= $value \"1\")(setq GBL_wd_scl_plc_borderonly 1)(setq GBL_wd_scl_plc_borderonly 0))")

        (cond
          ((= h_or_v_rungs "V")
            (set_tile "ladr_v_rungs" "1")
            (wdio_ldr_img h_or_v_rungs)
          )
          (T 
            (set_tile "ladr_h_rungs" "1")
            (wdio_ldr_img h_or_v_rungs)
          )
        )
        (action_tile "ladr_h_rungs" "(setq h_or_v_rungs \"H\")(wdio_ldr_img h_or_v_rungs)") ; horiz rungs, vert ladders
        (action_tile "ladr_v_rungs" "(setq h_or_v_rungs \"V\")(wdio_ldr_img h_or_v_rungs)") ; vert rungs, horiz ladders

        (set_tile "ldrwdt" (rtos ladder_width 2 3)) 
        (set_tile "numldrs" (itoa (1- ladder_cnt)))
        (set_tile "vertsp" (rtos rung_spacing 2 3)) 
        (set_tile "usr_rv" (rtos usr_rv 2 3)) 
        (set_tile "rungcnt" (itoa ladder_rung_cnt))
        (if (AND plc_style (> plc_style 0))(set_tile "plc_style" (itoa (1- plc_style)))) ; ** 06-Feb-07 NEHolt
        (if (AND arrow_style (> arrow_style 0))(set_tile "arrow_style" (itoa (1- arrow_style))))
        (set_tile "keep_shorted" (itoa plc_keep_shorted_wire)) 
        (if (= suppress_rails 1)(set_tile "suppress_rails" "1")) 
        (if (= suppress_rungs 1)
          (progn
            (set_tile "suppress_rungs" "1") 
            (setq rung_skip -1)
            (mode_tile "keep_shorted" 1)
          )
        ; ELSE
          (progn
            (setq rung_skip 0)
          )  
        )
        (set_tile "ldr2ldr" (rtos ladder_2_ladder_dist 2 3))
        (set_tile "pickx" (rtos (car first_ladder_XY_org) 2 3))
        (set_tile "picky" (rtos (cadr first_ladder_XY_org) 2 3))
        (set_tile "maxpnts" (itoa max_pnt_cnt_per_ldr))
        (set_tile "ixoff" (rtos plc_input_x_offset 2 3))
        (set_tile "oxoff" (rtos plc_output_x_offset 2 3))
        (set_tile "idoff" (rtos plc_input_device_x_offset 2 3))
        (set_tile "odoff" (rtos plc_output_device_x_offset 2 3))
        (set_tile "multi_x" (rtos plc_series_device_spacing 2 3)) 
        (set_tile "ydown" (itoa plc_insert_y_offset_rungs_down))
        (template_editbox_display useprototype) ; fill in the template edit box
        (action_tile "pick" "(setq xitflg nil)(setq pickit 1)(done_dialog 99)")
        (action_tile "pickx" "(do_x)")
        (action_tile "picky" "(do_y)")
        (action_tile "ldrwdt" (strcat
          "(setq x (atof $value))(if (> x 0.0)(setq ladder_width x))"))
        (action_tile "numldrs" "(setq ladder_cnt (1+ (atoi $value)))") ; 0 index
        (action_tile "plc_style" "(setq plc_style (1+ (atoi $value)))") ; ** 06-Feb-07 NEHolt
        (action_tile "arrow_style" "(setq arrow_style (1+ (atoi $value)))")
        (action_tile "keep_shorted" "(setq plc_keep_shorted_wire (atoi $value))") 
        (action_tile "suppress_rails" (strcat
          "(if (= $value \"1\")(setq suppress_rails 1)(setq suppress_rails nil))"))
        (action_tile "suppress_rungs" (strcat
          "(if (= $value \"1\")(progn(setq suppress_rungs 1 rung_skip -1)(mode_tile \"keep_shorted\" 1))(progn(setq suppress_rungs nil rung_skip 0)(mode_tile \"keep_shorted\" 0)))"))
        (action_tile "vertsp" "(dovertsp)")
        (action_tile "usr_rv"
          "(setq x (atof $value))(if (> x 0.0)(progn(setq usr_rv x)(set_tile \"usr_rv\" (rtos x 2 3))))")
        (action_tile "rungcnt"
          "(setq x (atoi $value))(if (> x 0)(setq ladder_rung_cnt x))")
        (action_tile "ldr2ldr"
          "(setq x (atof $value))(if (> x 0.0)(setq ladder_2_ladder_dist x))")
        (action_tile "maxpnts"
          "(setq x (atoi $value))(if (> x 0)(setq max_pnt_cnt_per_ldr x))")
        (action_tile "ixoff"
          "(setq x (atof $value))(set_tile \"ixoff\" (rtos x 2 3))(setq plc_input_x_offset x)")
        (action_tile "oxoff"
          "(setq x (atof $value))(set_tile \"oxoff\" (rtos x 2 3))(setq plc_output_x_offset x)")
        (action_tile "idoff"
          "(setq x (atof $value))(set_tile \"idoff\" (rtos x 2 3))(setq plc_input_device_x_offset x)")
        (action_tile "odoff"
          "(setq x (atof $value))(set_tile \"odoff\" (rtos x 2 3))(setq plc_output_device_x_offset x)")
        (action_tile "multi_x"
          "(setq x (atof $value))(set_tile \"multi_x\" (rtos x 2 3))(setq plc_series_device_spacing x)")
        (action_tile "ydown"
          "(setq x (atoi $value))(set_tile \"ydown\" (itoa x))(setq plc_insert_y_offset_rungs_down x)")
        (if refnums (set_tile "refnums" (itoa (1- refnums))))
        (action_tile "refnums" "(setq refnums (1+ (atoi $value)))(princ \" refnums=\")(princ refnums)")
        (action_tile "ss_columns" "(wd_wdiob_csv_dlg)") ; display/edit Spreadsheet columns
        ; Drawing template stuff
        (action_tile "template" "(template_editbox_typeit $value)")
        (action_tile "template_browse" "(template_browse)")
        (action_tile "save_wdi_2" "(wd_wdio_save_wdi_button)(done_dialog)")

        (action_tile "help" "(c:wd_helptoc \"wddoc\" \"help_plc_ldrconfig\")") 
    
        (start_dialog)
        (unload_dialog dcl_id2)
    ) )
    (if Aw_debug (princ "\nOUT:wd_wdio_ladder_setup"))
    pickit ; =1 if need to dismiss all dialogs to allow user to pick X,Y org of 1st ladder
  )

  ; -- end internal --

  ; --- main routine ---
  ; Entry point for starting the program
  (if Aw_debug (princ "\nIN:wdio_main"))
  
  
; ** 25-Aug-06 NEHolt ; if "DUMMY" passed then immediately exit. This
;   is a work-around for an MDI issue where an internal function of
;   wdio_main needs to be exposed to function wdio_doit. This is not
;   pretty.  
  (if (/= param_lst "DUMMY")
    (progn
; ** 25-Aug-06 NEHolt.en  
  
  (if (not GBL_wd_sup)
    (setq wdio_sup_path "")
  ; ELSE
    (setq wdio_sup_path GBL_wd_sup)
  )

  ; set variables to nil
  (reset_global_variables)

  (if (not GBL_wd_usr)
    (setq wdio_usr_path "")
  ; ELSE
    (setq wdio_usr_path GBL_wd_usr)
  )

  (setvar "CLAYER" "0") ; set to layer 0 ** 13-Dec-00
  
; save incoming values for module scale ** 27-Oct-06 NEHolt - 831680  
  (setq save_GBL_wd_scl_plcbld GBL_wd_scl_plcbld) 
  (setq save_GBL_wd_scl_plc_borderonly GBL_wd_scl_plc_borderonly) 
; ** 27-Oct-06 NEHolt.en

  (if (not GBL_wd_scl_plcbld)
    (progn ; Global scaling factor not defined. See if current dwg's
           ; config is set up for "inch" or "inch to metric" or "full mm".
           ; If the first, then default to scale 1.0. Otherwise default
           ; to 25.4 (assumes that plc*.dat file \1= \6= values are
           ; in "inch" units.
      (setq xx nil)     
      (if (AND GBL_wd_m (nth 50 GBL_wd_m))
        (progn ; check if "Full mm" bit set in WD CONFIG for this dwg     
          (setq x (atoi (nth 50 GBL_wd_m)))
          (if (= (logand x 1) 1) (setq xx 1))
      ) )
      (cond
        ((= xx 1)(setq GBL_wd_scl_plcbld 25.4)) ; "Full MM" selected. Assume plc*.dat in inch units and need to scale up
        ((/= GBL_wd_scl nil)(setq GBL_wd_scl_plcbld GBL_wd_scl))
        (T (setq GBL_wd_scl_plcbld 1.0))
      )
  ) )               
  (setq ss_fnam nil)
  (setq sfn_active nil) ; default to not start on active drawing
  (setq continuation_dwg_lst nil continuation_dwg_cnt 0) ; ** 19-Jun-02 NEHolt
  
  (if param_lst 
    (progn
      (if (nth 0 param_lst)(setq ss_fnam (nth 0 param_lst)))
      (if (AND (nth 2 param_lst)(/= (nth 2 param_lst) nil))
        (progn
          (if (listp (nth 2 param_lst))
            ; 2nd+ dwg list passed
            (setq continuation_dwg_lst (nth 2 param_lst))
      ) ) )      
  ) )  
  (setq GBL_wdio_new_dwgs_created '()) ; ** 06-Jun-02 NEHolt

  (setq use_skip 0) ; 0 = start next dwg with prev dwg's last ref num + 1
  (setq use_colskip 0) ; 0 = start next ladder col with prev columns last
                       ; ref number + 1
  (setq skipcnt 100) ; default dwg to dwg line reference skip amount
  (setq colskipcnt 30) ; default col to col line ref skip amount
  
  ; Prompt user for drawing configuration
  (user_settings) ; read in default, hard-coded settings
  ; If previous run then previous ".wdi" should be sitting in this global variable
  (if (AND GBL_wd_wdio_cfg_fnam (/= GBL_wd_wdio_cfg_fnam ""))
    (wd_wdio_read_settings_data GBL_wd_wdio_cfg_fnam) ; read previous wdi file settings into memory
  )  
          
  (if (not ss_fnam)
    (progn ; File name not passed as parameter. Prompt for spreadsheet input file.
           ; Default to XLS but allow CSV or MDB
           ; Check for XLS file created by WD's RSLogix --> XLS converter
      (if (AND GBL_wd_rslogix_xls (/= GBL_wd_rslogix_xls ""))      
        (setq str GBL_wd_rslogix_xls)     
      ; ELSE
        ; Previous XLS file name, display this as default in the file selection dialog below
        (if GBL_wd_wdio_ss_fnam_save (setq str GBL_wd_wdio_ss_fnam_save)) 
      )                 
      (if (OR (not str)(= str ""))
        (progn
          (setq str (strcat wdio_usr_path "demoplc.xls"))
          (setq GBL_wd_wdio_cfg_fnam nil) ; blank out any saved "wdi" default ** 29-Dec-05 NEHolt
      ) )

      (if (findfile str)
        (progn ; default to demo file DEMOPLC.XLS if exists
          (setq ss_fnam (getfiled (c:wd_msg "IO028" nil "Select PLC I/O Spreadsheet Output File")
                         str "XLS;CSV;MDB" 0)) 
        )
      ; ELSE
        (progn
          (setq ss_fnam (getfiled (c:wd_msg "IO028" nil "Select PLC I/O Spreadsheet Output File") 
                      wdio_usr_path "XLS;CSV;MDB" 4)) 
      ) ) 
  ) )          
          
  (if ss_fnam 
    (progn ; Remember the selected XLS file name. Redisplay as default if program restarted.
      (setq GBL_wd_wdio_ss_fnam_save ss_fnam) ; ** 22-Jan-04 NEHolt
      (setq ss_fnam_ext (ace_strcase (substr ss_fnam (- (strlen ss_fnam) 2)))) ; get extension
      (setq x nil)
      (cond
        ((not param_lst)
          (setq x (wd_wdio_main_dialog 1)) ; display main dialog, includes prompt for 1st ladder ref number
          ; x=nil if user cancel out of main dialog above
; ** 27-Oct-06 NEHolt - 831680          
          (if (not x)
            (progn ; user cancel
              (setq GBL_wd_scl_plcbld save_GBL_wd_scl_plcbld) ; restore original setting
              (setq GBL_wd_scl_plc_borderonly save_GBL_wd_scl_plc_borderonly)
          ) )
; ** 27-Oct-06 NEHolt.en          
          (setq sfn_active (cadr x))  ; 1=starting on active dwg
          (setq GBL_wd_wdio_start_fnam (caddr x)) ; starting full file name 
        )
        (T ; param_lst passed, "Autorun" mode where data passed on command line
          (setq x (wdio_autorun_set_settings param_lst)) ; return nil=problem
          (if (= x 2)
            (progn
              (setq GBL_wd_wdio_autorun 2) ; Autorun but showing dialogs (1=no dialogs)
              (setq xx (wd_wdio_main_dialog 1)) ; display dialogs
              (setq sfn_active (cadr xx))
              (setq GBL_wd_wdio_start_fnam (caddr xx))
              (if (not xx) (setq x nil)) ; user cancel, flag to exit 
          ) )
        )  
      )  
      (if x 
        (progn
          (if (/= GBL_wd_wdio_autorun 1) ; normal (nil) or autorun (but show dialogs)
            (chk4_prototype_use)
          )  
; ** 02-Jan-07 NEHolt          
          ; read the spreadsheet
;          (setq mod_data (read_xls_mdb_csv_file ss_fnam_ext ss_fnam))
; ** 02-Jan-07 NEHolt
;          (if mod_data
          (if ss_fnam
; ** 02-Jan-07 NEHolt.en          
            (progn
              ; later go back and make global ??? or clear at end
              ; initialize some variables for first drawing

              ;16-Jul-2004 PanQ, Change for MDI
              (if (= (getvar "SDI") 1)
                (progn
                  (setq #LISPINIT (getvar "LISPINIT"))
                  (setvar "LISPINIT" 0) ; remember variables
                )
              )        
              (setq module 0)
              (setq pnts_so_far 0)
              (setq use_next_addr "")
              (setq addr_pnts_so_far 0)
              (setq pnts_not_used 0)
              (setq pnts_so_far_this_module 0)
              (if (OR (not ladder_first_ref)(= ladder_first_ref "")) 
                (setq ladder_first_ref "1"))
              (setq srccnt 0) ; used for ladder to ladder SRC/DEST codes
              
              (cond
                ((= sfn_active 1) ; Simple startup: begin on active drawing
; ** 02-Jan-07 NEHolt   
                   ; Don't read in XLS file until first drawing is opened. This is because we need to figure
                   ; out if first drawing is set up for inch or metric. Rest of dwgs will follow whatever
                   ; the first drawing is configured for (inch or metric).                      
                  (if (setq mod_data (read_xls_mdb_csv_file ss_fnam_ext ss_fnam)) 
; ** 02-Jan-07 NEHolt.end
                    (c:wdio_doit) ; Start the first drawing. Subsequent
                                  ;drawings started from daisy-chained script file
                  )                                
                )
                (T ; have to open a different drawing in order to start
                  (if (= (getvar "SDI") 1) ; SDI SINGLE DOCUMENT MODE IS ACTIVE 
                    (progn ; close and open using regular AutoCAD calls, not script                    
                      (cond
                        ((= (getvar "DWGTITLED") 1) ; active dwg is named
                          (command "_.QSAVE") ; save existing drawing before starting 1st PLC I/O drawing
                          (command "_.NEW" (wdio_chk4_longfname useprototype))
                        )
                        (T ; active drawing is unnamed
                          (if (/= (getvar "DBMOD") 0) ; will prompt to save changes
                            (progn
                              (command "_.NEW" "_YES" (wdio_chk4_longfname useprototype)) ; discard changes
                            )
                          ; ELSE
                            (progn ; there will be no prompt to save changes
                              (command "_.NEW" (wdio_chk4_longfname useprototype))
                       ) ) )     
                     )  
                     (if (findfile GBL_wd_wdio_start_fnam)
                       (progn ; File exists. Overwrite existing file required
                         (command "_.SAVE")
                         (command (wdio_chk4_longfname GBL_wd_wdio_start_fnam))
                         (command "_YES") ; yes to overwrite
                         (command "_.OPEN")
                         (command (wdio_chk4_longfname GBL_wd_wdio_start_fnam))
                       )
                     ; ELSE
                       (progn ; no existing file, no "_YES" to overwrite is required
                         (command "_.SAVE")
                         (command (wdio_chk4_longfname GBL_wd_wdio_start_fnam))
                         (command "_.OPEN")
                         (command (wdio_chk4_longfname GBL_wd_wdio_start_fnam))
                     ) )  
; ** 02-Jan-07 NEHolt   
                     ; Don't read in XLS file until first drawing is opened. This is because we need to figure
                     ; out if first drawing is set up for inch or metric. Rest of dwgs will follow whatever
                     ; the first drawing is configured for (inch or metric).                      
                     (if (setq mod_data (read_xls_mdb_csv_file ss_fnam_ext ss_fnam)) 
; ** 02-Jan-07 NEHolt.end
                       (c:wdio_doit) ; Now launch program       
                     )                                              
                   )                    
                 ; ELSE
                   (progn ; MDI mode
                     ; Build new version of script file to open next drawing and
                     ; continue execution
                     (setq f (open (strcat wdio_usr_path "_wdio.scr") "w"))
                     (if (/= f nil)
                       (progn
                         ; New drawing (with "=" for "no prototype", for now!)
                         (if (= useprototype nil) (setq useprototype ".")) ; trigger "No Template"

; ** 11-Feb-05 NEHolt          
              ; Make sure that the new drawing we're going to go to next is not already open in MDI mode. Issue a close
              ; command to make sure it is not open
; ** 16-Feb-05 LeeH
                         (setq open_dwgs (wd_pds_get_open_dwgs)) 
                         (setq this_dwg (ace_strcase GBL_wd_wdio_start_fnam))
                         (setq found_dwg nil)
                         (foreach curr_dwg open_dwgs
                           (if (not found_dwg) 
                             (setq found_dwg (= (ace_strcase curr_dwg) this_dwg))
                           )
                         )  
                         (if found_dwg ; target dwg is already open in MDI mode. First close it.   
                           (write-line (strcat "(wd_pdsx_close \"" (wd_4_convert2_doublebackslash GBL_wd_wdio_start_fnam) "\" T)" ) f)
                         )
; **          

; ** 20-Nov-06 NEHolt - 858496
                         (if (= (getvar "DWGTITLED") 1) ; active dwg is named
                           (progn
                             (write-line "_.QSAVE" f)
                           )
                         )  
; ** 20-Nov-06 NEHolt.end
                         (write-line "_.new" f)
          
                         (write-line (wdio_chk4_longfname useprototype) f) ; ** 16-Jul-99
                         
; ** 20-Nov-06 NEHolt - 858496                         
                         ; Make double sure target dwg is closed
                         (if found_dwg ; target dwg is already open in MDI mode. First close it.   
                           (write-line (strcat "(wd_pdsx_close \"" (wd_4_convert2_doublebackslash GBL_wd_wdio_start_fnam) "\" T)" ) f)
                         )                         
; ** 20-Nov-06 NEHolt.en                         
                         
                         (write-line "_.SAVE" f)
                         (write-line (wdio_chk4_longfname GBL_wd_wdio_start_fnam) f) ; ** 25-Jun-99 chk for embedded space
                         (if (findfile GBL_wd_wdio_start_fnam)
                           ;**10-Sep-04 PanQ, Use _YES instead of _Y
                           (write-line "_YES" f) ; yes to overwrite
                         )
                         ; Close current active drawing
                         (write-line (strcat "(wd_pdsx_close \"" (wd_4_convert2_doublebackslash (strcat (getvar "dwgprefix") (getvar "dwgname"))) "\" T)" ) f)
                         
                         ; In MDI mode, make sure AcadE is "awake" before trying to re-load the wdio.lsp routine below
                         (write-line "(if(not wd_load)(if(setq x(findfile \"wd_load.lsp\"))(load x)))(wd_load)" f) ; ** 21-Oct-06 NEHolt
                         
; ** 04-Oct-07 NEHolt - for ACE2009, file was moved                         
;                         (write-line "(load (strcat GBL_wd_sup \"wdio.lsp\"))" f);** 10-Sep-04 PanQ, load wdio.lsp first
                         (write-line "(load (findfile \"wdio.lsp\"))" f)
; ** 04-Oct-07 NEHolt.end
                         
; ** 02-Jan-07 NEHolt   
                         ; Don't read in XLS file until first drawing is opened. This is because we need to figure
                         ; out if first drawing is set up for inch or metric. Rest of dwgs will follow whatever
                         ; the first drawing is configured for (inch or metric).                      
                         (write-line "(wdio_main \"DUMMY\")" f) ; to force internal "read_xls..." routine below to be exposed (not pretty)
                         (write-line (strcat "(setq mod_data (read_xls_mdb_csv_file \"" ss_fnam_ext "\" \"" (wd_4_convert2_doublebackslash ss_fnam) "\"))") f)                         
; ** 02-Jan-07 NEHolt.end
                         (write-line "wdio_doit" f)
                         (close f) ; close the newly created "script" file 
                         (setq f nil)        
                         (save_global_variables);** 10-Sep-09 PanQ
                         ; Launch the script file to open the next new drawing and relaunch the wdio program to continue the process
                         (command "_.SCRIPT" (strcat wdio_usr_path "_wdio.scr"))
                     ) )                           
                   )
                 )  
              ) )                  
  ) ) ) ) ) ) 
)) ; ** 25-Aug-06 NEHolt see front end of routine              
  (if Aw_debug (princ "\nOUT:wdio_main"))  
  (princ)
)

; -- 05-Oct-99
(defun reset_global_variables ( / )
  (setq ss_fnam nil module nil pnts_so_far nil addr_pnts_so_far nil
    use_skip nil use_colskip nil
; ** 17-Feb-00 NEHolt
    spacer_skipcnt nil
; skipcnt nil
; **
    ladder_first_ref nil srccnt nil
    dwg_pause nil use_next_addr nil veryfirsta nil first_ladder_XY_org nil
    ladder_cnt nil ladder_2_ladder_dist nil ladder_width nil
    rung_spacing nil usr_rv nil ladder_rung_cnt nil rung_skip nil
    max_pnt_cnt_per_ldr nil plc_style nil arrow_style nil
    plc_input_x_offset nil plc_output_x_offset nil
    plc_input_device_x_offset nil plc_output_device_x_offset nil
    plc_insert_y_offset_rungs_down nil useprototype nil plc_code_ix nil
    rack_ix nil group_ix nil slot_ix nil addr_ix nil remote_tp_ix nil
    plc_inst_ix nil plc_loc_ix nil ; ** 23-May-02
    plc_mod_tag_ix nil  ; ** 07-Jun-02
    wire_tag_ix nil desc1_ix nil desc2_ix nil desc3_ix nil desc4_ix nil
    desc5_ix nil volt_ix nil comp_tag_ix1 nil comp_blk_ix1 nil
    comp_loc_ix1 nil comp_inst_ix1 nil comp_mfg_ix1 nil comp_cat_ix1 nil comp_asm_ix1 nil
    comp_tag_ix2 nil comp_blk_ix2 nil comp_loc_ix2 nil comp_inst_ix2 nil comp_mfg_ix2 nil
    comp_cat_ix2 nil comp_asm_ix2 nil comp_tag_ix3 nil comp_blk_ix3 nil
    comp_loc_ix3 nil comp_inst_ix3 nil comp_mfg_ix3 nil comp_cat_ix3 nil comp_asm_ix3 nil
    comp_tag_ix4 nil comp_blk_ix4 nil comp_loc_ix4 nil comp_mfg_ix4 nil
    comp_cat_ix4 nil comp_asm_ix4 nil comp_inst_ix4 nil
    comp_tag_ix5 nil comp_blk_ix5 nil comp_loc_ix5 nil comp_mfg_ix5 nil
    comp_cat_ix5 nil comp_asm_ix5 nil comp_inst_ix5 nil
    comp_tag_ix6 nil comp_blk_ix6 nil comp_loc_ix6 nil comp_mfg_ix6 nil
    comp_cat_ix6 nil comp_asm_ix6 nil comp_inst_ix6 nil
    scale nil comp_desc_ix1 nil comp_desc_ix2 nil comp_desc_ix3 nil
    comp_desc_ix4 nil comp_desc_ix5 nil comp_desc_ix6 nil
    plc_series_device_spacing nil mod_data nil plc_module_found nil
    plc_data_found nil plc_data nil doing_module nil
    plc_keep_shorted_wire nil parallel_skip_lst nil
    xlsdata nil tabnam nil ; *** 21-Feb-00 PMM
    fieldnames nil ; ** 13-Nov-06 Mei
    notfoundlst nil ; ** 21-Feb-00 NEHolt
    ; ** 17-Oct-02 ScottH  added below
    comp_tag_ix7 nil comp_blk_ix7 nil comp_loc_ix7 nil comp_mfg_ix7 nil
    comp_cat_ix7 nil comp_asm_ix7 nil comp_inst_ix7 nil comp_desc_ix7 nil
    comp_tag_ix8 nil comp_blk_ix8 nil comp_loc_ix8 nil comp_mfg_ix8 nil
    comp_cat_ix8 nil comp_asm_ix8 nil comp_inst_ix8 nil comp_desc_ix8 nil
    comp_tag_ix9 nil comp_blk_ix9 nil comp_loc_ix9 nil comp_mfg_ix9 nil
    comp_cat_ix9 nil comp_asm_ix9 nil comp_inst_ix9 nil comp_desc_ix9 nil)     
    ; * * *
  (setq sheet_str nil refnums nil) ; ** 18-Jul-00 NEHolt
  (setq tsize nil) ; *** 21-Oct-00 PMM
  (setq suppress_rails nil) ; ** 06-Jun-02 NEHolt
  
; ** 29-Dec-05 NEHolt don't reset this(?)  
;;;  (setq GBL_wd_wdio_cfg_fnam nil) ; ** 25-Jan-01
; ** 29-Dec-05 NEHolt.en

; ** 28-Feb-01 NEHolt
  (setq GBL_prev_dwg_unit_scale nil)
  (setq GBL_prev_dwg_feature_scale nil)

; ** 06-Feb-01 NEHolt
  (if GBL_wdio_ff (wd_mdb_close GBL_wdio_ff))
  (setq GBL_wdio_ff nil set_picked nil)

)

;** 10-Sep-04 PanQ, Set temp variable to ARX. Must set every time if need arx tranfer variable to next drawing
(defun save_global_variables ( / )
  (ace_set_temp_variables
 "ss_fnam"
 "module"
 "pnts_so_far"
 "addr_pnts_so_far"
 "use_skip"
 "use_colskip"
 "spacer_skipcnt"
 "ladder_first_ref"
 "srccnt"
 "dwg_pause"
 "use_next_addr"
 "veryfirsta"
 "first_ladder_XY_org"
 "ladder_cnt"
 "ladder_2_ladder_dist"
 "ladder_width"
 "rung_spacing"
 "usr_rv"
 "ladder_rung_cnt"
 "rung_skip"
 "max_pnt_cnt_per_ldr"
 "plc_style"
 "arrow_style"
 "plc_input_x_offset"
 "plc_output_x_offset"
 "plc_input_device_x_offset"
 "plc_output_device_x_offset"
 "plc_insert_y_offset_rungs_down"
 "useprototype"
 "plc_code_ix"
 "rack_ix"
 "group_ix"
 "slot_ix"
 "addr_ix"
 "remote_tp_ix"
 "plc_inst_ix"
 "plc_loc_ix"
 "plc_mod_tag_ix"
 "wire_tag_ix"
 "desc1_ix"
 "desc2_ix"
 "desc3_ix"
 "desc4_ix"
 "desc5_ix"
 "volt_ix"
 "comp_tag_ix1"
 "comp_blk_ix1"
 "comp_loc_ix1"
 "comp_inst_ix1"
 "comp_mfg_ix1"
 "comp_cat_ix1"
 "comp_asm_ix1"
 "comp_tag_ix2"
 "comp_blk_ix2"
 "comp_loc_ix2"
 "comp_inst_ix2"
 "comp_mfg_ix2"
 "comp_cat_ix2"
 "comp_asm_ix2"
 "comp_tag_ix3"
 "comp_blk_ix3"
 "comp_loc_ix3"
 "comp_inst_ix3"
 "comp_mfg_ix3"
 "comp_cat_ix3"
 "comp_asm_ix3"
 "comp_tag_ix4"
 "comp_blk_ix4"
 "comp_loc_ix4"
 "comp_mfg_ix4"
 "comp_cat_ix4"
 "comp_asm_ix4"
 "comp_inst_ix4"
 "comp_tag_ix5"
 "comp_blk_ix5"
 "comp_loc_ix5"
 "comp_mfg_ix5"
 "comp_cat_ix5"
 "comp_asm_ix5"
 "comp_inst_ix5"
 "comp_tag_ix6"
 "comp_blk_ix6"
 "comp_loc_ix6"
 "comp_mfg_ix6"
 "comp_cat_ix6"
 "comp_asm_ix6"
 "comp_inst_ix6"
 "scale"
 "comp_desc_ix1"
 "comp_desc_ix2"
 "comp_desc_ix3"
 "comp_desc_ix4"
 "comp_desc_ix5"
 "comp_desc_ix6"
 "plc_series_device_spacing"
 "mod_data"
 "plc_module_found"
 "plc_data_found"
 "plc_data"
 "doing_module"
 "plc_keep_shorted_wire"
 "parallel_skip_lst"
 "xlsdata"
 "tabnam"
 "fieldnames"
 "notfoundlst"
 "comp_tag_ix7"
 "comp_blk_ix7"
 "comp_loc_ix7"
 "comp_mfg_ix7"
 "comp_cat_ix7"
 "comp_asm_ix7"
 "comp_inst_ix7"
 "comp_desc_ix7"
 "comp_tag_ix8"
 "comp_blk_ix8"
 "comp_loc_ix8"
 "comp_mfg_ix8"
 "comp_cat_ix8"
 "comp_asm_ix8"
 "comp_inst_ix8"
 "comp_desc_ix8"
 "comp_tag_ix9"
 "comp_blk_ix9"
 "comp_loc_ix9"
 "comp_mfg_ix9"
 "comp_cat_ix9"
 "comp_asm_ix9"
 "comp_inst_ix9"
 "comp_desc_ix9"
 "sheet_str"
 "refnums"
 "tsize"
 "suppress_rails"
 "GBL_wd_wdio_cfg_fnam"
 "GBL_prev_dwg_unit_scale"
 "GBL_prev_dwg_feature_scale"
 "GBL_wdio_ff"
 "set_picked"
 "first_ladder_XY_org"
 "first_ladder_XY_org"
 "first_ladder_XY_org"
 "first_ladder_XY_org"


  "pnts_so_far_this_module"
  "mod_data_parallel_skip"
  "rung_skip_btwn_module"
  "wdio_usr_path"
  "io_type"
  "plc_loc"
  "h_or_v_rungs"
  "pnt_whatis_lst"
; ** 16-Feb-05 LeeH  
;;  "do_module_spacing"
; **
  "str"
  "options"
  "comp_x_coor"
  "tcnt"
  "csvfext"
  "csv_data"
  "addr_data"
  "ladder_length"
  "csvfnam"
  "pnts_to_do"
  "add_in_mod_skip"
  "addr_val"
  "pnts_left_to_do"
  "newnam"
  "always_start_at_top"
  "pnts_not_used"
  "colskipcnt"
  "saved_tag_attr"
  "ladder_first_ref_lst"
  "io_typ"
  "empty_rungs_left"
  "#LISPINIT"
  "continuation_dwg_cnt"
  "ycoor"
  "sym2"
  "ladder_last_ref"
  "main_val"
  "comp_blk_ix"
  "plc_mod_tag"
  "use_skip"
  "wireno"
  "ii"
  "iii"
  "xcoor"
  "desc_coor"
  "inx"
; ** 16-Feb-05 LeeH  
;;  "err_old"
; **
  "ladder_save_last_ref"
  "start_ix"
  "whatis_cnt"
  "plc_code"
  "skipcnt"
  "pt3"
  "dwg_ladder_first_ref"
  "addr_pnt_cnt"
  "added_rungs"
  "wdio_sup_path"
  "unity_varname_ix" ; 25-Oct-06 Mei
  "unity_vartype_ix" ; 25-Oct-06 Mei
 )

  (princ)
)

; -----
; -- 31-May-99 NEHolt
(defun wd_get_nearby_line ( pt1 / trap ssx
                           rtrn;** 14-Sep-04 PanQ, Declare to local
                           )
  (if Aw_debug (princ "\nIN:wd_get_nearby_line"))
  ; Look for nearby LINE entity within "trap" dist of pt1
  (setq trap 0.125)
  (setq ssx (ssget "_C" (list (- (car pt1) trap) (- (cadr pt1) trap) 0.0)
    (list (+ (car pt1) trap) (+ (cadr pt1) trap) 0.0) '((0 . "LINE"))))
  (if (/= ssx nil)
    (setq rtrn (ssname ssx 0))
  ; ELSe
    (setq rtrn nil)
  )
  (setq ssx nil)
  (if Aw_debug (princ "\nOUT:wd_get_nearby_line"))
  rtrn ; return ent name of nearby LINE ent or nil if none
)
; ---
; -- ** 17-Feb-00 NEHolt  **********************
(defun figure_how_many_empty_rungs_left ( pt1 first_ladder_XY_org rung_spacing
     max_pnt_cnt_per_ldr ladder_rung_cnt plc_insert_y_offset_rungs_down  / downcnt remaining)
  ; Figure out how many empty rungs remain in the current ladder. "pt1" = point where the
  ; next module is scheduled to be inserted.
  ;
  ; "pt1" = calculated position for next module for current ladder
  ; "first_ladder_XY_org" = top of ladder
  ; "rung_spacing" = spacing between rungs
  ; "max_pnt_cnt_per_ldr" = max num of I/O point positions in one ladder
  ; "ladder_rung_cnt" = rungs per ladder
  ; "plc_insert_y_offset_rungs_down" = 1st I/O point position at top of ladder
  ;     (0=start at top rung)
  (cond
    ((= h_or_v_rungs "V")    
      (setq downcnt (fix (/ (+ 0.01 (abs (- (car first_ladder_XY_org) (car pt1)))) rung_spacing)))
    )
    (T  
      (setq downcnt (fix (/ (+ 0.01 (abs (- (cadr first_ladder_XY_org) (cadr pt1)))) rung_spacing)))
  ) )    
  (setq remaining (- (+ max_pnt_cnt_per_ldr plc_insert_y_offset_rungs_down) downcnt))
  remaining ; return count of empty rungs remaining
)


; --- *** 14-Feb-00 PMM
(defun wdio_read_xls_or_mdb_data ( fnam tblnam typ / xlsdatalocal fldnams x hit xx xxx lst
            sortfieldnam temp ix plc_code blank fields fieldspecs)
  ; "typ" = "XLS" for spreadsheet file, "MDB" for Access table
  (if Aw_debug (princ "\nIN:wdio_read_xls_or_mdb_data"))
  (setq xlsdatalocal nil fldnams nil hit nil)
; ** 06-Feb-01 NEHolt
  (if GBL_wdio_ff ; handle of the opened XLS or MDB file
    (progn
; ** 23-May-02 NEHolt      
      (if (= typ "MDB")
        (progn        
          (setq x (wd_mdb_getfieldspecs GBL_wdio_ff tblnam))
          (setq sortfieldnam "")

          (setq fldnams nil)
          (setq x (car x))          
          (foreach xxx x 
            (setq fldnams (cons (car xxx) fldnams))
            (if (= (cadr xxx) "A")(setq sortfieldnam (car xxx))) ; hit AUTONUMBER field. Use for sort
          )  
          
          (setq xlsdatalocal (wd_mdb_getrecs GBL_wdio_ff tblnam "" "" sortfieldnam))
          (setq xlsdatalocal (reverse xlsdatalocal))          
          (setq hit 1)
        )
      ; ELSE
        (progn ; XLS
          (setq fieldspecs (wd_mdb_getfieldspecs GBL_wdio_ff tblnam))
          (if fieldspecs
            (progn
              (setq fields (car fieldspecs))
              (foreach x fields
                (setq fldnams (cons (car x) fldnams))
          ) ) )
          
          (setq xlsdatalocal (wd_mdb_getrecs GBL_wdio_ff tblnam "" "" ""))
; ** 22-Sep-06 NEHolt ACE2008 seems to choke if trailing "$" in Excel table name          
          (if (AND (not xlsdatalocal) ; above query failed        
                   (= (substr tblnam (strlen tblnam) 1) "$")) ; table name has trailing "$" char
            (progn ; Strip off trailing "$" from table name and try again
              (setq tblnam (substr tblnam 1 (1- (strlen tblnam))))                
              (setq xlsdatalocal (wd_mdb_getrecs GBL_wdio_ff tblnam "" "" ""))
; ** 22-Sep-06 NEHolt.en              
      ) ) ) )
        
; **      
      (wd_mdb_close GBL_wdio_ff)
      (setq GBL_wdio_ff nil)
      (if xlsdatalocal
        (progn 
          (setq xlsdatalocal (wdio_cdrlst xlsdatalocal))  
          (setq xx (car xlsdatalocal)) ; tested below for all STRING fields                
          (if (= typ "XLS")
            (progn ; Excel format, first line probably is a list of field column names

              ; Check first line of data for valid PLC catalog number
              ; match in the PartNO column. If match then assume that
              ; the first line is the first line of the first module's
              ; data. If no match, assume first line of data is really
              ; the column labels.
              (setq first_is_data nil)
              (setq xx (car xlsdatalocal))
              (if (AND (> plc_code_ix 0) xx (nth (1- plc_code_ix) xx))
                (progn
                  (setq plc_code (nth (1- plc_code_ix) xx))
                  ; Look for data for this potential plc_code
                  (if (AND (/= plc_code "CODE") ; ** 05-May-02 to speed things up if obvious that first line is not part number line of first module
                           (c:wd_find_sel_plc (list plc_code plc_style fullmm))) ; ** 09-Dec-03 NEHolt added "plc_style" param
                    (progn ; yes, appears that first line is first line
                           ; of 1st module's data
                      (setq first_is_data 1)
                    )
              ) ) )
              (setq xx (car xlsdatalocal))
              (if (not first_is_data) (setq xlsdatalocal (cdr xlsdatalocal))) ; strip off label line
          ) ) 
          
          (foreach x xx
; **
; ** 27-Jun-00
;                (setq x (cdr x))
            (cond
              ((= (type x) 'INT) (setq x (itoa x))(setq hit 1))
              ((= (type x) 'REAL)
                (setq x (rtos x 2 0))(setq hit 1)
              )
            )
; ** 28-Dec-00 NEHolt
            (if (= typ "XLS")
              (progn
                (if first_is_data
                  (setq fldnams (cons "" fldnams)) ; no field names
                ; ELSE
; **
                  (setq fldnams (cons x fldnams))
                )
              )
            )
          )    
          (setq fldnams (reverse fldnams))
          
          
          (if (not hit)
            (progn
              (princ)
;                (setq xlsdatalocal (wdio_cdrlst (cdr xlsdatalocal)))
            )
          ; ELSE
            (progn ; Make sure that all fields are STR
              (setq xx xlsdatalocal)
              (setq xlsdatalocal '())
              (foreach xxx xx
                (setq lst '())
                (foreach x xxx
                  (cond
                    ((= (type x) 'INT)(setq x (itoa x)))
                    ((= (type x) 'REAL)
                      (setq x (rtos x 2 3))
; ** 04-Nov-06 NEHolt - 852901                      
                      ; Some inconsistency in reading the XLS spreadsheet format.
                      ; This may have meant to be an integer in the spreadsheet but appears
                      ; as a real number when read from the spreadsheet. If the converted
                      ; real number ends in ".000", then assume it was meant to be an integer
                      ; value and strip off the ".000" part.
                      (if (AND (> (strlen x) 4) ; ** 21-Nov-06 NEHolt - 862855
                               (= (substr x (- (strlen x) 3)) ".000") 
                               (= typ "XLS"))
                        (setq x (substr x 1 (- (strlen x) 4)))
                    ) ) 
; ** 04-Nov-06 NEHolt.end                    
                  )
                  (setq lst (cons x lst))
                )
                (setq xlsdatalocal (cons (reverse lst) xlsdatalocal))
              )
              (setq xlsdatalocal (reverse xlsdatalocal)) ; put back in correct order ** 23-Aug-06 NEHolt
      ) ) ) )
  ) )

; ** 30-May-02 NEHolt
  ; Preprocess the xls or mdb data. Check for blank records between
  ; modules. If not present then go ahead and fake in a blank record
  ; between each module. Assume that going from a blank CODE field to
  ; a non-blank CODE field in the very next record and the CODE is
  ; not "SKIP" or 1st line in data file, then go ahead and pop in a 
  ; blank record.
  (if (AND (= typ "MDB") (> plc_code_ix 0))
    (progn
      (setq temp '())
      (setq ix 0)
      (foreach xx xlsdatalocal
        (if (= ix 0)
          (setq temp (cons xx temp))
        ; ELSE
          (progn ; past first line
            (setq x (nth (1- plc_code_ix) xx)) ; CODE field
            (if (AND (/= x "") 
                     (OR (= (nth (1- plc_code_ix) (car temp)) "")
                         (= (ace_strcase (nth (1- plc_code_ix) (car temp))) "NEW_DWG") ; ** 18-Jul-07 NEHolt
                         (= (ace_strcase (nth (1- plc_code_ix) (car temp))) "SKIP")))
              (progn ; went from blank CODE to a non-blank CODE
                ; non-blank line, go ahead and insert a blank line
                (setq blank '())
                (repeat (length xx) (setq blank (cons "" blank)))
                (setq temp (cons blank temp))                
            ) )
            (setq temp (cons xx temp))
          )
        )
        (setq ix (1+ ix))
      )
      (setq xlsdatalocal (reverse temp)) ; put back in original order
  ) )
; **              
    
  
  ; return a list of lines and a list containing field names
  (if Aw_debug (princ "\nOUT:wdio_read_xls_or_mdb_data"))
  (list xlsdatalocal fldnams)
)
; ***
; ----- *** 21-Feb-00 PMM
(defun wdio_get_tabnam ( fnam typ / tab x tabnams tabs_with_data xx slen
    dcl_id)
  ; "typ" = "XLS" or "MDB"  
  ; try and determine which table to work with
  (if Aw_debug (princ "\nIN:wdio_get_tabnam"))
  (setq tab nil)
  (if (not GBL_wdio_ff) ; ** 15-Feb-02 NEHolt
    (if (= typ "MDB")
      (setq GBL_wdio_ff (wd_mdb_gethandle 1))
    ; ELSE
      (setq GBL_wdio_ff (wd_mdb_gethandle 2))
  ) )
  (if GBL_wdio_ff
    (progn
; ** 06-Feb-01 NEHolt
      (if (= typ "MDB")
        (setq x (wd_mdb_open GBL_wdio_ff fnam 1))
      ; ELSE
        (setq x (wd_mdb_open GBL_wdio_ff fnam "Excel 5.0;HDR=NO;IMEX=1"))  ; XLS
      )
; ** 18-Mar-02 NEHolt
      ; rare case where wd_mdb_open rtrns "nil" even though file is open
;      (if x (setq tabnams (wd_mdb_gettabnames GBL_wdio_ff)))
      (setq tabnams (wd_mdb_gettabnames GBL_wdio_ff))
; **      
      (setq tabs_with_data nil)
      (if tabnams
        (progn ; determine which sheets/tables have records
          (setq tabs_with_data '())
; ** 23-Feb-00 NEHolt
          (if (not (listp tabnams))(setq tabnams (list tabnams)))
; **
          (foreach tab tabnams
; ** 24-Jan-08 NEHolt - remove any "'" delimiters from returned table name            
            (if (= (substr tab 1 1) "'")(setq tab (substr tab 2 (- (strlen tab) 2))))            
; **            
            (princ (strcat "\n" (c:wd_msg "SWAP030" nil "Sheet:") " "))
            (princ tab)
            (setq x (wd_mdb_GetRecCount GBL_wdio_ff tab))
            (if (not x)(setq x 0)) ; ** 06-Aug-04 NEHolt
            (princ " ")
            (princ (c:wd_msg "SWAP031" (list (itoa x)) "record count: %1"))
; ** 07-Feb-06 NEHolt
            (if (AND x (> x 2)) 
              (progn ; table with at least 3 lines of data (header + data + next line)
                (setq tabs_with_data (cons tab tabs_with_data))
            ) )
            (if (AND (not tabs_with_data) tabnams (>= (wd_mdb_GetRecCount GBL_wdio_ff (car tabnams)) 2))
              (progn ; No tables with >2 lines, set up to go with first non-blank sheet
                (setq tabs_with_data (list tab))
            ) )
; ** 07-Feb-06 NEHolt.en                
          ) 
      ) )
; ** 27-Jun-00 NEHolt
      (if (not tabs_with_data)
        (alert (strcat (c:wd_msg "IO022" nil "Data could not be extracted from any table or sheet in the data file.") "\n" (c:wd_msg "SWAP026" nil "Try SAVEAS a single sheet or output to CSV format.")))
; **
      ; ELSE
        (progn
          (setq tabs_with_data (reverse tabs_with_data))
          (setq tab (car tabs_with_data)) ; default to first (or only) one
; ** 15-Nov-02 NEHolt          
          (if (AND (> (length tabs_with_data) 1) param_lst (nth 3 param_lst) (/= (nth 3 param_lst) ""))                   
            (progn 
              (setq xx nil)
              (foreach x tabs_with_data
                (if (OR (= (ace_strcase (nth 3 param_lst)) (ace_strcase x)) (= (strcat (ace_strcase (nth 3 param_lst)) "$") (ace_strcase x)))
                  (progn
                    (setq xx x) ; found it
              ) ) )
              (if xx
                (progn
                  (setq tab xx) ; table name match
                  (setq tabs_with_data nil) ; fake out below
          ) ) ) )       
; **          
          
          (if (> (length tabs_with_data) 1)
            (progn ; need to prompt user to select which TAB to use
              (setq x (findfile "wdio.dcl"))
              (if (not x) (setq x (findfile (strcat wdio_sup_path "wdio.dcl"))))
              (if x
                (progn      
                  (setq dcl_id (load_dialog x))
; ** 23-Oct-07 NEHolt.end        
                  (if (new_dialog "ins_file2tab_which" dcl_id)
                    (progn
                      ; Strip off any trailing "$" for the pick dialog
                      (setq xx '())
                      (foreach x tabs_with_data
                        (setq slen (strlen x))
                        (if (= (substr x slen 1) "$")
                          (setq xx (cons (substr x 1 (1- slen)) xx))
                        ; ELSE
                          (setq xx (cons x xx))
                      ) )
                      (start_list "lst")
                      (mapcar 'add_list (reverse xx))
                      (end_list)
                      (set_tile "lst" "0") ; highlight first one
                      (action_tile "lst" "(setq tab (nth (atoi $value) tabs_with_data))")
                      (action_tile "cancel" "(setq tab nil)(done_dialog)(wd_mdb_close GBL_wdio_ff)(setq GBL_wdio_ff nil)")
                      (start_dialog)
                      (unload_dialog dcl_id)
                ) ) )
              )
            )
          )
      ) )
;      (wd_mdb_close ff)
  ) )
  (if Aw_debug (princ "\nOUT:wdio_get_tabnam"))
  tab ; nil if no table selected
)

; ----
(defun c:wdio_doit ( / en pt1 pt2 pt0 ben cnt str mdata
     xitflg dline ix x point_cnt lst str suffix elst data
     pdata ss ins_cnt rack slot group remote_tp comp_x_coor2
     xx ixx i_xx ixxx ipx hitbreak z newx 
     gridxy_mode 
     xelst blknam pt2start ccnt spacercnt datalst axy ref2use
     plc_desc_nam_lst plc_desc_en_lst 
     open_dwgs curr_dwg this_dwg found_dwg
     save_ed pt3 pt2 hit line_en pntlst pt3x pt3a pt3b pt4
     wdio_accum_extra_attr_data wdio_write_out_accum_extra_attr_data accumulated_attr_pair_data
     module_extra_attr_pairs acnt add_in_mod_skip ed will_next_module_fit wdio_look4_plcpost_utils)    
  ; PURPOSE: create a single ladder column  
  ; -- internal routines


  ; -- internal routines
  
; -- ** 10-Aug-07 NEHolt made local to this c:wdio_doit function
  (defun will_next_module_fit ( data data_skip p_so_far 
                rung_skip_btw  ; 09-Jul-02 NEHolt renamed variable to avoid confusion
                max_pnts / p_to_do added_rungs i)
    ; return true if will fit, nil otherwise
    (setq p_to_do (length (cadr (car data))))
    (setq added_rungs 0)
    (foreach i data_skip ; additional space after an I/O point
      (setq added_rungs (+ added_rungs i))
    )
    (setq p_to_do (+ p_to_do added_rungs))
    ; will it fit?
    (setq p_to_do (+ p_to_do rung_skip_btw)) ; 09-Jul-02 NEHolt renamed variable to avoid confusion
    (if (> (+ p_so_far p_to_do) max_pnts)
      nil ; can't fit
      T ; can fit
    )
  )  
  ; --
; -- ** 10-Aug-07 NEHolt made local to this c:wdio_doit function
  (defun wdio_look4_plcpost_utils ( / aux_load_lst xx x)
    ; Look in main AcadE support folder (ex: c:\Program files\autodesk\Acade 2004\Support\)
    ; for any ".lsp" and/or ".vlx" files with substring "plcpost" in their file name. Return
    ; list of any/all found.
    (setq aux_load_lst nil)    
    (if GBL_wd_sup
      (progn
        (setq aux_load_lst '())
        (if (setq xx (wd_1a_dir_filelist GBL_wd_sup "*.lsp" 1 nil))
        ; Filter out all except file names with the substring "plcpost" in them
          (foreach x xx
            (if (wcmatch (ace_strcase x) "*PLCPOST*")
              (setq aux_load_lst (cons (strcat GBL_wd_sup x) aux_load_lst))
            )
        ) )
        (if (setq xx (wd_1a_dir_filelist GBL_wd_sup "*.vlx" 1 nil))
          ; Filter out all except file names with the substring "plcpost" in them
          (foreach x xx
            (if (wcmatch (ace_strcase x) "*PLCPOST*")
              (setq aux_load_lst (cons (strcat GBL_wd_sup x) aux_load_lst))
            )
        ) )
        (if aux_load_lst
          (progn
            ; Sort list alphabetically and return
            (setq aux_load_lst (acad_strlsort aux_load_lst))
        ) )
    ) )    
    aux_load_lst ; return nil or list of ".lsp" and/or ".vlx" postprocessing utils to run
  )  
  ; --
  ; -- ** 10-Aug-07 NEHolt made local to this c:wdio_doit function
  (defun wdio_find_closest_wirecon_2_this_taga_attr ( ben suffix / alst xx taga_xy rtn
          min_dist enn edd)
    ; Return closest wire connection point to the TAGAxx attrib
    (setq rtn nil)
    (if (AND (setq alst (wd_get_attr_val_nam_en ben (strcat "TAGA" suffix))) (car alst))
      (progn ; ent name of TAGA attr
        (setq taga_xy (cdr (assoc 10 (entget (car alst)))))
        (setq min_dist 99999.9)
        (if (AND ben (setq enn (entnext ben))) (setq edd (entget enn)))
        (while (AND enn (/= (cdr (assoc 0 edd)) "SEQEND") 
             (/= (cdr (assoc 0 edd)) "INSERT") )
          (if (AND (= (cdr (assoc 0 edd)) "ATTRIB")
                   (wcmatch (cdr (assoc 2 edd)) (strcat "X?TERM" suffix "*")))
            (progn ; found (another) wire conn point associated with target TAGA attrib. Check dist
              (if (< (distance (cdr (assoc 10 edd)) taga_xy) min_dist)
                (progn ; this one is closer, save it.
                  (setq rtn enn)
                  (setq min_dist (distance (cdr (assoc 10 edd)) taga_xy)) ; save new shortest dist
              ) )
          ) )         
          (if (setq enn (entnext enn)) (setq edd (entget enn)))
      ) )    
    )
    rtn ; return closest wire connection attrib found
  )  
  ; --
  (defun figure_in_or_out ( str / typ x1 x2)
    ; *** 13-Jun-00 PMM use method from 3m_plc instead
    (setq typ nil x1 nil x2 nil)
    (if str
      (progn
        (setq str (ace_strcase str))
        (if (OR (wcmatch str "DI*") (wcmatch str "AI*") ) (setq typ "I" x1 1)) ; \T input
; ** 14-Jun-00 CWaugh added "D0" and "A0" (zero instead of letter "O") in case
;       user makes a typo in the data file
        (if (OR (wcmatch str "DO*") (wcmatch str "AO*") (wcmatch str "D0*") (wcmatch str "A0*")) (setq typ "O" x2 1)) ; \T output
        (if (OR (wcmatch str "IO*") (wcmatch str "I0*") ) (setq typ "IO")) ; \T both In/Out
; **
        (if (wcmatch str "*OTHER*") (setq typ "IO")) ; not really module, do as IO
        (if (not typ) ; no match yet, maybe used \D
          (progn
            (if (OR (wcmatch str "*INP*")(wcmatch str "*IN *")(wcmatch str "*IN")
; ** 29-Jun-00 NEHolt added more checks
                     (wcmatch str "*IN/*"))
              (progn ; check for "*OUT*" too
                (if (wcmatch str "*OUT*")
                  ; It's both IN and OUT
                  (setq typ "IO")
; **
                ; ELSE
                  (setq typ "I" x1 1)
                )
            ) )
; ** 28-Jun-00 NEHolt
            (if (AND (not typ)(wcmatch str "*OUT*")) (setq typ "O" x2 1))
            (if (AND x1 x2) (setq typ "IO")) ; both inputs and outputs
        ) )
    ) )
    typ
  )
  ; ---
  (defun determine_in_or_out ( module / )
    ; try to determine module type from module's 1st line of spreadsheet data

; ** 02-May-00 NEHolt
    (if (OR (= (car (car (car (nth module mod_data)))) "SKIP")
            (= (car (car (car (nth module mod_data)))) "NEW_DWG"))
      (setq io_type "I") ; dummy    
    ; ELSE
      (progn
; **
        (setq io_type nil)
        
; ** 06-Apr-07 NEHolt - 924739
        ; Addition of CATEGORY field to PLC database tables (the non-"_Data" tables)
        ; where value of "1" = inputs, "2"=outputs, "3"=combo module.
        (cond
          ((= (nth 15 (car (car (nth module mod_data)))) "1")
            (setq io_type "I") ; CATEGORY field = "1" means marked as "Inputs"
          )
          ((= (nth 15 (car (car (nth module mod_data)))) "2")
            (setq io_type "O") ; CATEGORY field = "2" means marked as "Outputs"
          )
          ((= (nth 15 (car (car (nth module mod_data)))) "3")
            (setq io_type "IO") ; CATEGORY field = "3" means marked as "Inputs"
        ) )
; ** 06-Apr-07 NEHolt.end
        ; If CATEGORY field value not defined in ace_plc.mdb, then try to figure out
        ; the module category (Inputs, Outputs, Combo) by looking for key substrings
        ; in the module descriptions.
        (if (not io_type)
          (progn ; Unknown. Try to determine module type (IN or OUT) from other data
             ; pulled PLC parametric file
            ; First try the "\T=" value (ex: "\T=DI")
            (if (>= (length (car (car (nth module mod_data)))) 14)
              (progn
                (setq str (nth 13 (car (car (nth module mod_data))))) ; use module type \T
                (setq io_type (figure_in_or_out str))
              )
            )
        ) )
        (if (not io_type)
          (progn ; no luck yet, try parsing the "\D=" description text string
            (setq str (nth 2 (car (car (nth module mod_data))))) ; use descr \D
            (setq io_type (figure_in_or_out str))
        ) )
        (if (AND (not io_type)(> volt_ix 0))
          (progn ; still empty, check for a "voltage" text string
            (setq str (nth (1- volt_ix) (nth 0 (cdr (nth module mod_data)))))
            (setq io_type (figure_in_or_out str))
        ) )
; ****  D E F A U L T  module type if all efforts fail to figure out where it is an
;       input, output, or combo module. Change the setting below to "I" if you want
;       it to default to input, "IO" for combo, "O" for output default.
        (if (not io_type) (setq io_type "IO")) ; default to both, put down center
; **

; ** 10-Apr-00 NEHolt
        (princ (strcat "\n " (c:wd_msg "IO011" (list io_type) "Module type: %1")))
; **
      )
    )
    io_type
  )
; ** 06-Nov-99 NEHolt
  (defun wdio_anno_desc1 ( en data / lst rtn) 
    (setq rtn nil) ; ** 09-Jan-02 NEHolt
    (if (> (length (setq lst (c:wd_delim_str_to_lst data "|"))) 1)
      (progn ; mult desc lines defined
        (setq rtn (c:wd_modattrval en "DESC1" (car lst) nil)) ; ** 09-Jan-02
        (c:wd_modattrval en "DESC2" (cadr lst) nil)
        (if (nth 2 lst)
          (progn ; 3rd line
            (if (not (c:wd_modattrval en "DESC3" (nth 2 lst) nil))
              ; No DESC3, combine with DESC2
              (c:wd_modattrval en "DESC2" (strcat (cadr lst) " " (nth 2 lst)) nil))
      ) ) )
    ; ELSE
      (setq rtn (c:wd_modattrval en "DESC1" data nil)) ; ** 09-Jan-02
    )
    rtn ; rtn = nil if nothing annotated ** 09-Jan-02 NEHolt
  )
; ---
  (defun ladder_cleanup ( ldr_cnt / ben )
    ; Check if unused rungs can be removed from this ladder
    ; Figure out center point of upper ladder rung
    (if Aw_debug (princ "\nIN:ladder_cleanup"))
    
    (cond
      ((= h_or_v_rungs "V")
        ; Erase unused rungs
        (setq xcoor (car first_ladder_XY_org))
        (setq pt3 (list xcoor
                (- (- (cadr first_ladder_XY_org) (* ldr_cnt ladder_2_ladder_dist)) 
                        (* ladder_width 0.5))
                0.0))             
        (setq ix ladder_rung_cnt)
        (while (> ix 0)
          (if (setq x (wd_get_nearby_line pt3))
            (progn ; hit LINE
              (setq ed (entget x))
              ; check length of LINE
              (if (equal (distance (cdr (assoc 10 ed)) (cdr (assoc 11 ed)))
                  ladder_width 0.1)
                ; this LINE is same width as ladder. Erase LINE.
                (c:wd_trimwire x pt3)
          ) ) )
          (setq ix (1- ix))
          (setq xcoor (+ xcoor rung_spacing))
          (setq pt3 (list xcoor (cadr pt3) 0.0))       
        )
        
; ** 19-Feb-03 NEHolt        
        (if (not suppress_rails)
          (progn ; Prepare to insert source/destinations
; **          
            ; Find left-hand vertical bus wire
    
; ** 04-Feb-02 NEHolt
        ; Insert the "Destination" arrows at the left end of HOT and NEUTRAL bus    
;        (setq x (nentselp (list
;             (+ (car first_ladder_XY_org) rung_spacing)
;             (- (cadr first_ladder_XY_org) (* ldr_cnt ladder_2_ladder_dist))
;              0.0))) 
            (setq x (wd_get_nearby_line (list (+ (car first_ladder_XY_org) (* 0.5 rung_spacing))
                                          (- (cadr first_ladder_XY_org) (* ldr_cnt ladder_2_ladder_dist)) 0.0)))
                                      
            (if x
              (progn ; Hit something, check if horiz bus wire
;                (setq ed (entget (car x)))
                (setq ed (entget x))
; **            
                (if (= (cdr (assoc 0 ed)) "LINE")
                  (progn
                    (if (equal (cadr (cdr (assoc 10 ed)))
                           (cadr (cdr (assoc 11 ed))) 0.01)
                      (progn ; yes, it is horizontal
                        (if (OR (> module 0) (> ldr_cnt 0))
                          (progn ; not first column, put DEST arrows on left end
                            (setq pt3 (cdr (assoc 10 ed)))
                            (setq str (strcat "HA" (itoa arrow_style) "D3"))
                            (setq ben (c:wd_insym2 str pt3 1.0 nil))
                            (if ben
                              (progn ; Change SIGCODE value
                                (c:wd_modattrval ben "SIGCODE" (strcat "HOT_" (itoa srccnt)) 1)
; ** 16-Jan-03 NEHolt                                                                                
                                (cond
                                  ((= srccnt 0))  ; this is the first ladder, first drawing. Skip annotation of SHEET/REF on this one
                                  ((= ldr_cnt 0) ; first ladder on dwg, get SHEET value of previous sheet
                                    (c:wd_modattrval ben "SHEET" (c:wd_increment_str sheet_str -2) nil)
                                    (if ladder_prev_dwg_last_ref (c:wd_modattrval ben "XREF" ladder_prev_dwg_last_ref nil))
                                  )                               
                                  ((> ldr_cnt 0) ; 1st ladder on this sheet
                                    ; ladder_cnt = max ladders per sheet
                                    ; ldr_cnt = 0 for 1st ladder, 1 for 2nd ladder on sheet and so on
                                    (setq ref2use (cadr (nth (1- ldr_cnt) ladder_first_ref_lst))) ; starting line ref for this ladder
                                    (c:wd_modattrval ben "XREF" ref2use nil)
                                    (c:wd_modattrval ben "SHEET" (c:wd_increment_str sheet_str -1) nil)
                                  )
                                )
; **                                                           
                            ) )
                            ; Do NEUTRAL at left
                            (setq pt3 (list (car pt3) (- (cadr pt3) ladder_width)
                                     0.0))                         
                            (setq str (strcat "HA" (itoa arrow_style) "D3"))
                            (setq ben (c:wd_insym2 str pt3 1.0 nil))
                            (if ben
                              (progn ; Change SIGCODE value
                                (c:wd_modattrval ben "SIGCODE" (strcat "NEUTRAL_" (itoa srccnt)) 1)
; ** 16-Jan-03 NEHolt                                                                                
                                (cond
                                  ((= srccnt 0))  ; this is the first ladder, first drawing. Skip annotation of SHEET/REF on this one
                                  ((= ldr_cnt 0) ; first ladder on dwg, get SHEET value of previous sheet
                                    (c:wd_modattrval ben "SHEET" (c:wd_increment_str sheet_str -2) nil)
                                    (if ladder_prev_dwg_last_ref (c:wd_modattrval ben "XREF" ladder_prev_dwg_last_ref nil))
                                  )                               
                                  ((> ldr_cnt 0) ; 1st ladder on this sheet
                                    ; ladder_cnt = max ladders per sheet
                                    ; ldr_cnt = 0 for 1st ladder, 1 for 2nd ladder on sheet and so on
                                    (setq ref2use (cadr (nth (1- ldr_cnt) ladder_first_ref_lst))) ; starting line ref for this ladder
                                    (c:wd_modattrval ben "XREF" ref2use nil)
                                    (c:wd_modattrval ben "SHEET" (c:wd_increment_str sheet_str -1) nil)
                                  )
                                )
; **                                                        
                        ) ) ) )
            ) ) ) ) ) )
            ; Insert Source arrows at right end of HOT and NEUTRAL bus
; ** 04-Feb-03 NEHolt        
;            (setq x (nentselp (list
;                 (+ (car first_ladder_XY_org)
;                     (* (1- ladder_rung_cnt) rung_spacing))        
;                 (- (cadr first_ladder_XY_org) (* ldr_cnt ladder_2_ladder_dist))
;                  0.0)))
            (setq x (wd_get_nearby_line (list (+ (car first_ladder_XY_org) (* (- ladder_rung_cnt 1.5) rung_spacing))
                                          (- (cadr first_ladder_XY_org) (* ldr_cnt ladder_2_ladder_dist)) 0.0)))
                            
            (if x
              (progn ; Hit something, check if horiz bus wire
;                (setq ed (entget (car x)))
                (setq ed (entget x))
; **            
                (if (= (cdr (assoc 0 ed)) "LINE")
                  (progn
                    (if (equal (cadr (cdr (assoc 10 ed)))
                           (cadr (cdr (assoc 11 ed))) 0.01)
                      (progn ; yes, it is horiz
; **              
                        ; Do hot at right
                        (setq srccnt (1+ srccnt)) ; increment SRC/DEST code
                        (setq pt3 (cdr (assoc 11 ed))) ; bottom point of wire
                        (setq str (strcat "HA" (itoa arrow_style) "S1"))
                        (setq ben (c:wd_insym2 str pt3 1.0 nil))
                        (if ben
                          (progn ; Insert SIGCODE value
                            (c:wd_modattrval ben "SIGCODE" (strcat "HOT_" (itoa srccnt)) 1)
; ** 16-Jan-03 NEHolt                        
                            (setq ref2use (car (nth (1+ ldr_cnt) ladder_first_ref_lst))) ; starting line ref for this ladder
                            (c:wd_modattrval ben "XREF" ref2use nil) 
                            (cond
                              ((= ldr_cnt (1- ladder_cnt)) ; last ladder on sheet, point at next SHEET
                                (c:wd_modattrval ben "SHEET" sheet_str nil)
                              )
                              (T 
                                (c:wd_modattrval ben "SHEET" (c:wd_increment_str sheet_str -1) nil)
                              )
                            )                                                                               
                        ) )
                        ; Now do NEUTRAL at right
                        (setq pt3 (list (car pt3) 
                                    (- (cadr pt3) ladder_width) 0.0))
                        (setq str (strcat "HA" (itoa arrow_style) "S1"))
                        (setq ben (c:wd_insym2 str pt3 1.0 nil))
                        (if ben
                          (progn ; Change SIGCODE value
                            (c:wd_modattrval ben "SIGCODE" (strcat "NEUTRAL_" (itoa srccnt)) 1)
; ** 16-Jan-03 NEHolt                        
                            (setq ref2use (car (nth (1+ ldr_cnt) ladder_first_ref_lst))) ; starting line ref for this ladder
                            (c:wd_modattrval ben "XREF" ref2use nil) 
                            (cond
                              ((= ldr_cnt (1- ladder_cnt)) ; last ladder on sheet, point at next SHEET
                                (c:wd_modattrval ben "SHEET" sheet_str nil)
                              )
                              (T 
                                (c:wd_modattrval ben "SHEET" (c:wd_increment_str sheet_str -1) nil)
                              )
                        ) ) )                                                                              
        ) ) ) ) ) ) ) )              
      )
      (T ; horiz rungs, vertical ladders
        (setq ycoor (cadr first_ladder_XY_org))
        (setq pt3 (list
               (+ (* ladder_width 0.5)
                (+ (* ldr_cnt ladder_2_ladder_dist) (car first_ladder_XY_org)) )
               ycoor 0.0))
        (setq ix ladder_rung_cnt)
        (while (> ix 0)        
          (if (setq x (wd_get_nearby_line pt3))
            (progn ; hit LINE
              (setq ed (entget x))
              ; check length of LINE
              (if (equal (distance (cdr (assoc 10 ed)) (cdr (assoc 11 ed)))
                  ladder_width 0.1)
                ; this LINE is same width as ladder. Erase LINE.
                (c:wd_trimwire x pt3)
          ) ) )
          (setq ix (1- ix))
          (setq ycoor (- ycoor rung_spacing))
          (setq pt3 (list (car pt3) ycoor 0.0))
        )
; ** 19-Feb-03 NEHolt        
        (if (not suppress_rails)
          (progn ; Prepare to insert source/destinations
; **          
            ; Find left-hand vertical bus wire
    
; ** 04-Feb-02 NEHolt
        ; Insert the "Destination" arrows at the top of HOT and NEUTRAL bus    
;        (setq x (nentselp (list
;             (+ (* ldr_cnt ladder_2_ladder_dist) (car first_ladder_XY_org))
;             (- (cadr first_ladder_XY_org) rung_spacing) 0.0)))
            (setq x (wd_get_nearby_line (list (+ (* ldr_cnt ladder_2_ladder_dist) (car first_ladder_XY_org))
                                          (- (cadr first_ladder_XY_org) (* 0.5 rung_spacing) 0.0))))
            (if x
              (progn ; Hit something, check if vertical bus wire          
;                (setq ed (entget (car x)))
                (setq ed (entget x))
; **            
                (if (= (cdr (assoc 0 ed)) "LINE")
                  (progn
                    (if (equal (car (cdr (assoc 10 ed)))
                           (car (cdr (assoc 11 ed))) 0.01)
                      (progn ; yes, it is vertical
                        (if (OR (> module 0) (> ldr_cnt 0))
                          (progn ; not first column, put DEST arrows on top
                            ; Do HOT at TOP to point back at bottom of previous ladder
                            (setq pt3 (cdr (assoc 10 ed)))
                            (setq str (strcat "HA" (itoa arrow_style) "D2"))
                            ;(setq str (strcat "HA" (itoa destination_style) "D2")); ** > 2-14-02 ScottH
                            (setq ben (c:wd_insym2 str pt3 1.0 nil))
                            (if ben
                              (progn ; Change SIGCODE value on DEST symbol at top left bus
                                (c:wd_modattrval ben "SIGCODE" (strcat "HOT_" (itoa srccnt)) 1)
; ** 16-Jan-03 NEHolt                                                                                
                                (cond
                                  ((= srccnt 0))  ; this is the first ladder, first drawing. Skip annotation of SHEET/REF on this one
                                  ((= ldr_cnt 0) ; first ladder on dwg, get SHEET value of previous sheet
                                    (c:wd_modattrval ben "SHEET" (c:wd_increment_str sheet_str -2) nil)
                                    (if ladder_prev_dwg_last_ref (c:wd_modattrval ben "XREF" ladder_prev_dwg_last_ref nil))
                                  )                               
                                  ((> ldr_cnt 0) ; 1st ladder on this sheet
                                    ; ladder_cnt = max ladders per sheet
                                    ; ldr_cnt = 0 for 1st ladder, 1 for 2nd ladder on sheet and so on
                                    (setq ref2use (cadr (nth (1- ldr_cnt) ladder_first_ref_lst))) ; starting line ref for this ladder
                                    (c:wd_modattrval ben "XREF" ref2use nil)
                                    (c:wd_modattrval ben "SHEET" (c:wd_increment_str sheet_str -1) nil)
                                  )
                                )
; **                            
                            ) )
                            ; Do NEUTRAL at TOP point back at bottom of previous ladder
                            (setq pt3 (list (+ (car pt3) ladder_width)
                                    (cadr pt3) 0.0))                         
                            (setq str (strcat "HA" (itoa arrow_style) "D2"))
                            (setq ben (c:wd_insym2 str pt3 1.0 nil))
                            (if ben
                              (progn ; Change SIGCODE value on DEST symbol at top right bus of this ladder
                                (c:wd_modattrval ben "SIGCODE" (strcat "NEUTRAL_" (itoa srccnt)) 1)
; ** 16-Jan-03 NEHolt                                                    
                                (cond
                                  ((= srccnt 0))  ; this is the first ladder, first drawing. Skip annotation of SHEET/REF on this one
                                  ((= ldr_cnt 0) ; first ladder on dwg, get SHEET value of previous sheet
                                     (c:wd_modattrval ben "SHEET" (c:wd_increment_str sheet_str -2) nil)
                                     (if ladder_prev_dwg_last_ref (c:wd_modattrval ben "XREF" ladder_prev_dwg_last_ref nil))                                
                                  )                               
                                  ((> ldr_cnt 0) ; 2nd ladder or beyond                          
                                    (setq ref2use (cadr (nth (1- ldr_cnt) ladder_first_ref_lst))) ; starting line ref for this ladder
                                    (c:wd_modattrval ben "XREF" ref2use nil)
                                    (c:wd_modattrval ben "SHEET" (c:wd_increment_str sheet_str -1) nil)                                                                
                                  )
                                )
; **                            
                        ) ) ) )
            ) ) ) ) ) )

            ; Insert Source arrows at bottom on HOT and NEUTRAL bus
; ** 04-Feb-03 NEHolt        
;            (setq x (nentselp (list
;                 (+ (* ldr_cnt ladder_2_ladder_dist) (car first_ladder_XY_org))
;                 (- (cadr first_ladder_XY_org)
;                     (* (1- ladder_rung_cnt) rung_spacing)) 0.0)))
            (setq x (wd_get_nearby_line (list (+ (* ldr_cnt ladder_2_ladder_dist) (car first_ladder_XY_org))
                                          (- (cadr first_ladder_XY_org) (* (- ladder_rung_cnt 1.5) rung_spacing)) 0.0)))                 
            (if x
              (progn ; Hit something, check if vertical bus wire
;                (setq ed (entget (car x)))
                (setq ed (entget x))
; **            
                (if (= (cdr (assoc 0 ed)) "LINE")
                  (progn
                    (if (equal (car (cdr (assoc 10 ed)))
                           (car (cdr (assoc 11 ed))) 0.01)
                      (progn ; yes, it is vertical
; **              
                        ; Do bottom
                        (setq srccnt (1+ srccnt)) ; increment SRC/DEST code
                        (setq pt3 (cdr (assoc 11 ed))) ; bottom point of wire
                        (setq str (strcat "HA" (itoa arrow_style) "S4"))
   ;(setq str (strcat "HA" (itoa source_style) "S4")); ** > 2-14-02 ScottH
                        (setq ben (c:wd_insym2 str pt3 1.0 nil))
                        (if ben
                          (progn ; Insert SIGCODE value
                            (c:wd_modattrval ben "SIGCODE" (strcat "HOT_" (itoa srccnt)) 1)
; ** 16-Jan-03 NEHolt                        
                            (setq ref2use (car (nth (1+ ldr_cnt) ladder_first_ref_lst))) ; starting line ref for this ladder
                            (c:wd_modattrval ben "XREF" ref2use nil) 
                            (cond
                              ((= ldr_cnt (1- ladder_cnt)) ; last ladder on sheet, point at next SHEET
                                (c:wd_modattrval ben "SHEET" sheet_str nil)
                              )
                              (T 
                                (c:wd_modattrval ben "SHEET" (c:wd_increment_str sheet_str -1) nil)
                              )
                            )                               
                        
; **                                                
                        ) )
                        ; Now do NEUTRAL at bottom
                        (setq pt3 (list (+ (car pt3) ladder_width)
                                (cadr pt3) 0.0))
                        (setq str (strcat "HA" (itoa arrow_style) "S4"))
    ;(setq str (strcat "HA" (itoa source_style) "S4")); ** > 2-14-02 ScottH
                        (setq ben (c:wd_insym2 str pt3 1.0 nil))
                        (if ben
                          (progn ; Change SIGCODE value
                            (c:wd_modattrval ben "SIGCODE" (strcat "NEUTRAL_" (itoa srccnt)) 1)
; ** 16-Jan-03 NEHolt                        
                            (setq ref2use (car (nth (1+ ldr_cnt) ladder_first_ref_lst))) ; starting line ref for this ladder                        
                            (c:wd_modattrval ben "XREF" ref2use nil)                                
                            (cond
                              ((= ldr_cnt (1- ladder_cnt)) ; last ladder on sheet, point at next SHEET
                                (c:wd_modattrval ben "SHEET" sheet_str nil)
                              )
                              (T 
                                (c:wd_modattrval ben "SHEET" (c:wd_increment_str sheet_str -1) nil)
                              )
                            )                               
; **                        
        ) ) ) ) ) ) ) ) ) )
    ) )    
    (if Aw_debug (princ "\nOUT:ladder cleanup"))
  )

; ** 05-May-00 NEHolt
  (defun chk2_del_wire ( / ) 
    (cond 
      ((= h_or_v_rungs "V")
        (if (AND (/= plc_keep_shorted_wire 1) xcoor) 
          (progn ; Erase connected wire
            (setq pt2 (list xcoor comp_y_coor 0.0))       
            (if (setq x (wd_get_nearby_line pt2)) (c:wd_trimwire x pt2))
        ) )          
      )
      (T
        (if (AND (/= plc_keep_shorted_wire 1) ycoor) ; ** 12-Apr-02 NEHolt fixed typo
          (progn ; Erase connected wire
            (setq pt2 (list comp_x_coor ycoor 0.0))       
            (if (setq x (wd_get_nearby_line pt2)) (c:wd_trimwire x pt2))
        ) )    
  ) ) )
; ** 22-Jun-00 NEHolt
  (defun wd_wdio_do_tag_attr ( en val / x ed pos rtn)
    ; "en" = block insert entity name
    ; "val" = value to insert on to "TAG*" attribute
    ; if "val" contains a ":" character AND the block name is a terminal "?T0*"
    ;  AND there is a TERM01 attribute found on the block, split out the
    ;  text after the ":" char and apply it to the TERM01 attribute. Put the
    ;  remainder on the TAGSTRIP attribute
    (setq rtn nil) ; ** 09-Jan-02 NEHolt
    (setq ed (entget en))
    (if (AND (wcmatch (cdr (assoc 2 ed)) "?T0*,?T1*,?T_*") ; its a terminal ; ** 11-Apr-02 added "?T1*" and "?T_*" terminal names
             (c:wd_getattrval en "TERM01") ; Terminal has TERM01 attrib
             (> (setq pos (wdio_1_strchr val ":")) 0))
      (progn ; okay, split and annotate
        ; Insert substring AFTER the ":" character as TERM01 text
        (setq rtn (c:wd_modattrval en "TERM01" (substr val (1+ pos)) nil)) ; terminal number
        (if (> pos 1)
          (progn ; Insert subtring up to the ":" char as TAGSTRIP text on the terminal
            (setq rtn (c:wd_modattrval en "TAG*" (substr val 1 (1- pos)) nil)) ; ** 09-Jan-02
        ) )
      )
    ; ELSE just put entire val value on to TAG* attrib
      (progn
; ** 18-Oct-07 NEHolt      
        ; Try to force the "TAG*" attribute to be a "Fixed" tag value
        (setq x (wd_1_get_attr_val_nam_en en "TAG1"))
        (if (car x) ; component carries attribute TAG1. Go ahead and mark it "fixed".
          (progn
            (wd_set_comptag (car x) "TAG1" val 1 en)
            (setq rtn 1) ; flag success
          )
        ; ELSE
; ** 18-Oct-07 NEHolt.en        
          (setq rtn (c:wd_modattrval en "TAG*" val nil)) ; ** 09-Jan-02
    ) ) )
    rtn ; return nil if no attrib value updated ; ** 09-Jan-02 NEHolt  
  ) 
  
; ** 10-Aug-07 NEHolt
  (defun wdio_accum_extra_attr_data ( str accumulated_attr_pair_data / main_val lst2 lst3 x new_main_val hitx)
      ; "str" = attribute value. Parse for ";" characters followed by "=" characters. Each combo, if found,
      ; represents another piggy-backed attribute name=value combo to insert. For example, if attribute
      ; value is "CR101;TERM01=X;TERM02=Y" then "CR101" is the attrib value for the main attribute being
      ; processed and TERM01 and TERM02 are two more attributes to look for on the symbol and, if found,
      ; assign values of "X" and "Y" respectively. This capability eliminates the need to add support for
      ; many more columns in the spreadsheet... additional attributes can be mixed in with the existing
      ; attribute value columns as needed.
      (if Aw_debug (princ "\nIN:wdio_accum_extra_attr_data"))
      (setq main_val str) ; default to return the same string passed in
      (setq hitx nil)
      (setq new_main_val nil)
      (if (AND str (/= str ""))
        (progn ; look for ";" delimiters
          (setq lst2 (c:wd_delim_str_to_lst str ";"))
          (if (> (length lst2) 1)
            (progn ; two or more sublists. First one is the main value, 2+ are name=val pairs
              (setq new_main_val (car lst2))
              (setq lst2 (cdr lst2)) ; strip of the main value
              (foreach x lst2 ; now process each substring delimited by ";". Look for embedded "="
                (setq lst3 (c:wd_delim_str_to_lst x "="))
                (if (> (length lst3) 1)
                  (progn ; okay, hit. First element = attr name, 2nd=value
                    (setq accumulated_attr_pair_data (cons (list (car lst3) (cadr lst3)) accumulated_attr_pair_data))
                    (setq hitx 1) ; remember that have hit at least one extra attribute pair
                ) )
              )
              (if hitx
                ; some found, safe to return just the first part as the main attribute value
                (setq main_val new_main_val)
              )
          ) )
      ) )
    (if Aw_debug (princ "\nOUT:wdio_accum_extra_attr_data"))
    (list main_val accumulated_attr_pair_data) ; return main attrib value and accumulated values
  )
  ; --
  (defun wdio_write_out_accum_extra_attr_data ( en lst2 / atnam atval x )
    ; "lst2" = (list (list attrnam attrval) (list attrnam attrval) ...)
    (foreach x lst2
      (if (AND (not (c:wd_modattrval en (car x) (cadr x) 1)) (/= (car x) ""))
        (progn ; target attribute name not found
          ; If it is the format of CATxx, MFGxx, CNTxx, ASSYCODExx, or WDBLKNAMxx then write out as XData
          (if (wcmatch (car x) "CAT??,MFG??,CNT??,ASSYCODE??,UM??,WDBLKNAM??")
            (progn ; write as XData
              (c:wd_upd_pnlval en (car x) (cadr x))              
        ) ) )
      )
  ) )
; ** 10-Aug-07 NEHolt.end  
  
; -- ** 09-Jan-02 NEHolt broke out into its own subroutine
  (defun wdio_annotate_inserted_symbol ( en / acnt extra_attr_pairs)
    ; "en" -- inserted device symbol
    ; -- main subroutine
    (if Aw_debug (princ "\nIN:wdio_annotate_inserted_symbol"))
    (setq acnt 0)
    
    (setq extra_attr_pairs nil) ; ** 10-Aug-07 NEHolt
    
    (if (AND (> (setq ixx (eval (read (strcat "comp_tag_ix" (itoa i_xx))))) 0)
                      (nth (1- ixx) data) (/= (nth (1- ixx) data) ""))
      (progn   
; ** 10-Aug-07 NEHolt      
;        (setq main_val (wdio_look_for_extra_attr_data (nth (1- ixx) data)))
        (setq x (wdio_accum_extra_attr_data (nth (1- ixx) data) extra_attr_pairs))
        (setq main_val (car x))
        (setq extra_attr_pairs (cadr x))
; ** 10-Aug-07 NEHolt.end        
        (if (wd_wdio_do_tag_attr en main_val) 
          (setq acnt (1+ acnt))
           
; ** 24-May-02 NEHolt           
        ; ELSE
          (progn ; no TAG* attrib, look for SIGCODE. Might be a "Signal" arrow or stand-alone ref symbol
            (if (c:wd_getattrval en "SIGCODE")
              (progn ; Yes, appears to be a SIG arrow or Stand-Alone ref symbol
                     ; Put the "Device Tag" field value into the SIGCODE attrib's value and
                     ; the "Device Loc" field value into the XREF attrib's value, if present
; ** 11-Jul-03 NEHolt                     
;                (if (c:wd_modattrval en "SIGCODE" (nth (1- ixx) data) nil)(setq acnt (1+ acnt)))  
                (if (c:wd_modattrval en "SIGCODE" main_val nil)(setq acnt (1+ acnt)))  
; **                
                (if (AND (> (setq ixx (eval (read (strcat "comp_loc_ix" (itoa i_xx))))) 0)
                            (nth (1- ixx) data) (/= (nth (1- ixx) data) ""))
                  (progn   
                    (if (c:wd_modattrval en "XREF" (nth (1- ixx) data) nil) (setq acnt (1+ acnt)))
          ) ) ) ) )                
        )  
    ) )
    (if (AND (> (setq ixx (eval (read (strcat "comp_desc_ix" (itoa i_xx))))) 0)
         (nth (1- ixx) data) (/= (nth (1- ixx) data) ""))
      (progn   
; ** 10-Aug-07 NEHolt         
;        (setq main_val (wdio_look_for_extra_attr_data (nth (1- ixx) data)))
        (setq x (wdio_accum_extra_attr_data (nth (1- ixx) data) extra_attr_pairs))
        (setq main_val (car x))
        (setq extra_attr_pairs (cadr x))
        (if (wdio_anno_desc1 en main_val) (setq acnt (1+ acnt)))
;        (if extra_attr_pairs (wdio_write_out_accum_extra_attr_data en extra_attr_pairs)) ; extra attribs delimited with ";"
;        (setq extra_attr_pairs nil)
; **        
    ) )    
    (if (AND (> (setq ixx (eval (read (strcat "comp_loc_ix" (itoa i_xx))))) 0)
         (nth (1- ixx) data) (/= (nth (1- ixx) data) ""))
      (progn   
; ** 10-Aug-07 NEHolt         
        (setq x (wdio_accum_extra_attr_data (nth (1- ixx) data) extra_attr_pairs))
        (setq main_val (car x))
        (setq extra_attr_pairs (cadr x))
        (if (c:wd_modattrval en "LOC" main_val nil) (setq acnt (1+ acnt))) ; ** 18-Nov-03 NEHolt typo
;        (if extra_attr_pairs (wdio_write_out_accum_extra_attr_data en extra_attr_pairs)) ; extra attribs delimited with ";"
;        (setq extra_attr_pairs nil)
; **        
    ) )
 ; ** 22-Feb-02 SAH
    (if (AND (> (setq ixx (eval (read (strcat "comp_inst_ix" (itoa i_xx))))) 0)
         (nth (1- ixx) data) (/= (nth (1- ixx) data) ""))
      (progn   
; ** 11-Jul-03 NEHolt         
        (setq x (wdio_accum_extra_attr_data (nth (1- ixx) data) extra_attr_pairs))
        (setq main_val (car x))
        (setq extra_attr_pairs (cadr x))
        (if (c:wd_modattrval en "INST" main_val nil) (setq acnt (1+ acnt)))
;        (if extra_attr_pairs (wdio_write_out_accum_extra_attr_data en extra_attr_pairs)) ; extra attribs delimited with ";"
;        (setq extra_attr_pairs nil)
; **        
    ) )
    (if (AND (> (setq ixx (eval (read (strcat "comp_mfg_ix" (itoa i_xx))))) 0)
         (nth (1- ixx) data) (/= (nth (1- ixx) data) ""))
      (progn   
; ** 11-Jul-03 NEHolt         
        (setq x (wdio_accum_extra_attr_data (nth (1- ixx) data) extra_attr_pairs))
        (setq main_val (car x))
        (setq extra_attr_pairs (cadr x))
;        (setq main_val (wdio_look_for_extra_attr_data (nth (1- ixx) data)))
        (if (c:wd_modattrval en "MFG" main_val nil) (setq acnt (1+ acnt)))
;        (if extra_attr_pairs (wdio_write_out_accum_extra_attr_data en extra_attr_pairs)) ; extra attribs delimited with ";"
;        (setq extra_attr_pairs nil)
; **        
    ) )
    (if (AND (> (setq ixx (eval (read (strcat "comp_cat_ix" (itoa i_xx))))) 0)
         (nth (1- ixx) data) (/= (nth (1- ixx) data) ""))
      (progn         
; ** 11-Jul-03 NEHolt         
        (setq x (wdio_accum_extra_attr_data (nth (1- ixx) data) extra_attr_pairs))
        (setq main_val (car x))
        (setq extra_attr_pairs (cadr x))
;        (setq main_val (wdio_look_for_extra_attr_data (nth (1- ixx) data)))
        (if (c:wd_modattrval en "CAT" main_val nil) (setq acnt (1+ acnt)))
;        (if extra_attr_pairs (wdio_write_out_accum_extra_attr_data en extra_attr_pairs)) ; extra attribs delimited with ";"
;        (setq extra_attr_pairs nil)
; **        
    ) )
    (if (AND (> (setq ixx (eval (read (strcat "comp_asm_ix" (itoa i_xx))))) 0)
         (nth (1- ixx) data) (/= (nth (1- ixx) data) ""))
      (progn   
; ** 11-Jul-03 NEHolt         
        (setq x (wdio_accum_extra_attr_data (nth (1- ixx) data) extra_attr_pairs))
        (setq main_val (car x))
        (setq extra_attr_pairs (cadr x))
;        (setq main_val (wdio_look_for_extra_attr_data (nth (1- ixx) data)))
        (if (c:wd_modattrval en "ASSYCODE" main_val nil) (setq acnt (1+ acnt)))
;        (if extra_attr_pairs (wdio_write_out_accum_extra_attr_data en extra_attr_pairs)) ; extra attribs delimited with ";"
;        (setq extra_attr_pairs nil)
; **        
    ) )
; ** 10-Aug-07 NEHolt    
    (if extra_attr_pairs (wdio_write_out_accum_extra_attr_data en extra_attr_pairs)) ; extra attribs delimited with ";"
    (setq extra_attr_pairs nil)
; ** 10-Aug-07 NEHolt.end    
    (if Aw_debug (princ "\nOUT:wdio_annotate_inserted_symbol"))    
    acnt ; rtn 0=nothing updated, otherwise return cnt of attribs updated        
  )                                 

  ; --- MAIN ROUTINE ---
  (if Aw_debug (princ "\nIN:wdio_doit"))
  (princ (strcat "\n" (c:wd_msg "IO012" nil "Spreadsheet --> I/O builder")))
;  (user_settings)
  (setq err_old *error*) ; Save old error handler
; ** 17-Feb-00
  (setq *error* wdio_err) ; New error handler
; **
  (setq GBL_wd_#cmdecho (getvar "CMDECHO"))
  (setvar "CMDECHO" 0)
  (command "_.UNDO" "_MARK")
  (command "_.UNDO" "_GROUP")
  (setq GBL_wd_#osmode (getvar "OSMODE"))
  (setvar "OSMODE" 0)
  (setq GBL_wd_wdio_#attreq (getvar "ATTREQ"))
  (setvar "ATTREQ" 0)
  (setq GBL_wd_#blipmode (getvar "BLIPMODE"))
  (setvar "BLIPMODE" 0)
  (setq notfoundlst nil)
; **
  (setq ss (ssget "_X" '((-4 . "<AND")(0 . "INSERT")(2 . "WD_M")(-4 . "AND>")) ))
  (if (= ss nil)
    (progn ; WD_M block not present. Insert it.
; ** 18-Feb-99 NEHolt
      ; AcadE makes some wd.env variables and/or current project
      ; settings visible to AutoLISP. Look for a defined path to symbol
      ; libraries
      (if (setq x (c:wd_does_block_exist "WD_M")) ; look in AcadE paths for wd_m.dwg
        (progn ; Found path to wd_m.dwg, insert it
          (command "_.INSERT" x "0,0" "" "" "")
          (princ (strcat "\n " (c:wd_msg "IO016" nil "Inserted WD_M block") " "))
          (princ x)
; ** 28-Mar-00 NEHolt
          ; If an AcadE project is active then make this new drawing's WD_M block
          ; setting match those carried in the overall project "wdp" file.
          (c:wd_setup_d_match_p)
; **
          (if (not GBL_wd_lib)
            (progn
              (if x ; strip off path of wd_m
                (setq GBL_wd_lib (substr x 1 (- (strlen x) 8)))
          ) ) )

        )
; **
      ; ELSE
        (progn
          (c:wd_block_path_failed_msg "wd_m")
          (exit)
  ) ) ) )
  (setq ss nil)
  

; ** 18-Jul-00 NEHolt
  (if (not sheet_str)(setq sheet_str "01"))
    
  (if (not GBL_wd_trp)(wd_1_set_scl_factor)) ; Set drawing's default "trap" value ** 06-Dec-06 NEHolt

  ; annotate WD_M block's SHEET attribute with current sheet string
  (setq en (c:wd_reread_dwg_params))
  (if (AND (/= sheet_str "") en)
    (progn
      (c:wd_modattrval en "SHEET,SHEET_" sheet_str 1)  ; 27-Mar-02 NEHolt added "SHEET_" for GM compatibility
      (setq sheet_str (c:wd_increment_str sheet_str 1)) ; increment for next time
  ) )

; ** 13-Jul-02 NEHolt  
  (if (AND continuation_dwg_attribs en)
    (progn ; some WD_M attrib values passed in the "continuation_dwg_lst" params 
           ; list in call to (c:wdio_autorun params_lst). Format will be
           ; (list "attrnam=attrval" "attrnam=attrval" ...)
      (foreach x continuation_dwg_attribs
        (setq xx (wdio_1_strchr x "="))
        (if (AND xx (> xx 1) (> (strlen x) xx))
          (progn
            (if (c:wd_modattrval en (substr x 1 (1- xx)) (substr x (1+ xx)) 1)            
              (progn
                (princ (strcat "\n " (c:wd_msg "IO017" (list (substr x 1 (1- xx)) (substr x (1+ xx)))  "WD_M block attribute %1 --> %2") " "))
        ) ) ) )
      )
      (setq en (c:wd_reread_dwg_params)) ; make sure GBL_wd_m has new values inserted above         
    )
  )


  (if (not GBL_prev_dwg_feature_scale)
    (progn
      (setq GBL_prev_dwg_feature_scale (c:wd_getattrval en "FEATURE_SCL"))
      (setq GBL_prev_dwg_unit_scale (c:wd_getattrval en "UNIT_SCL"))
      ; calculate scale to use for PLC insert, wire num insert, and
      ; in-line device insert
      (setq scale (* (atof GBL_prev_dwg_feature_scale)
                     (atof GBL_prev_dwg_unit_scale)))
    )
  ; ELSE
    (progn ; make sure that this new dwg has same FEATURE_SCL and
           ; UNIT_SCL values on WD_M block that were present on 1st dwg
      (c:wd_modattrval en "UNIT_SCL" GBL_prev_dwg_unit_scale 1)
      (c:wd_modattrval en "FEATURE_SCL" GBL_prev_dwg_feature_scale 1)
      (c:wd_reread_dwg_params)
  ) )
; ** 29-Dec-05 NEHolt  
  (setq fullmm nil)     
  (if (AND GBL_wd_m (nth 50 GBL_wd_m))
    (progn ; check if "Full mm" bit set in WD CONFIG for this dwg     
      (setq x (atoi (nth 50 GBL_wd_m)))
      (if (= (logand x 1) 1) (setq fullmm 1))
  ) )
; ** 29-Dec-05 NEHolt.en
  
  (if (AND (not refnums) GBL_wd_m (= (nth 1 GBL_wd_m) "3"))(setq refnums 3)) ; set flag
  (if (AND refnums (= (type refnums) 'INT) (> refnums 0)(< refnums 5))
    (progn ; force "ladder referencing" to mode defined in "refnums"
      (if (AND en (/= (itoa refnums) (nth 1 GBL_wd_m)))
        (progn ; force WD_M setting for REFNUMS attribute to match preset value above
          (c:wd_modattrval en "REFNUMS" (itoa refnums) 1)
          (c:wd_reread_dwg_params) ; ** 15-Oct-01 NEHolt freshen GBL_wd_m variable
      ) )
  ) )

  (setq ladder_length (+ (* (1- ladder_rung_cnt) rung_spacing)(/ rung_spacing 2.0)))
  (if (not plc_insert_y_offset_rungs_down) (setq plc_insert_y_offset_rungs_down 0))
  (setq io_type (determine_in_or_out module))
  ; Insert the ladders
  (setq pt0 first_ladder_XY_org)
; *** 12-Oct-00 PMM
  (if (AND refnums (> refnums 3))
    (setq gridxy_mode 1)
    (setq gridxy_mode nil)
  )
; ** 06-Feb-01 NEHolt
  (if (not (setq inx indx))
    (setq inx 1)
  ; ELSE
    (progn
; ** 09-Jul-02 NEHolt    
      (if (= (type indx) 'STR)
; **      
        (setq inx (atoi indx))
      ; ELSE
        (setq inx indx) ; ** 09-Jul-02 NEHolt
    ) )  
  )

  (if (= inx 0) (setq inx 1))
; ** 10-Dec-01 NEHolt moved up here, outside of "repeat" loop below
  (if (AND (= refnums 3) (/= sheet_str ""))
    (progn ; "User" block ref number markers, reset back to beginning ref number for this new sheet
      (setq ladder_first_ref dwg_ladder_first_ref) ; hex symbol refs, reset back to first ref
  ) )
; ** 16-Jan-03 NEHolt
  (setq ladder_first_ref_lst nil)
  (if (> srccnt 0)
    (setq ladder_prev_dwg_last_ref ladder_save_last_ref) ; save previous dwg's last line ref on last ladder
  ; ELSE
    (setq ladder_prev_dwg_last_ref nil) ; no dwgs started yet
  )  

  (if suppress_rails (setq options 2)(setq options 0)) 
; ** 25-Oct-03 NEHolt  
  ; Check for any existing ladder line reference blocks on this drawing  
  (if (AND (setq x (wd_1_get_gridrefs))
           (>= (length x) ladder_cnt))
    (progn           
      (setq gridxy_mode 1) ; existing refs, suppress insert of new ref nums by
                           ; making INS LADDER think it's dealing with X-Y grid ref mode 
  ) )                        
; **  
  (repeat ladder_cnt
; ** 06-Feb-01 NEHolt
    (c:wd_in_ladder 1 pt0 nil ladder_length h_or_v_rungs ladder_width
         rung_spacing rung_spacing inx gridxy_mode rung_skip ladder_first_ref 
         options) ; ** 06-Jun-02 NEHolt

; ** 16-Jan-03 NEHolt         
    ; Figure out last line ref on this new ladder
    (setq ladder_last_ref (c:wd_increment_str ladder_first_ref (fix (* (1- ladder_rung_cnt) inx))))    
    (setq ladder_first_ref_lst (cons (list ladder_first_ref ladder_last_ref) ladder_first_ref_lst))    

; **
; **    
    (if (/= use_colskip 1)
      (progn
        (setq ladder_first_ref (c:wd_increment_str ladder_first_ref (fix (* ladder_rung_cnt inx)))) ; ** 14-Dec-01 NEHolt added "(fix " to force to integer
      )      
    ; ELSE
      (progn
        (setq ladder_first_ref (c:wd_increment_str ladder_first_ref colskipcnt))
    ) )
    (command "_.ZOOM" "0.8X")
; ** 03-May-02 NEHolt    
    (cond
      ((= h_or_v_rungs "V") ; vertical rungs, ladders laying sideways
        (setq pt0 (list (car pt0) (- (cadr pt0) ladder_2_ladder_dist) 0.0))
      )      
      (T ; horiz rungs, vertical ladders
; **      
        (setq pt0 (list (+ (car pt0) ladder_2_ladder_dist) (cadr pt0) 0.0))
  ) ) )
; ** 16-Jan-03 NEHolt  
  ; "ladder_first_ref_lst" used to annotate SRC/DST arrows on the daisy chained ladders
  (setq ladder_save_last_ref ladder_last_ref)
  (if (= use_skip 1) ; Next dwg's 1st ladder is incremented by "skipcnt"
    (progn
      (setq ladder_first_ref_lst (cons (list (c:wd_increment_str dwg_ladder_first_ref skipcnt) "blank") ladder_first_ref_lst))
    )
  ; ELSE  
    (setq ladder_first_ref_lst (cons (list ladder_first_ref "blank") ladder_first_ref_lst))
  )  
  (setq ladder_first_ref_lst (reverse ladder_first_ref_lst)) ; ** 16-Jan-03 NEHolt
; **  
  (command "_.ZOOM" "_E")
  (setq ldr_cnt 0) ; start with first ladder
  (setq pnts_to_do (length (cadr (car (nth module mod_data)))))


  (setq pnts_left_to_do (- pnts_to_do pnts_so_far_this_module))

  (setq xitflg nil)
  ; *** 29-Dec-99 PMM
  (setq add_in_mod_skip 0)

; ** 04-May-00 NEHolt
  (setq whatis_cnt 0)
; **

  (setq hitbreak nil) ; ** 02-May-00 NEHolt

  (while (AND (not xitflg) (< ldr_cnt ladder_cnt))
    (princ (strcat "\n " (c:wd_msg "IO018" (list (itoa (1+ module)) (itoa (length mod_data))) "processing module %1 of %2")))
    (princ " ")

; ** 02-May-00 NEHolt
    (setq hit_skip_flag nil) ; ** 29-Sep-03 NEHolt
    ; Check for module part number "SKIP". If so, skip to next ladder
    (cond
      ((= (car (car (car (nth module mod_data)))) "SKIP")
        ; hit "SKIP" to next column part number flag
        (setq pnts_to_do 0)
        (setq pnts_left_to_do pnts_to_do)
; ** 29-Sep-03 NEHolt        
        (if (> pnts_so_far 0)
          (setq hit_skip_flag 2) ; not starting at top, need to flag to skip a full column
        ; ELSE
          (setq hit_skip_flag 1) ; starting at top, flag to skip a full column
        )
; **        
      )
; ** 18-Jul-07 NEHolt      
      ((= (car (car (car (nth module mod_data)))) "NEW_DWG")
        ; skip to next drawing
        (setq pnts_to_do 0)
        (setq pnts_left_to_do pnts_to_do)
        (setq hit_skip_flag 3) ; flag to skip to next drawing
      )
      (T
        (cond
          ((= h_or_v_rungs "V") ; vertical rungs, sideways ladders and PLC modules
            ; First figure out "x" coordinate for start of module
            (if (> pnts_so_far 0)
              (progn ; starting a 2nd module to right of another in same column
                (setq xcoor (+ (car first_ladder_XY_org) (* pnts_so_far rung_spacing)))
                ; Check for SPACERS in upper module and adjust staring point down one
                ; extra rung for each SPACER found.
              )
            ; else
              (progn
                (setq xcoor (+ (car first_ladder_XY_org)
                        (* plc_insert_y_offset_rungs_down rung_spacing)))
                (setq pnts_so_far plc_insert_y_offset_rungs_down)
            ) )
         
            (cond
              ((= io_type "I")
                (setq pt1 (list xcoor 
                   (-  (- (cadr first_ladder_XY_org) (* ldr_cnt ladder_2_ladder_dist))
                       (- ladder_width plc_input_x_offset)) 0.0))
                ; figure out insert y coor for any components that tie to module
                (setq comp_y_coor
                    (- (- (cadr first_ladder_XY_org) (* ldr_cnt ladder_2_ladder_dist))
                       plc_input_device_x_offset))
              )
              ((= io_type "IO")  ; both inputs and outputs, put down center
                (setq pt1 (list xcoor
                   (- (- (cadr first_ladder_XY_org) (* ldr_cnt ladder_2_ladder_dist))                      
                     (+ (/ (+ (- ladder_width plc_input_x_offset) plc_output_x_offset) 2.0))) 0.0))

                ; figure out insert x coor for any components that tie to module
                (setq comp_y_coor
                    (- (- (cadr first_ladder_XY_org) (* ldr_cnt ladder_2_ladder_dist))                
                       (- ladder_width plc_output_device_x_offset)))                   
                (setq comp_y_coor2
                    (- (- (cadr first_ladder_XY_org) (* ldr_cnt ladder_2_ladder_dist))
                       plc_input_device_x_offset))                
              )
              (T  ; Output module
                (setq pt1 (list xcoor
                   (-  (- (cadr first_ladder_XY_org) (* ldr_cnt ladder_2_ladder_dist))
                       plc_output_x_offset) 0.0))                
                ; figure out insert y coor for any components that tie to module
                (setq comp_y_coor
                    (- (- (cadr first_ladder_XY_org) (* ldr_cnt ladder_2_ladder_dist))
                       (- ladder_width plc_output_device_x_offset)))                
          ) ) )                    
          (T ; horiz rungs, vertical ladders and PLC modules
            ; First figure out "y" coordinate for start of module
            (if (> pnts_so_far 0)
              (progn ; starting a 2nd module below end of another in same column
                (setq ycoor (- (cadr first_ladder_XY_org) (* pnts_so_far rung_spacing)))
                ; Check for SPACERS in upper module and adjust staring point down one
                ; extra rung for each SPACER found.
              )
            ; else
              (progn
                (setq ycoor (- (cadr first_ladder_XY_org)
                        (* plc_insert_y_offset_rungs_down rung_spacing)))
                (setq pnts_so_far plc_insert_y_offset_rungs_down)
            ) )
            (cond
              ((= io_type "I")
                (setq pt1 (list (+ (- ladder_width plc_input_x_offset)
                   (+ (* ldr_cnt ladder_2_ladder_dist) (car first_ladder_XY_org)))
                          ycoor 0.0))
                ; figure out insert x coor for any components that tie to module
                (setq comp_x_coor
                  (+ plc_input_device_x_offset
                    (+ (* ldr_cnt ladder_2_ladder_dist) (car first_ladder_XY_org))))
              )
              ((= io_type "IO")  ; both inputs and outputs, put down center
                (setq pt1 (list (+ (/ (+ (- ladder_width plc_input_x_offset) plc_output_x_offset) 2.0)
                   (+ (* ldr_cnt ladder_2_ladder_dist) (car first_ladder_XY_org)))
                          ycoor 0.0))
                ; figure out insert x coor for any components that tie to module
                (setq comp_x_coor
                  (+ plc_input_device_x_offset
                    (+ (* ldr_cnt ladder_2_ladder_dist) (car first_ladder_XY_org))))
                (setq comp_x_coor2  ; use for outputs
                  (+ (- ladder_width plc_output_device_x_offset)
                   (+ (* ldr_cnt ladder_2_ladder_dist) (car first_ladder_XY_org))))
              )
              (T  ; Output module
                (setq pt1 (list (+ plc_output_x_offset
                   (+ (* ldr_cnt ladder_2_ladder_dist) (car first_ladder_XY_org)))
                          ycoor 0.0))
                ; figure out insert x coor for any components that tie to module
                (setq comp_x_coor
                  (+ (- ladder_width plc_output_device_x_offset)
                   (+ (* ldr_cnt ladder_2_ladder_dist) (car first_ladder_XY_org))))
          ) ) )
        )
        ; *** 29-Dec-99 PMM
        (setq start_ix (1+ pnts_so_far_this_module))
; *** 12-Feb-00 PMM
        (setq end_ix pnts_to_do)
; ** 17-Feb-00 NEHolt *************************
        (setq empty_rungs_left (figure_how_many_empty_rungs_left pt1 first_ladder_XY_org rung_spacing
           max_pnt_cnt_per_ldr ladder_rung_cnt plc_insert_y_offset_rungs_down))
        (if (> (- end_ix start_ix) empty_rungs_left)
          (progn ; Not enough room to put in full module. Will have to split it.
; ** 08-Feb-06 NEHolt test           
;            (setq end_ix (+ empty_rungs_left start_ix)))
            (setq end_ix (+ empty_rungs_left start_ix))
         ) )
        (setq addr_data (cdr (nth module mod_data)))
        (setq pnt_whatis_lst '())
        ; Build up a list of 1's and 0's representing the series of
        ; blocks that are stacked to build the module. 1=address point,
        ; 0=dumb wire connection on no connection point. This list is
        ; used only if a "BREAK" keyword is encountered in the spreadsheet
        ; data for the module. It is used to make sure that the address
        ; data in the spreadsheet stays in synch with the list of symbols
        ; that is used to build the module.
        (setq xx (cadr (car (nth module mod_data))))
; ** 13-Jun-00 NEHolt
        (setq encoded_break_lst '())
        (setq ixxx 0)
; **
        (foreach x xx
          (setq blknam (car x))
          ; Look for letter "A" somewhere in first 6 char of block name (ex: HP1DWAW)
          ; The "A" means address. If this convention is not followed
          ; for user generated parametric build symbols, then the "BREAK"
          ; feature embedded in the spreadsheet data will not be
          ; guaranteed to work correctly.
; ** 13-Jun-00 NEHolt
          ; Scan module data pulled from plc*.dat file for any "BREAK" codes
          (foreach sub1 (cadr x)
; *** 09-May-08 PMM - 1076948 - only want breaks after the point starting with in case broke already
            (if (AND (= (cadr sub1) "BREAK") (<= (1- start_ix) ixxx)) ; ** 05-Jul-08 NEHolt ; ** 08-Jul-08 Vivian
              (progn
                ; *** 09-May-08 PMM break count is of this piece not from beginning of entire module
                (setq encoded_break_lst (cons (- ixxx (1- start_ix)) encoded_break_lst))
            ) )    
;            (if (= (cadr sub1) "BREAK")
;              (setq encoded_break_lst (cons ixxx encoded_break_lst)))
; *** 09-May-08 PMM.en
          )
          (setq ixxx (1+ ixxx))
; **
          (if (not (wcmatch (substr blknam 1 6) "?P?*A*"))
            (setq pnt_whatis_lst (cons 0 pnt_whatis_lst))
          ; ELSE
            (setq pnt_whatis_lst (cons 1 pnt_whatis_lst))
          )
        )
        (setq pnt_whatis_lst (reverse pnt_whatis_lst))
; **
        ; Look for "BREAK" code in spreadsheet data. If found, force module to
        ; break at the point where the code appears and continue in the next ladder.

        (setq ixxx addr_pnts_so_far)
        (setq ii (- end_ix start_ix))
        (setq ipx 0)
        (setq hitbreak nil)
        (setq hitbreakix nil)
        (while (AND (<= ipx ii) (not hitbreak) (nth (+ ixxx ipx) addr_data))
          (setq str (nth 4 (car (nth (+ ixxx ipx) addr_data))))
          (if (AND str (wcmatch str "BREAK*"))
            (progn
              (setq hitbreakix (+ ixxx ipx))
              (setq hitbreak (+ ixxx whatis_cnt))
            )
          )
          (if (not hitbreak)
            (progn
              (while (= (nth whatis_cnt pnt_whatis_lst) 0)
                (setq whatis_cnt (1+ whatis_cnt)))
              (setq whatis_cnt (1+ whatis_cnt))
          ) )
          (setq ipx (1+ ipx))
        )

        (if hitbreak
          (progn ; a "BREAK" marker found in the address column. End the module
             ; at this point.
; ** 04-May-00 NEHolt
            (setq end_ix whatis_cnt)
; **
            ; Remove entry in parallel list marking number of "spacer" points
            ; per I/O point. This is needed to keep this list and the addr_data
            ; lists in synch.
            (setq z (nth module mod_data_parallel_skip))
            (setq i 0)
            (setq xx '())
            (foreach x z
; ** 04-May-00
              (if (/= i hitbreakix)(setq xx (cons x xx)))
              (setq i (1+ i))
            )
            (setq z (reverse xx))
            (setq xx '())
            (setq i 0)
            (foreach x mod_data_parallel_skip
              (if (/= i module)
                (setq xx (cons x xx))
              ; ELSE
                (setq xx (cons z xx)) ; add in module's new version of the spacer list
              )
              (setq i (1+ i))
            )
            (setq mod_data_parallel_skip (reverse xx))

            ; Now remove this "BREAK" line of data from the addr_data list
            (setq xx '())
            (setq i 0)
            (foreach x addr_data
; ** 04-May-00
              (if (/= i hitbreakix)(setq xx (cons x xx)))
              (setq i (1+ i))
            )
            (setq addr_data (reverse xx))
            (setq xx (nth module mod_data))
            (setq newx (cons (car xx) addr_data))
            (setq xx '())
            (setq i 0)
            (foreach x mod_data
              (if (/= i module)
                (setq xx (cons x xx))
              ; ELSE
                (setq xx (cons newx xx)) ; paste in new version
              )
              (setq i (1+ i))
            )
            (setq mod_data (reverse xx))
            (setq xx nil)
          )
; ** 13-Jun-00 NEHolt
        ; ELSE
          (progn  ; No BREAK encoded in spreadsheet, use any BREAK built
                  ; into the data in the PLC*.dat file entry for this module
            (if (AND (= GBL_wd_PLC_autobreak "1") encoded_break_lst)
              (progn
                (setq encoded_break_lst (reverse encoded_break_lst))
                (setq end_ix (+ start_ix (car encoded_break_lst)))
                (setq encoded_break_lst (cdr encoded_break_lst))
              )
            )
          )
; **
        )
        
; ***************************************
    ; also need to account for any added spacing
        (setq i (1- start_ix))
        (setq ii end_ix)
        (setq x (nth module mod_data_parallel_skip))
        ; List of SPACER flag digits (x x x x x...) where 0=none, 1=1 spacer, 2=2 spacers       
; ** 17-Feb-00 NEHolt *********************
        (setq tcnt (- end_ix start_ix))
        (while (< i (length x))
          (if (< i end_ix)
            (progn
              (if (> (+ tcnt (nth i x)) empty_rungs_left)
                (progn
                  (setq end_ix (- end_ix (nth i x))) ; reduce by number of spaces with this point
; ** 08-Feb-06 NEHolt commented out, causing module insert to be shortened too much                  
;                   (setq end_ix (1- end_ix)) ; also reduce by the point itself
; ** 08-Feb-06 NEHolt.en
                  (setq tcnt (- tcnt (nth i x)))
                )
              ; ELSE
                (setq tcnt (+ tcnt (nth i x)))
          ) ) )
; **
          (setq i (1+ i))
        )
        (command "_.ZOOM" "_E")


; ** 02-May-00 NEHolt moved up
;   (setq addr_data (cdr (nth module mod_data)))
; **

        (setq module_extra_attr_pairs nil) ; ** 10-Aug-07 NEHolt

        (if (> rack_ix 0)
; ** 10-Aug-07 NEHolt            
          (progn
            (setq x (wdio_accum_extra_attr_data (nth (1- rack_ix) (last (car addr_data))) module_extra_attr_pairs))
            (setq rack (car x))
            (setq module_extra_attr_pairs (cadr x))
          )  
; ** 10-Aug-07 NEHolt.end            
        ; ELSE
          (setq rack "") ; no rack index defined
        )
        (if (> group_ix 0)
; ** 10-Aug-07 NEHolt            
          (progn
            (setq x (wdio_accum_extra_attr_data (nth (1- group_ix) (last (car addr_data))) module_extra_attr_pairs))
            (setq group (car x))
            (setq module_extra_attr_pairs (cadr x))
          )  
; ** 10-Aug-07 NEHolt.end            
        ; ELSE
          (setq group "") ; no group index defined
        )
        (if (> remote_tp_ix 0)
; ** 10-Aug-07 NEHolt            
          (progn
            (setq x (wdio_accum_extra_attr_data (nth (1- remote_tp_ix) (last (car addr_data))) module_extra_attr_pairs))
            (setq remote_tp (car x))
            (setq module_extra_attr_pairs (cadr x))
          )  
; ** 10-Aug-07 NEHolt.end            
        ; ELSE
          (setq remote_tp "")
        )
        (if (> slot_ix 0)
; ** 10-Aug-07 NEHolt            
          (progn
            (setq x (wdio_accum_extra_attr_data (nth (1- slot_ix) (last (car addr_data))) module_extra_attr_pairs))
            (setq slot (car x))
            (setq module_extra_attr_pairs (cadr x))
          )  
; ** 10-Aug-07 NEHolt.end            
        ; ELSE
          (setq slot "")
        )
        
; ** 23-May-02 NEHolt
        (if (> plc_inst_ix 0)
; ** 10-Aug-07 NEHolt            
          (progn
            (setq x (wdio_accum_extra_attr_data (nth (1- plc_inst_ix) (last (car addr_data))) module_extra_attr_pairs))
            (setq plc_inst (car x))
            (setq module_extra_attr_pairs (cadr x))
          )  
; ** 10-Aug-07 NEHolt.end            
        ; ELSE
          (setq plc_inst "")
        )
        (if (> plc_loc_ix 0)
; ** 10-Aug-07 NEHolt            
          (progn
            (setq x (wdio_accum_extra_attr_data (nth (1- plc_loc_ix) (last (car addr_data))) module_extra_attr_pairs))
            (setq plc_loc (car x))
            (setq module_extra_attr_pairs (cadr x))
          )
; ** 10-Aug-07 NEHolt.end            
        ; ELSE
          (setq plc_loc "")
        )
; ** 07-Jun-02 NEHolt                              
        (if (> plc_mod_tag_ix 0)
; ** 10-Aug-07 NEHolt            
          (progn
            (setq x (wdio_accum_extra_attr_data (nth (1- plc_mod_tag_ix) (last (car addr_data))) module_extra_attr_pairs))
            (setq plc_mod_tag (car x))
            (setq module_extra_attr_pairs (cadr x))
          )
; ** 10-Aug-07 NEHolt.end            
        ; ELSE
          (setq plc_mod_tag "")
        )
; **        
        ; Figure out beg address of this module (or split portion of prev mod)
        (if (OR (= pnts_so_far_this_module 0) (= use_next_addr nil) (= use_next_addr ""))
          (if (> addr_ix 0)(setq use_next_addr (nth (1- addr_ix) (last (car addr_data))))) ; ** 20-Jan-04 NEHolt make sure addr_ix is defined
        )
        ; Remember overall module's very first address
        (if (= pnts_so_far_this_module 0) (setq veryfirsta use_next_addr))
        (setq x (car (nth module mod_data)))
        ; Pad parallel skip data list to make sure it is as long as the module point count
        (setq xx (reverse (nth module mod_data_parallel_skip)))
        (while (< (length xx) (length (nth 1 x)))(setq xx (cons 0 xx)))
        (setq xx (reverse xx)) ; put back in order
        (setq mdata (list (nth 0 x) (nth 1 x) xx pnts_not_used))
        (setq parallel_skip_lst nil skip_cnt nil)
        ; build the module
; ** 03-May-02 NEHolt        
        (cond
          ((= h_or_v_rungs "V")(setq x "H"))
          (T (setq x "V"))
        )
; **
        
        (setq elst (c:wd_inplc_nd pt1 (itoa plc_style) use_next_addr
          veryfirsta nil start_ix end_ix usr_rv
          x  ; module orientation , "V"=vertical, "H"=horizontal  ** 03-May-02
          mdata          
; ** 12-Mar-07 NEHolt wrong order - 913659
          (list "" rack slot group remote_tp) ))
;          (list "" rack group slot remote_tp) ))
; **          
          
; *** 21-Aug-00 PMM may not be the last inserted if \\X= used
    ; *** 26-Aug-00 PMM
        (if (AND elst (listp elst) (> (length elst) 3) (car (nth 3 elst))) ; ** 12-Jan-06 NEHolt
          (progn
            (setq ben (car (nth 3 elst)))            
          )  
        ; ELSE
          (progn
            ; Probably a single block, not a parametric build
            (setq ben (entlast))
            ; try to trim any underlying wires
            (wd_wpnt_trim_wires_at_points ben nil nil nil) ; ** 12-Jan-06 NEHolt
          )            
        )
; ** 30-Oct-03 NEHolt        
        (setq exploded_insert_lst '())
        (setq plc_code (car (car (cadr (nth module mod_data))))) ; retrieve original "\K=" value pulled from ".dat" file
        (if (AND ben plc_code (/= plc_code "") (= (substr plc_code 1 1) "*"))
          (progn ; Explode the PLC "module" that was just inserted and blocked. This is flagged by an "*" prefix 
                 ; on the PLC module part number code in the spreadsheet
            ; Save last ent in database before explode
            (setq #entlast (entlast))
            (command "_.EXPLODE" ben) ; Explode the "module" that was inserted moments ago above
            (setq ben nil)                  
            (if (not (eq #entlast (entlast)))
              (progn ; something went in
                (setq en #entlast)
                ; Try to find a full-unit PLC module that is part of the exploded circuit
                (while (AND en (setq en (entnext en)))
                  (setq ed (entget en))
                  (if (= (cdr (assoc 0 ed)) "INSERT")
                    (progn ; hit an insert                    
                      (setq x (c:wd_is_it_schem_or_pnl en))
                      ; Return code indicating what the target block insert is per the following:
                      ; 1 = PLCIO schematic
                      (if (= x 1) (setq ben en)) ; hit a PLCIO module that was part of the exploded "circuit"
                      (if (not ben)(setq ben en)) ; if haven't hit PLCIO insert yet, then prepare to return this INSERT
                      (if (member x (list 1 4))(setq exploded_insert_lst (cons en exploded_insert_lst))) ; candidate for retag
                      
            ) ) ) ) )          
          )
        )
        
        ; Trigger RETAG of parent PLC and parent schem components that were part of the exploded circuit
        (if exploded_insert_lst (c:wd_retag_update_noprompts 97 exploded_insert_lst)) ; retag PLC and parent schematic symbols
; **            
        
; ** 23-May-02 NEHolt        
;        (if (AND (> plc_tag_ix 0) plc_tag) (c:wd_modattrval ben "TAG" plc_tag 1))
        (if (AND (> plc_loc_ix 0) plc_loc) (c:wd_modattrval ben "LOC" plc_loc 1))
        (if (AND (> plc_inst_ix 0) plc_inst) (c:wd_modattrval ben "INST" plc_inst 1))
;        (if (AND (> remote_tp_ix 0) remote_tp) (c:wd_modattrval ben "<put attribute name here>" remote_tp 1)) ; ** 27-Sep-08 NEHolt
; ** 07-Jun-02 NEHolt
        ; Overwrite default PLC tag-ID with value pulled from spreadsheet (1st line of module's data)
        (if (AND (> plc_mod_tag_ix 0) plc_mod_tag)(c:wd_modattrval ben "TAG,TAG_#,TAG1,TAG2" plc_mod_tag 1)) ; ** 26-Oct-03 NEHolt added "TAG1,TAG2"

; ** 10-Aug-07 NEHolt
        ; If any piggy-backed extra attributes were defined on the columns specific to the overall
        ; module (i.e. not the in-line devices), then write these out to the PLC module now.               
        (if module_extra_attr_pairs (wdio_write_out_accum_extra_attr_data ben module_extra_attr_pairs))
; ** 10-Aug-07 NEHolt.end        
       
        
;        (setq ben (entlast)) ; ent name of PLC module insert
; ***
        ; Look for and save "TAG" attrib value, if present (at_en, nam, val)
        (if (= pnts_so_far_this_module 0)
          (progn
            (setq x (wdio_1_get_attr_val_nam_en ben "TAG,TAG1")) ; ** 26-Oct-03 NEHolt added ",TAG1"
; ** 14-Jun-00 NEHolt
            (if (car x)
              (progn
; **
                (setq saved_tag_attr x) ; save at_en, nam, and val
                ; Get size of original attrib
                (setq xx (entget (car x)))
                (setq x (cdr (assoc 40 xx)))
                ; Preset TEXTSIZE so that a split module's copy of TAG attrib
                ; will go in at same text size as the original module's TAG attrib
                (if x (setvar "TEXTSIZE" x))
          ) ) )
        ; ELSE
          (progn
            (if (AND (car saved_tag_attr)
                     (setq x (wdio_1_get_attr_val_nam_en ben "TAG_*,TAG2")) ; ** 26-Oct-03 NEHolt added ",TAG2"
; ** 14-Jun-00 NEHolt
                     (car x))
; **
              (progn ; copy 1st part's TAG value to this attrib
                (c:wd_modattrval ben (nth 1 x) (nth 2 saved_tag_attr) 1) ; *** 26-Aug-00 PMM ben was entlast
            ) )
        ) )
; **
        
        (command "_.ZOOM" "_E")
        (princ) ; needed, why? I don't know (N8)
        (setq use_next_addr (cadr elst)) ; strip off next address (if module break)
        (if (not use_next_addr) (setq use_next_addr ""))
        (setq pnts_not_used (nth 2 elst))
        (setq elst (car elst)) ; address attribute info for annotation below
; *** 29-Dec-99 PMM determine how many pnts used to build this module
        (setq added_rungs 0)
; ** 17-Feb-00 NEHolt
        (setq ii pnts_so_far_this_module) ; point into list
;    (setq ii 0)
; **
        (setq x (nth 2 mdata))
        (repeat (- end_ix start_ix)
          (setq i (nth ii x)) ; possible additional space after an I/O point
          (if i (setq added_rungs (+ added_rungs i)))
          (setq ii (1+ ii))
        )
; *** 12-Feb-00 PMM
;    (if (> (+ pnts_to_do added_rungs add_in_mod_skip pnts_so_far) max_pnt_cnt_per_ldr) ; had to break module
;        (setq pnts_so_far_this_module (1+ (- end_ix start_ix)))
    ; else fit
;      (setq pnts_so_far_this_module pnts_to_do)
;    )
        (setq pnts_so_far_this_module (+ pnts_so_far_this_module
          (1+ (- end_ix start_ix))))
; *** 29-Dec-99 PMM moved this down in case building more modules in this ladder
;    (ladder_cleanup ldr_cnt) ; remove unused rungs from ladder
        (if (not elst)
          (progn ; This PLC module may be a single block. Do manual scan for
             ; TAG* attributes, starting at "TAG00"
            (command "_.ZOOM" "_E")
            (setq ix 0)
            (setq ixx 0)
            (while (< ixx 33) ; give up after 33 misses in a row  ** 25-Oct-03 NEHolt
              (if (< ix 10)
                (setq str (strcat "0" (itoa ix)))
                (setq str (itoa ix))
              )
              (if (setq x (c:wd_getattrval ben (strcat "TAGA" str)))
                (progn ;hit one
                  ; Save suffix code and xy coord of wire connection attrib
                  (setq x (wd_get_attr_val_nam_en ben (strcat "X?TERM" str "*")))
                  (if (car x) ; found
                    (setq elst (cons (list str (cdr (assoc 10 (entget (car x))))) elst))
                  ; ELSE
; ** 30-Dec-99 NEHolt
                    (progn ; error?
                      (princ (strcat "\n " (c:wd_msg "IO020" (list str str) "X?TERM%1 wire connection attribute not found for address attribute TAGA%2"))) ; ** 11-May-03 NEHolt 
; **
                      (setq elst (cons (list str (list nil)) elst))
                    )
                  )
                  (setq ixx 0) ; reset counter
                )
              ; ELSE
                (setq ixx (1+ ixx)) ; increment "miss" counter
              )

              (setq ix (1+ ix))
            )
            (setq elst (reverse elst))
            (setq ix 0)
            (setq ixx 0)
        ) )

; ** 29-Oct-03 NEHolt
        ; Process each wire connection point associated with an address point. Make sure that this one
        ; is the "closest" one to the address point and will become the "baseline" xy for trying to
        ; insert the in-line devices for this address point.
        (setq xelst elst)
        (setq elst nil)
        (foreach x xelst
          (setq str (car x))
          (setq axy (cadr x))
          (setq x (wdio_find_closest_wirecon_2_this_taga_attr ben str))
          (if x
            (setq elst (cons (list str (cdr (assoc 10 (entget x)))) elst))
          ; ELSE
            (setq elst (cons (list str axy) elst))
          )
        )
        (setq elst (reverse elst))
; **
        (setq addr_pnt_cnt (length elst)) ; count of how many addr points inserted
        ; Annotate I/O points

; ** 07-Feb-01 NEHolt
        (if ben ; ** 12-Jan-06 NEHolt
          (setq x (wd_wdio_get_descattrs ben)))
        (setq plc_desc_nam_lst (car x)) ; list of DESC* attr names
        (setq plc_desc_en_lst (cadr x)) ; parallel list of ent names
        (cond
          ((= h_or_v_rungs "V")
            (setq desc_coor
              (- (- (cadr first_ladder_XY_org) (* ldr_cnt ladder_2_ladder_dist) ) ladder_width))            
          )
          (T    
            (setq desc_coor
              (+ ladder_width (+ (* ldr_cnt ladder_2_ladder_dist) (car first_ladder_XY_org))))
        ) )      
; **

; ** 13-Nov-06 Mei
        (setq unity_varname_ix 49)
        (setq unity_vartype_ix 50)
        (if (AND fieldnames (= (nth (1- unity_varname_ix) fieldnames) "VARNAME")) ; ** 914341 reuse original "fldnams" variable name
          (progn
            (ace_mark_unity_pro_dwg ben)
	) )
; **	
        (setq ix addr_pnts_so_far)
        (setq cnt 0)
        (while (< cnt addr_pnt_cnt)
          (setq datalst (reverse (nth ix addr_data))) ; get correct line of data from spreadsheet
          (setq pdata (nth cnt elst)) ; get suffix used on this point's attributes
          (setq suffix (car pdata)) ; 2-char suffix code (ex: "01")
          (setq ycoor (cadr (cadr pdata)))
          (setq xcoor (car (cadr pdata))) ; ** 04-May-02
          (if (AND datalst suffix)
            (progn
              (setq spacercnt 0)
              (foreach data datalst
                (if (> spacercnt 0)
                  (progn
                    (cond
                      ((= h_or_v_rungs "V")
                        (setq xcoor (+ xcoor rung_spacing))
                      )
                      (T
                        (setq ycoor (- ycoor rung_spacing))
                  ) ) )      
                ; ELSE
                  (progn ; first or only data line for this addr point

; ** 07-Feb-01
                    (cond                      
                      ((AND (= h_or_v_rungs "H") (= io_type "O"))
                         ; Move output DESC* attribs over to right side of ladder
                         ; and change justification to "Left"
                        (foreach ch (list "A" "B" "C" "D" "E")
                          (if (setq x (member (strcat "DESC" ch suffix) plc_desc_nam_lst))
                            (progn
                              (setq at_en (nth (- (length plc_desc_en_lst) (length x)) plc_desc_en_lst))                                                  
                              (wd_wdio_move_attrib at_en desc_coor nil)
                      ) ) ) )
; ** 09-Feb-06 NEHolt                      
                      ((AND (= h_or_v_rungs "V") (= io_type "O"))
                         ; Move output DESC* attribs bottom side of ladder
                         ; and change justification to "Left"
                        (foreach ch (list "A" "B" "C" "D" "E")
                          (if (setq x (member (strcat "DESC" ch suffix) plc_desc_nam_lst))
                            (progn
                              (setq at_en (nth (- (length plc_desc_en_lst) (length x)) plc_desc_en_lst))                                                  
                              (wd_wdio_move_attrib at_en nil desc_coor)
                      ) ) ) )
; **                       
                    )  


                    (if (AND (> desc1_ix 0) (nth (1- desc1_ix) data)
                        (/= (nth (1- desc1_ix) data) ""))
                      (c:wd_modattrval ben (strcat "DESCA" suffix)
                        (nth (1- desc1_ix) data) 1))
                    (if (AND (> desc2_ix 0) (nth (1- desc2_ix) data)
                        (/= (nth (1- desc2_ix) data) ""))
                      (c:wd_modattrval ben (strcat "DESCB" suffix)
                        (nth (1- desc2_ix) data) 1))
                    (if (AND (> desc3_ix 0) (nth (1- desc3_ix) data)
                        (/= (nth (1- desc3_ix) data) ""))
                      (c:wd_modattrval ben (strcat "DESCC" suffix)
                        (nth (1- desc3_ix) data) 1))
                    (if (AND (> desc4_ix 0) (nth (1- desc4_ix) data)
                        (/= (nth (1- desc4_ix) data) ""))
                      (c:wd_modattrval ben (strcat "DESCD" suffix)
                        (nth (1- desc4_ix) data) 1))
                    (if (AND (> desc5_ix 0) (nth (1- desc5_ix) data)
                        (/= (nth (1- desc5_ix) data) ""))
                      (c:wd_modattrval ben (strcat "DESCE" suffix)
                        (nth (1- desc5_ix) data) 1))
                    (if (AND (> addr_ix 0) (nth (1- addr_ix) data)
                        (/= (nth (1- addr_ix) data) ""))
                      (progn  
                        (c:wd_modattrval ben (strcat "TAGA" suffix)
                          (nth (1- addr_ix) data) 1)
                          
; ** 21-Aug-06 Mei: Add xrecord to the attribute for UnityPro PLC
                        (if (AND (>= (length data) (1- unity_varname_ix)) (nth (1- unity_varname_ix) data)) 
                          (if (AND fieldnames (= (nth (1- unity_varname_ix) fieldnames) "VARNAME")(/= (nth (1- unity_varname_ix) data) "")) ; ** 12-Mar-07 NEHolt use "fldnams"
                            (ace_insert_plc_xrec ben (strcat "TAGA" suffix) (nth (1- unity_varname_ix) data) 
                              (nth (1- unity_vartype_ix) data) (nth (1- addr_ix) data)(nth (1- comp_blk_ix2) data))
                    ) ) ) )
; **	
                        
                  )
                )
                (setq spacercnt (1+ spacercnt))
                
                                
; ** 27-May-99 NEHolt
                ; Check for in-line series components to be inserted
                ; into wire segment tied to this I/O point. Determine count.
                (setq ccnt 0)
                (setq xx 1)
                (repeat 9 ; ** 17-Oct-02 ScottH changed 6 - 9
                  (if (AND (> (setq ixx (eval (read (strcat "comp_blk_ix" (itoa xx))))) 0)
                     (nth (1- ixx) data) (/= (nth (1- ixx) data) ""))
                    (progn
                      (setq ccnt (1+ ccnt))
                  ) )
                  (setq xx (1+ xx))
                )
; **
; ** 30-Dec-99 NEHolt
                (if (OR (AND (= h_or_v_rungs "H") ycoor (> ccnt 0))
                        (AND (= h_or_v_rungs "V") xcoor (> ccnt 0)))
; **
                  (progn
;              (setq pt2 (list comp_x_coor (cadr (cadr pdata)) 0.0))
; ** 03-Mar-02 NEHolt
                    (cond
                      ((= h_or_v_rungs "V")
                        (setq pt2 (list xcoor comp_y_coor 0.0))
; ** 29-Sep-03 NEHolt                        
                        ; Check if this point lands on an existing line
                        (if (not (wd_get_nearby_line pt2))
                          (progn ; missing line. Check 1/2 rung spacing to right and left to
                                 ; see of there is an offset line we can capture
                            (setq ssf (ssget "_F" 
                              (list (list (- (car pt2) (* rung_spacing 0.51)) (cadr pt2) 0.0)
                                    (list (+ (car pt2) (* rung_spacing 0.51)) (cadr pt2) 0.0)) '((0 . "LINE"))))
                            (if (AND (/= ssf nil) (= (sslength ssf) 1))
                              (progn ; okay, we hit a LINE. Use the X coord of this line.
                                (setq en2 (ssname ssf 0))
                                (setq pt2 (list (car (cdr (assoc 10 (entget en2)))) (cadr pt2) 0.0))                               
                            ) )
                            (setq ssf nil)
                        ) )    
; **                            
                      )
                      (T
                        (setq pt2 (list comp_x_coor ycoor 0.0))
; ** 29-Sep-03 NEHolt                        
                        ; Check if this point lands on an existing line
                        (if (not (wd_get_nearby_line pt2))
                          (progn ; missing line. Check up and down 1/2 rung spacing to
                                 ; see of there is an offset line we can capture
                            (setq ssf (ssget "_F" 
                              (list (list (car pt2)(+ (cadr pt2) (* rung_spacing 0.51)) 0.0) 
                                    (list (car pt2) (- (cadr pt2) (* rung_spacing 0.51)) 0.0)) '((0 . "LINE"))))
                            (if (AND (/= ssf nil) (= (sslength ssf) 1))
                              (progn ; okay, we hit a LINE. Use the Y coord of this line.
                                (setq en2 (ssname ssf 0))
                                (setq pt2 (list (car pt2) (cadr (cdr (assoc 10 (entget en2)))) 0.0))                                
                            ) )
                            (setq ssf nil)
                        ) )    
; **                            
                    ) )    
; ** 26-May-99 NEHolt
                    (setq io_typ io_type) ; used for multi-comp insert
                    (if (= io_type "IO")
                      (progn ; module has both inputs and outputs. 
                        (cond
                          ((= h_or_v_rungs "V")
                             ;Check if "pt2" is on a wire segment. If not, try using
                             ; comp_x_coor2 (which is on the output side of
                             ; the module)
                            (if (setq en (wd_get_nearby_line pt2))
                              (progn ; yes, underlying wire segment on INPUT side
                                ; Find midpoint of wire. Make sure insertion point
                                ; is not to the right of midpoint of wire
                                (setq io_typ "O")
                                (setq ed (entget en))
                                (setq x (+ (cadr (cdr (assoc 10 ed)))
                                    (/ (- (cadr (cdr (assoc 11 ed)))
                                      (cadr (cdr (assoc 10 ed)))) 2.0)))
                                ; If original insertion point is above if mid
                                ; point of left-hand wire connection, insert any
                                ; defined component at mid-point of the wire segment.
                                (if (> (cadr pt2) x) (setq pt2 (list (car pt2) x 0.0)))
                                
; **
                              )
                            ; ELSE
                              (progn ; check input side (above the module)
                                (setq pt2 (list xcoor comp_y_coor2 0.0))
                                
                                (if (setq en (wd_get_nearby_line pt2))
                                  (progn ; yes, underlying wire segment
                                    (setq io_typ "I")
                                  )
                                ; ELSE
                                  (progn ; other side didn't work either, go back to
                                     ; original on input side
                                    (setq pt2 (list xcoor comp_y_coor 0.0))
                                ) )    
                            ) )
                          )
                          (T                        
                             ;Check if "pt2" is on a wire segment. If not, try using
                             ; comp_x_coor2 (which is on the output side of
                             ; the module)
                            (if (setq en (wd_get_nearby_line pt2))
                              (progn ; yes, underlying wire segment on INPUT side
                                ; Find midpoint of wire. Make sure insertion point
                                ; is not to the right of midpoint of wire
                                (setq io_typ "I")
                                (setq ed (entget en))
                                (setq x (+ (car (cdr (assoc 10 ed)))
                                    (/ (- (car (cdr (assoc 11 ed)))
                                      (car (cdr (assoc 10 ed)))) 2.0)))
                                ; If original insertion point is to right if mid
                                ; point of left-hand wire connection, insert any
                                ; defined component at mid-point of the wire segment.
                                (if (> (car pt2) x) (setq pt2 (list x (cadr pt2) 0.0)))
; **
                              )
                            ; ELSE
                              (progn ; check output side (right side of module)
                                (setq pt2 (list comp_x_coor2 ycoor 0.0))
                                (if (setq en (wd_get_nearby_line pt2))
                                  (progn ; yes, underlying wire segment
                                    (setq io_typ "O")
                                  )
                                ; ELSE
                                  (progn ; other side didn't work either, go back to
                                     ; original on input side
                                    (setq pt2 (list comp_x_coor ycoor 0.0))
                                ) )    
                        ) ) ) )
                    ) )
; **

                    ; ** insert the component or components in series with I/O point
                    (setq ins_cnt 0)
                    (setq i_xx 0)
                    (setq pt2start pt2)
                    (repeat 9 ; ** 17-Oct_02 ScottH changed 6 - 9
                      (setq i_xx (1+ i_xx)) ; ** 06-Jan-00 changed all "xx" refs to "i_xx"
                      (if (AND (> (setq ixx (eval (read
                           (strcat "comp_blk_ix" (itoa i_xx))))) 0)
                           (nth (1- ixx) data) (/= (nth (1- ixx) data) ""))
                        (progn
                          (setq comp_blk_ix ixx)
                          (cond
                            ((= h_or_v_rungs "V")
                            
                              (if (= io_typ "I")
                                (setq pt2 (list (car pt2) (- (cadr pt2start) (* (1- i_xx) plc_series_device_spacing)) 0.0))
                              ; ELSE
                                (setq pt2 (list (car pt2) (+ (cadr pt2start) (* (1- i_xx) plc_series_device_spacing)) 0.0))
                              )
                            )
                            (T
                              (if (= io_typ "I")
                                (setq pt2 (list (+ (car pt2start) (* (1- i_xx) plc_series_device_spacing)) (cadr pt2) 0.0))
                              ; ELSE
                                (setq pt2 (list (- (car pt2start) (* (1- i_xx) plc_series_device_spacing)) (cadr pt2) 0.0))
                          ) ) )
; ** 13-Mar-00 NEHolt
                          (setq sym2 (nth (1- comp_blk_ix) data))
                          (cond
                            ((= (substr sym2 1 1) "*")  ; Symbol name includes leading "*".
                              ; Insert as a "circuit"
; ** 09-Jan-02 NEHolt                              
                              ; Prepare to track if some WD symbols get inserted
                              (setq #entlast (entlast))
                              (c:wd_ins_circ2 (substr sym2 2) pt2 scale nil) ; insert the circuit
                              
                              (if (not (eq #entlast (entlast)))
                                (progn ; something went in
                                  (setq en #entlast)
                                  (while (AND en (setq en (entnext en)))
                                    (setq ed (entget en))
                                    (if (= (cdr (assoc 0 ed)) "INSERT")
                                      (progn ; hit an insert
                                        (setq x (c:wd_is_it_schem_or_pnl en))
                                        ; Return code indicating what the target block insert is per the following:
                                        ; 1 = PLCIO schematic
                                        ; 2 = wire number block
                                        ; 3 = master line reference, i.e. ladder
                                        ; 4 = schematic, parent
                                        ; 5 = schematic, child
                                        ; 6 = source or dest arrow
                                        ; 7 = schematic terminal
                                        (if (OR (= x 4) (= x 5) (= x 7))
                                          (progn ; Hit first valid WD symbol. Try to annotate it.
                                            (if (> (wdio_annotate_inserted_symbol en) 0)
                                              (progn ; some annotation successful, flag to not process
                                                     ; any other members of the inserted circuit.
                                                (setq en nil) ; flag to exit loop
                                              )
                                            )                                                                                                                       
                              ) ) ) ) ) ) )                             
                              (setq en nil)                              
                            )
; ** 14-Jun-02 NEHolt                            
                            ((= (substr sym2 1 1) "|") ; Symbol name is a flag for "SHORT"
                              ; ******* J U M P E R   B E T W E E N   R U N G S   R E Q ' D   ***********
                              ; Look for next rung down (or over)
                              (cond
                                ((/= h_or_v_rungs "V") ; horiz rungs, look down
                                  (setq pt3 (list (car pt2) 
                                                  (- (cadr pt2) rung_spacing) 0.0))                          
                                )
                                (T ; vertical rungs, look right
                                  (setq pt3 (list (+ (car pt2) rung_spacing)
                                                  (cadr pt2) 0.0))
                              ) ) 
                              ; Check if there is a wire at this calculated point
                              (if (setq line_en (wd_get_nearby_line pt3))
                                (progn ; Yes, go ahead and insert the vertical shorting jumper
                                  (setq upper_line_en (wd_get_nearby_line pt2)) ; save upper wire ent name
                                  (c:wd_wire_quik pt2 pt3 nil)
                                  
                                  (cond
                                    ((= (strlen sym2) 1)) ; just "|", don't delete any wires
                                    (T
                                      (setq trap 0.125)
                                      (if (AND upper_line_en (= (substr (ace_strcase sym2) 2 1) "X"))
                                        (progn ; trim the upper wire toward left or down
                                          (cond
                                            ((/= h_or_v_rungs "V") ; horiz rungs, trim left
                                              (c:wd_trimwire upper_line_en (list (- (car pt2) trap)
                                                    (cadr pt2) 0.0))
                                            )
                                            (T ; vertical rungs, trim up
                                              (c:wd_trimwire upper_line_en (list (car pt2)
                                                     (+ (cadr pt2) trap) 0.0))
                                      ) ) ) )       
                                      (if (AND upper_line_en (= (substr (ace_strcase sym2) 3 1) "X"))
                                        (progn ; trim the upper wire toward right or up
                                          (cond
                                            ((/= h_or_v_rungs "V") ; horiz rungs, trim right
                                              (c:wd_trimwire upper_line_en (list (+ (car pt2) trap)
                                                    (cadr pt2) 0.0))
                                            )
                                            (T ; vertical rungs, trim down
                                              (c:wd_trimwire upper_line_en (list (car pt2)
                                                     (- (cadr pt2) trap) 0.0))
                                      ) ) ) )                                             
                                      (if (AND line_en (= (substr (ace_strcase sym2) 4 1) "X"))
                                        (progn ; trim the bottom wire toward left or down
                                          (cond
                                            ((/= h_or_v_rungs "V") ; horiz rungs, trim left
                                              (c:wd_trimwire line_en (list (- (car pt3) trap)
                                                    (cadr pt3) 0.0))
                                            )
                                            (T ; vertical rungs, trim up
                                              (c:wd_trimwire line_en (list (car pt3)
                                                     (+ (cadr pt3) trap) 0.0))
                                      ) ) ) )       
                                      (if (AND line_en (= (substr (ace_strcase sym2) 5 1) "X"))
                                        (progn ; trim the bottom wire toward right or up
                                          (cond
                                            ((/= h_or_v_rungs "V") ; horiz rungs, trim right
                                              (c:wd_trimwire line_en (list (+ (car pt3) trap)
                                                    (cadr pt3) 0.0))
                                            )
                                            (T ; vertical rungs, trim down
                                              (c:wd_trimwire line_en (list (car pt3)
                                                     (- (cadr pt3) trap) 0.0))
                                      ) ) ) )       
                              ) ) ) ) 
                              (setq en nil) ; don't flag that a component was inserted                            
                            )
; **                          
                            (T
; ** 07-Dec-06 NEHolt
                              ; Remember if existing wire found under proposed component insertion point                            
                              (setq save_ed nil)                            
                              (if (setq line_en (wd_get_nearby_line pt2))
                                (setq save_ed (entget line_en))
                              )                            
; ** 07-Dec-06 NEHolt.end
                              ; Insert in-line component at XY point "pt2"
                              (setq en (c:wd_insym2 (nth (1- comp_blk_ix) data)
                                 pt2 scale 4)) ; ** 05-Feb-07 NEHolt set bit 4 to suppress auto-gen of tag. It needs to come from spreadsheet
; ** 07-Dec-06 NEHolt
                              (if (AND en save_ed)
                                (progn ; component inserted into existing wire. Make sure that the wire
                                       ; successfully reconnected on other side and maintained connection
                                       ; to the PLC I/O module wire connection point.
                                  ; Find midpoint of previous wire connection to I/O point     
                                  (setq pt3 (list (+ (car (cdr (assoc 10 save_ed))) (* 0.5 (- (car (cdr (assoc 11 save_ed))) (car (cdr (assoc 10 save_ed))))))
                                                  (+ (cadr (cdr (assoc 10 save_ed))) (* 0.5 (- (cadr (cdr (assoc 11 save_ed))) (cadr (cdr (assoc 10 save_ed))))))
                                                   0.0))                                
                                  (if (not (wd_get_nearby_line pt3))
                                    (progn ; appears as if wire continuation was lost. Could be result of inserted
                                           ; device not having outgoing wire connection in line with symbol origin
                                           ; (ex: single pole - double throw toggle switch).
                                      (setq pntlst (c:wd_get_sym_pntlst en 1 nil))  
                                      ; Returns list of lists, one list for each wire connection point carried on target entity 
                                      (if (> (length pntlst) 1) ; at least two wire connections on this device
                                        (progn ; First, look for wire connection point that carries the original line wire "line_en" above
                                          (setq hit nil)
                                          (foreach x pntlst
                                            (if (member line_en (nth 3 x))(setq hit (nth 4 x))) ; save wire connection direction
                                          )
                                          (if hit
                                            (progn
                                              (cond ; figure out wire connection direction to "exit" the component
                                                ((= hit 1)(setq xx 4))
                                                ((= hit 2)(setq xx 8))
                                                ((= hit 4)(setq xx 1))
                                                ((= hit 8)(setq xx 2))
                                              )
                                              ; Find first unused wire connection in the "exit" direction
                                              (setq pt3x nil)
                                              (foreach x pntlst
                                                (if (AND (= (nth 4 x) xx) ; desired direction
                                                          (= (nth 3 x) nil) ; no wire tied to it yet
                                                          (not pt3x)) ; no hit yet
                                                  (setq pt3x (cadr x))
                                              ) )
                                              (if pt3x
                                                (progn ; okay, we have a good exit wire connection point.
                                                  ; Figure out the far PLC I/O end of the original wire
                                                  (setq pt4 (cdr (assoc 10 save_ed)))
                                                  (if (< (distance pt3x pt4) 
                                                         (distance pt4 (cdr (assoc 11 save_ed))))
                                                    (setq pt4 (cdr (assoc 11 save_ed)))
                                                  )
                                                  ; Now route a new wire with appropriate "jog" from pt3 to pt4
                                                  (cond
                                                    ((= xx 1) ; going from left to PLCIO on the right
                                                      (setq pt3a (list (+ (car pt3x) (* GBL_wd_trp 8.0)) (cadr pt3x) 0.0))
                                                      (setq pt3b (list (car pt3a) (cadr pt4) 0.0))
                                                    )
                                                    ((= xx 4) ; going from right to PLCIO on the left
                                                      (setq pt3a (list (- (car pt3x) (* GBL_wd_trp 8.0)) (cadr pt3x) 0.0))
                                                      (setq pt3b (list (car pt3a) (cadr pt4) 0.0))
                                                    )
                                                    ((= xx 2) ; going from below to PLCIO above
                                                      (setq pt3a (list (car pt3x) (+ (cadr pt3x) (* GBL_wd_trp 8.0)) 0.0))
                                                      (setq pt3b (list (car pt4) (cadr pt3a) 0.0))
                                                    )
                                                    ((= xx 8) ; going from above to PLCIO below
                                                      (setq pt3a (list (car pt3x) (- (cadr pt3x) (* GBL_wd_trp 8.0)) 0.0))
                                                      (setq pt3b (list (car pt4) (cadr pt3a) 0.0))
                                                    )
                                                  )
                                                  ; Insert short wire segment leaving the component's wire connection
                                                  (c:wd_wire pt3x pt3a (cdr (assoc 8 save_ed))) ; wire on original wire's layer
                                                  (c:wd_wire pt3a pt3b (cdr (assoc 8 save_ed)))
                                                  (c:wd_wire pt3b pt4 (cdr (assoc 8 save_ed)))
                                                )
                                              )
                                          ) )
                                      ) )

                                  ) )
                              ) )                                 
; ** 07-Dec-06 NEHolt.end                              
                          ) )
                          (if en
                            (progn ; component successfully inserted. Annotate it.
                              (setq ins_cnt (1+ ins_cnt))
; ** 09-Jan-02 NEHolt                              
                              (wdio_annotate_inserted_symbol en)
                    ) ) ) ) )
                    ;
                    ; Component inserted and broke wire. Okay to check for
                    ; wire number assignment from spreadsheet
                    (if (AND (> ins_cnt 0) (> wire_tag_ix 0) (nth (1- wire_tag_ix) data) (> addr_ix 0)   ; ** 20-Jan-04 NEHolt make sure addr_ix is defined
                             (not (wcmatch (nth (1- addr_ix) data) "SPACE*"))
; ** 14-Aug-03 NEHolt
                             ; Skip blank WIRENO entries in spreadsheet                             
                             (setq wireno (wd_1_rmv_leading_blnks (nth (1- wire_tag_ix) data)))
                             (/= wireno ""))        
; **                                                  
                      (progn
                        ; Determine midpoint between module and in-line comp
                        (cond
                          ((= h_or_v_rungs "V")
                            (setq pt3 (list (car pt2) 
                                      (+ (* (- (cadr (cadr pdata)) (cadr pt2)) 0.5)
                                      (cadr pt2))  0.0))                          
                          )
                          (T
                            (setq pt3 (list (+ (* (- (car (cadr pdata)) (car pt2)) 0.5)
                                (car pt2)) (cadr pt2) 0.0))
                        ) )        
                        ; Get ent name of LINE wire
                        (setq x (wd_get_nearby_line pt3))
                        (if x (c:wd_putwnf x wireno)) ; put wire num on it
                    ) )
                  )
                ;ELSE
                  (progn ; No component to connect to this I/O point
; ** 05-May-00 NEHolt
                    (chk2_del_wire)
            ) ) ) )
          ; ELSE
            (chk2_del_wire)
          )
; **
          (setq cnt (1+ cnt))
          (setq ix (1+ ix))
        )
        (entupd ben)
; ** 02-May-00 NEHolt
      )
    )
; **
    (if (>= pnts_so_far_this_module pnts_to_do)
      (progn ; previous module is finished
; ** 03-Aug-00 NEHolt
        (if (not added_rungs)(setq added_rungs 0))
; **
        (setq pnts_so_far (+ pnts_so_far added_rungs pnts_left_to_do rung_skip_btwn_module))
        (setq module (1+ module)) ; go to next module in list

; ** 04-May-00
        (setq whatis_cnt 0)
; **

        (setq pnts_not_used 0)
        (if (not (nth module mod_data))
          (progn ; no more modules to do
            (ladder_cleanup ldr_cnt) ; remove unused rungs from ladder
            (setq xitflg 1)
            (princ (strcat "\n\n" (c:wd_msg "IO021" nil ">>Note: SCOOT can be used to reposition output descriptions and change justification") " ")) ; ** 11-May-03 NEHolt
          )
        ; ELSE start new module
        ; *** 29-Dec-99 PMM added options to build in same ladder
          (progn ; see if needs to move to a new ladder
            (if (OR (>= (+ pnts_so_far 2) max_pnt_cnt_per_ldr) ; 2 is arbitrary??
                    (= always_start_at_top "0") ; start at new ladder
; ** 29-Sep-03 NEHolt                    
                    (/= hit_skip_flag nil) ; hit a "SKIP" or "NEW_DWG" flag
; **                    
                    (AND (= always_start_at_top "1") ; has to completely fit
                         (= (will_next_module_fit (nth module mod_data)
                            (nth module mod_data_parallel_skip) pnts_so_far
; ** 19-Feb-01 NEHolt "rung_skip_btwn_module" already added in above
;                            rung_skip_btwn_module max_pnt_cnt_per_ldr) nil)))
                             0 max_pnt_cnt_per_ldr) nil)))
; **
              (progn
                (ladder_cleanup ldr_cnt) ; remove unused rungs from ladder
                (setq pnts_to_do (length (cadr (car (nth module mod_data))) ))
                (setq pnts_left_to_do pnts_to_do)
                (setq ldr_cnt (1+ ldr_cnt))
                ; ** 29-Sep-03 NEHolt                
                (if (= hit_skip_flag 2) ; hit a SKIP flag but were ready to do 2+ module in a ladder
                  (progn ; need to skip ahead one more ladder
                    (ladder_cleanup ldr_cnt)
                    (setq ldr_cnt (1+ ldr_cnt)) 
                ) )    
                ; **
                (setq pnts_so_far 0)
                (setq addr_pnts_so_far 0)
                (setq pnts_so_far_this_module 0)
                (setq add_in_mod_skip 0)
; ** 18-Jul-07 NEHolt
                (if (= hit_skip_flag 3)
                  (while (< ldr_cnt ladder_cnt) ; skip remaining columns on active dwg
                    (ladder_cleanup ldr_cnt)
                    (setq ldr_cnt (1+ ldr_cnt))            
                ) )    
; ** 18-Jul-07 NEHolt.en                
              )
            ; else  will fit in same ladder
              (progn
                (setq pnts_to_do (length (cadr (car (nth module mod_data))) ))
                (setq pnts_left_to_do pnts_to_do)
                (setq addr_pnts_so_far 0)
                (setq pnts_so_far_this_module 0)
                (setq add_in_mod_skip rung_skip_btwn_module)
            ) )
            ; try to determine module type (INPUT or OUTPUT)
            (setq io_type (determine_in_or_out module))
      ) ) )
    ; ELSE
      (progn ; previous module NOT finished. Continue in next ladder.
        (ladder_cleanup ldr_cnt) ; remove unused rungs from ladder
        (setq addr_pnts_so_far (+ addr_pnts_so_far addr_pnt_cnt))
        (setq ldr_cnt (1+ ldr_cnt))
        (setq pnts_so_far 0) ; pnts used on the ladder
        ; adjust for pnts left to do
        (setq pnts_left_to_do (- pnts_to_do pnts_so_far_this_module))
        (setq add_in_mod_skip 0)
    ) )
  )


  (command "_.UNDO" "_E")
  (if GBL_wd_#blipmode (setvar "BLIPMODE" GBL_wd_#blipmode))
  (if GBL_wd_wdio_#attreq (setvar "ATTREQ" GBL_wd_wdio_#attreq))
  (if GBL_wd_#cmdecho (setvar "CMDECHO" GBL_wd_#cmdecho))
  (if GBL_wd_#osmode (setvar "OSMODE" GBL_wd_#osmode))
  (setq *error* err_old)     ; Restore standard *error* handler

  ; Check in GBL_wd_sup support folder for any user post processing ".lsp" or ".vlx" programs. Any with 
  ; a file name containing substring "plcpost" will be "loaded". Each needs to be "self-starting".
  (if (setq wdio_post_lst (wdio_look4_plcpost_utils))
    (progn ; load the plcpost utility (or utilities)
      (princ "\n")
      (princ (c:wd_msg "IO032" nil "*plcpost* utility found"))
      (princ "\n")
      (foreach x wdio_post_lst
        (princ "\nLoad/run ")
        (princ x)
        (princ "\n")
        (load x) ; Load the lsp or vlx program. Assume it will auto-start and run.
      )
      (princ "\n")
  ) )
  
  ; Current drawing should be finished at this point
  (if (= GBL_wd_wdio_add2proj "1") ; toggle was set for "Add new dwgs to active project"
    (progn ; Add this drawing to the active project (if it is not already in the project list)
      (setq x (c:wd_is_cur_dwg_in_proj))
      (cond
        ((> x 0)) ; this drawing is already listed in the project
        ((< x 0)) ; no project is marked as "active" ??
        ((= x 0) ; active dwg is not listed in active project, add it now.
; ** 12-Aug-07 NEHolt - attempt to update title block on this new drawing before it is added to the project. - 962903
          ; Call the normal AutoCAD Electrical "API" call for updating active drawing's title block
          ;    First sublist (of 13 elements, 1 for selected, 0 for not selected )
          ;    1st =  mapped to DWGDESC (the description under drawing "properties")
          ;    2nd = mapped to DWGSEC
          ;    3rd = mapped to DWGSUB
          ;    4th = mapped to FILENAME
          ;    5th = mapped to FILENAMEEXT
          ;    6th = mapped to FULLFILENAME
          ;    7th = mapped to DWGNAM
          ;    8th = mapped to SHEET
          ;    9th = mapped to SHEETMAX
          ;   10th =
          ;   11th = mapped to IEC_P (the drawing's IEC coding default for %P)
          ;   12th = mapped to IEC_I (the drawing's IEC coding default for %I)
          ;   13th = mapped to IEC_L (the drawing's IEC coding default for %L)
          (c:wd_tb_process_one 1 (list (list 1 1 1 1 1 1 1 1 0 0 1 1 1))) ; update title block
; ** 12-Aug-07 NEHolt.end          
          (c:ace_add_dwg_to_project nil (list "" "" "" 1)) ; first "nil" = add active dwg
      ) )
  ) )    
  
; **
  ; Open next drawing and continue the build process.
  (if (not xitflg)
    (progn    
    
      ; Figure out full name for next drawing
      (setq continuation_dwg_attribs nil) 
      (if (AND continuation_dwg_lst (< continuation_dwg_cnt (length continuation_dwg_lst)))
        (progn ; Use next dwg from the "continuation list" passed to this routine
          (setq newnam (nth continuation_dwg_cnt continuation_dwg_lst))
              
          ; "newnam" can either be the new drawing name to use or it can be
          ; a list consisting of the new drawing name to use (nth 0), and
          ; some attribute values to set on the new drawing's WD_M block. 
          ; These are encoded in format attrnam=attrval;attrnam=attrval;...
          ; For example:
          ; newnam = (list "plcio_dwg_001" "IEC_LOC=MACH OP STA" "IEC_INST=LINE1")
          (if (listp newnam)
            (progn ;               
              (setq continuation_dwg_attribs (cdr newnam))
              (setq newnam (car newnam))
          ) )
              
          (setq continuation_dwg_cnt (1+ continuation_dwg_cnt))
          ; Strip off any ".dwg" to keep it synched up with code below
          (if (= (ace_strcase (substr newnam (- (strlen newnam) 2))) "DWG")
            (setq newnam (substr newnam 1 (- (strlen newnam) 4)))
          )  
        )
      ; ELSE
        (progn ; Increment the current dwg's name                    
          (setq newnam (getvar "DWGNAME")) ; get current dwg name
          (if (> (atoi (getvar "ACADVER")) 13)
            (progn ; R14 is different!
              (if (= (substr newnam (- (strlen newnam) 3) 1) ".")
                ; Strip off ".dwg"
                (setq newnam (substr newnam  1 (- (strlen newnam) 4)))
              )
              (setq newnam (strcat (getvar "DWGPREFIX") newnam))
          ) )
          ; Increment the drawing file name by "1"
          (setq newnam (c:wd_increment_str newnam 1))
      ) ) 
      (setq GBL_wd_wdio_start_fnam (strcat newnam ".dwg")) ; next proposed dwg name     
  ) )    

  (if (not xitflg)
    (progn
      (if (= use_skip 1) ; Next dwg's 1st ladder is incremented by "skipcnt"
        (progn
          (setq ladder_first_ref (c:wd_increment_str
                 dwg_ladder_first_ref skipcnt))
          ; Remember incremented ladder ref number of 1st ladder on this dwg
          (setq dwg_ladder_first_ref ladder_first_ref) ; ** 14-Jul-00 NEHolt
        )
      )
      (if (/= dwg_pause "N")
        (progn
; ** 25-Aug-06 NEHolt problem in MDI mode - need to access internal
;         function in "wdio_main". Call it with dummy parameter to 
;         get it into memory. This is not pretty.
          (if (not (boundp 'wd_wdio_main_dialog))(wdio_main "DUMMY"))       
; ** 25-Aug-06 NEHolt.en          
          (setq x (wd_wdio_main_dialog nil))
          (if (not x)
            (setq xitflg 1) ; user cancel
          ; ELSE
            (progn
              (setq GBL_wd_wdio_start_fnam (caddr x)) ; next drawing name (possibly changed from dialog)
              (setq xitflg nil) ; keep going
            )
      ) ) )
  ) )
  (if (not xitflg)
    (progn
      ; Keep track of file names of new drawings created (past the opening drawing)
      (setq GBL_wdio_new_dwgs_created (reverse (cons GBL_wd_wdio_start_fnam (reverse GBL_wdio_new_dwgs_created))))

      (if (= (getvar "SDI") 1) ; **** SDI SINGLE DOCUMENT MODE IS ACTIVE ****
        (progn ; close and open using regular AutoCAD calls, not script
          (command "_.QSAVE")
          (command "_.NEW" (wdio_chk4_longfname useprototype))
; ** 14-Feb-05 NEHolt          
          (if (findfile GBL_wd_wdio_start_fnam)
            (progn ; overwrite existing file required
              (command "_.SAVE")
              (command (wdio_chk4_longfname GBL_wd_wdio_start_fnam))
              (command "_YES") ; yes to overwrite
            )
          ; ELSE
            (progn ; no existing file, no "_YES" to overwrite is required
              (command "_.SAVE")
              (command (wdio_chk4_longfname GBL_wd_wdio_start_fnam))
          ) )  
; **             
          (c:wdio_doit) ; re-launch program       
        )
      ; ELSE ; open next new dwg with SCRIPT call
        (progn  ; ****  MDI MULTI-DOCUMENT MODE IS ACTIVE ****
          ; Build new version of script file to open next drawing and
          ; execute (c:rw_doit tmpfnam)
          (setq f (open (strcat wdio_usr_path "_wdio.scr") "w"))
          (if (/= f nil)
            (progn
              ; New drawing (with "=" for "no prototype", for now!)
              (if (= useprototype nil) (setq useprototype ".")) ; trigger "No Template"
              (write-line "_.qsave" f)
; ** 21-Oct-06 NEHolt - 831028
              ; If active dwg is unnamed, then the above QSAVE will prompt for a file name.
              ; Under these conditions, just "hit return"
              (if (= (getvar "DWGTITLED") 0)(write-line "" f))
; ** 21-Oct-06 NEHolt.en                                                  
; ** 11-Feb-05 NEHolt          
              ; Make sure that the new drawing we're going to go to next is not already open in MDI mode. Issue a close
              ; command to make sure it is not open
; ** 16-Feb-05 LeeH
              (setq open_dwgs (wd_pds_get_open_dwgs))  
              (setq this_dwg (ace_strcase GBL_wd_wdio_start_fnam) found_dwg nil)
              (if (/= (substr this_dwg (- (strlen this_dwg) 3)) ".DWG")
                (setq this_dwg (strcat this_dwg ".DWG"))
              )      
              (foreach curr_dwg open_dwgs
                (if (not found_dwg) 
                  (setq found_dwg (= (ace_strcase curr_dwg) this_dwg))
                )
              )  
              (if found_dwg    
                (write-line (strcat "(wd_pdsx_close \"" (wd_4_convert2_doublebackslash GBL_wd_wdio_start_fnam) "\" T)" ) f)
              )
; **          
              (write-line "_.new" f)
          
              (write-line (wdio_chk4_longfname useprototype) f) ; ** 16-Jul-99
              (write-line "_.SAVE" f)
              (write-line (wdio_chk4_longfname GBL_wd_wdio_start_fnam) f) ; ** 25-Jun-99 chk for embedded space
              (if (findfile GBL_wd_wdio_start_fnam)
                ;**10-Sep-04 PanQ, Use _YES instead of _Y
                (write-line "_YES" f) ; yes to overwrite
              )
              (write-line (strcat "(wd_pdsx_close \"" (wd_4_convert2_doublebackslash (strcat (getvar "dwgprefix") (getvar "dwgname"))) "\" T)" ) f)
              
              ; In MDI mode, make sure AcadE is "awake" before trying to re-load the wdio.lsp routine below
              (write-line "(if(not wd_load)(if(setq x(findfile \"wd_load.lsp\"))(load x)))(wd_load)" f) ; ** 21-Oct-06 NEHolt
              
; ** 04-Oct-07 NEHolt - for ACE2009, file was moved                         
;              (write-line "(load (strcat GBL_wd_sup \"wdio.lsp\"))" f);** 10-Sep-04 PanQ, load wdio.lsp first
              (write-line "(load (findfile \"wdio.lsp\"))" f)
; ** 04-Oct-07 NEHolt.end
              (write-line "wdio_doit" f)
              (close f) ; close the newly created "script" file 
              (setq f nil)        
              (save_global_variables);** 10-Sep-09 PanQ
              ; Launch the script file to open the next new drawing and relaunch the wdio program to continue the process
              (command "_.SCRIPT" (strcat wdio_usr_path "_wdio.scr"))
          ) )        
        )
    ) )
  ; ELSE
    (progn
      ;16-Jul-2004 PanQ, Change for MDI
      (if (AND #lispinit (= (getvar "SDI") 1)) (setvar "LISPINIT" #LISPINIT))
      
      ; set variables to nil
      (reset_global_variables)
  ) )
  (if Aw_debug (princ "\nOUT:wdio_doit"))  
  (princ)
)
; ---
(defun wd_get_attr_val_nam_en ( x_en attr / str atnam enn edd )
  ; Assumes "x_en" = block name
  ; "attr" name may contain wild cards
  (if (AND x_en (setq enn (entnext x_en))) (setq edd (entget enn)))
  (setq atnam nil)
  (setq str nil)
  (setq x_en nil)
  (while (AND enn (not x_en) (/= (cdr (assoc 0 edd)) "SEQEND") (/= atnam attr)
           (/= (cdr (assoc 0 edd)) "INSERT") )
    (if (= (cdr (assoc 0 edd)) "ATTRIB")
      (progn
        (setq atnam (cdr (assoc 2 edd)))
        (if (wcmatch atnam attr)
          (progn
            (setq x_en enn)
            (setq str (cdr (assoc 1 edd))) ; get attrib value
    ) ) ) )
    (if (setq enn (entnext enn)) (setq edd (entget enn)))
  )
  (list x_en atnam str) ; return the attribute's ent name,nam,value
)

; ---
; * * * * * *
(defun wdio_1_strchr (str chx / rpos pos xflag len)
  ; Return char pos of first occurance of char "ch" in string "str"
  (setq rpos 0)
  (setq pos 0)
  (if (AND str (> (setq len (strlen str)) 0))
    (progn
      (setq xflag nil)
      (while (AND (= xflag nil) (< pos len ))
        (if (= (substr str (1+ pos) 1) chx)
          (progn ; Hit target character
            (setq xflag 1) ; flag to exit
            (setq rpos (1+ pos))
          )
        ; ELSE
          (setq pos (1+ pos))
  ) ) ) )
  rpos ; return char position or 0 if not found
)
; ----
; --- *** 18-Feb-00 PMM
(defun wdio_cdrlst ( data / lst newlst x rtrn)
  ; strip of dotted pairs from list of lists
  (if Aw_debug (princ "\n  IN/OUT:wdio_cdrlst"))
  (setq rtrn nil)
  (if data
    (progn
      (foreach lst data
        (setq newlst '())
        (foreach x lst
          (setq x (cdr x))
          (if (= x " ") (setq x ""))
          (setq newlst (cons x newlst))
        )
        (setq rtrn (cons (reverse newlst) rtrn))
      )
    )
  )
  (reverse rtrn)
)
; ----- *** 20-Feb-00 PMM
(defun wdio_lst_to_delim_str ( lst char / str x flag)
  ; Convert list "lst" to delimited string delimited with char "char"
  ; Assumes list contains TEXT
;  (if Aw_debug (princ "\nIN:wdio_lst_to_delim_str"))
  (setq str "")
  (setq flag nil)
  (foreach x lst
    (if flag (setq str (strcat str char))) ; add delim after 1st item
    (setq flag 1)
; ** 27-Jun-00 NEHolt
    (cond
      ((not x)(setq x ""))
      ((= (type x) 'STR))
      ((= (type x) 'INT)(setq x (itoa x)))
      ((= (type x) 'REAL)(setq x (rtos x 2 1)))
    )
; **
    (setq str (strcat str x))
  )
;  (if Aw_debug (princ "\nOUT:wdio_lst_to_delim_str"))
  str
)
; -- ** 31-May-00 NEHolt
(defun wdio_1_get_attr_val_nam_en ( x_en attr / str atnam enn edd hit)
  ; Assumes "x_en" = block name
  ; "attr" name may contain wild cards
  (if (AND x_en (setq enn (entnext x_en))) (setq edd (entget enn)))
  (setq atnam nil)
  (setq str nil)
  (setq x_en nil)
  (setq hit nil) ; ** 22-Dec-98
  (while (AND enn (not x_en) (/= (cdr (assoc 0 edd)) "SEQEND") (not hit) ; ** 22-Dec-98
           (/= (cdr (assoc 0 edd)) "INSERT") )
    (if (= (cdr (assoc 0 edd)) "ATTRIB")
      (progn
        (setq atnam (cdr (assoc 2 edd)))
; ** 09-Dec-99 NEHolt
        ; check for exact match (ex: "SHEET#") or actual wildcard match
        (if (OR (= atnam attr)
; **
                (wcmatch atnam attr))
          (progn
            (setq x_en enn)
            (setq str (cdr (assoc 1 edd))) ; get attrib value
            (setq hit 1) ; ** 22-Dec-98 NEHolt
    ) ) ) )
    (if (setq enn (entnext enn)) (setq edd (entget enn)))
  )
  (list x_en atnam str) ; return the attribute's ent name,nam,value
)
; ----
(defun wd_wdio_all_slashes_forward ( nam / ch ix len rtrn)
  ; return "nam" with all back slashes turned forward
  (setq rtrn "")
  (if (/= nam nil)
    (progn
      (setq len (strlen nam))
      (setq ix 0)
      (while (< ix len)
        (setq ix (1+ ix))
        (setq ch (substr nam ix 1))
        (if (= ch "\\") (setq ch "/"))
        (setq rtrn (strcat rtrn ch))
  ) ) )
  rtrn
)
; --
(defun wd_wdio_move_attrib ( at_en newx newy /  ; ** 09-Feb-06 NEHolt added "newy"
         delta_x old10 old11 newed ed
         new10 new11
         thgt ;** 14-Sep-04 PanQ, Declare to local
         )
         
  ; Relocate attribute "at_en" to x value (if newx not "nil") or y value (if not "nil")
  (if Aw_debug (princ "\nIN:wd_wdio_move_attrib"))
  (setq ed (entget at_en))
  (setq thgt (cdr (assoc 40 ed)))
  (setq old10 (cdr (assoc 10 ed)))
; ** 09-Feb-06 NEHolt  
  (if newx
    (progn
      (setq delta_x (- newx (car old10))) ; calc move distance to the right-hand bus
      (setq delta_x (+ delta_x thgt)) ; go one text height distance beyond the right-hand bus
      ; Calc new DESCxx attribute position
      (setq new10 (list (+ (car old10) delta_x) (cadr old10) 0.0))
      (setq old11 (cdr (assoc 11 ed)))
      (setq new11 (list (+ (car old11) delta_x) (cadr old11) 0.0))
    )
  ; ELSE
    (if newy
      (progn
        (setq delta_y (- (cadr old10) newy) ) ; calc move distance down to the bottom bus
        (setq delta_y (+ delta_y thgt)) ; go one text height beyond the bottom bus
        ; Calc new DESCxx attribute position
        (setq new10 (list (car old10) (- (cadr old10) delta_y) 0.0))    
        (setq old11 (cdr (assoc 11 ed)))
        (setq new11 (list (car old11) (- (cadr old11) delta_y) 0.0))
  ) ) )
; **  
  (setq newed (subst (cons 10 new10) (assoc 10 ed) ed))
  (setq newed (subst (cons 11 new11) (assoc 11 newed) newed))
  (entmod newed) ; Update the moved attribute
  (if newx
    (wd_wdio_chg_desc_just at_en 0) ; flip to Left justified 
  ; ELSE
    (wd_wdio_chg_desc_just at_en 2) ; flip to Right justified
  )  
  (if Aw_debug (princ "\nOUT:wd_wdio_move_attrib"))  
)
; -----
(defun wd_wdio_chg_desc_just ( d_en jst / d_ed t_box ll ur old10 old11
       oldvt oldhz new10 new11 newed)
  ; jst=2 for RJT, 0 for LJT       
  (if Aw_debug (princ "\nIN:wd_wdio_chg_desc_just"))       
  (setq d_ed (entget d_en))
  (setq t_box (textbox d_ed))
  (setq ll (nth 0 t_box))
  (setq ur (nth 1 t_box))
  (setq old10 (cdr (assoc 10 d_ed)))
  (setq old11 (cdr (assoc 11 d_ed)))
  (setq oldvt (cdr (assoc 74 d_ed)))
  (setq oldhz (cdr (assoc 72 d_ed)))
  (setq new10 old10 new11 old11) ; ** 11-Oct-01 NEHolt
  (cond
; ** 09-Feb-06 NEHolt  
    ((= jst 0) ; going from right
      (if (= oldhz 2)
        (progn
          (setq new10 (list (car old11) (cadr old10) 0.0))
          (setq new11 old11)
    ) ) )    
    ((= jst 2) ; going from left
      (if (= oldhz 0) ; make sure changing
        (progn
          (setq new10 (list (- (car old10) (car ur)) (cadr old10)))
          (cond
            ((= oldvt 1) ; bottom just
              (setq new11 old10)
            )
            ((= oldvt 0) ; bottom just ?
              (setq new11 old10)
            )
            ((= oldvt 3) ; top just
              (setq new11 (list (car old10) (+ (cadr old10) (cadr ur))))
  ) ) ) ) ) )
; **  
  (setq newed (subst (cons 72 jst) (assoc 72 d_ed) d_ed))
  (setq newed (subst (cons 10 new10) (assoc 10 newed) newed))
  (setq newed (subst (cons 11 new11) (assoc 11 newed) newed))
  (entmod newed)
  (if Aw_debug (princ "\nOUT:wd_wdio_chg_desc_just"))     
)
; --
(defun wd_wdio_get_descattrs (en / enlst namlst edb enn edd atnam )
  ; Find DESC* attr names on symbol "en" and return lists.
  (setq enlst '())
  (setq namlst '())
  (setq edb (entget en))
  (if (= (cdr (assoc 0 edb)) "INSERT")
    (progn ; Extract std attributes off of INSERT "en"
      (if (setq enn (entnext en)) (setq edd (entget enn)))
      (while (AND enn (/= (cdr (assoc 0 edd)) "SEQEND")
                      (/= (cdr (assoc 0 edd)) "INSERT"))
        (if (= (cdr (assoc 0 edd)) "ATTRIB")
          (progn
            (setq atnam (cdr (assoc 2 edd)))
            (cond
              ((wcmatch atnam "DESC*")
                ; Attrib DESCx where x is integer digit
                (setq namlst (cons atnam namlst))
                (setq enlst (cons enn enlst))
        ) ) ) )
        (if (setq enn (entnext enn)) (setq edd (entget enn)))
  ) ) )
  ; Return list of attribute entity names found
  (list namlst enlst) ; return the lists
)

; --- *** 12-Oct-00 PMM renamed
(defun wd_wdiob_csv_dlg ( / dcl_id2 str lst lst2 xx x l_lst rtrn cancel _lstx
       saved_values ix)
  ; --- internal ---
  (defun fill_dlg ( / lst x )
    (start_list "lst")
    (setq lst '())
    (if (= scroll 0) (setq scroll 1))
; ** 13-Jan-03 NEHolt typo??    
;    (if (= scroll 252)(setq scroll 252)); ** 17-Oct-02 ScottH
    (if (> scroll 420)(setq scroll 420)) ; ** 60 columns at 7 char each
; **    
    (foreach x l_lst (setq lst (cons (substr x scroll) lst)))
    (setq lst (reverse lst))
    (mapcar 'add_list lst)
    (end_list)
  )
  (defun build_str ( / ix )
    (setq str (list "N/A"))
    (setq ix 1)
    (repeat maxcolcnt (setq str (cons (itoa ix) str)) (setq ix (1+ ix)))
    (setq str (reverse str))
  )
  ; ---
  (defun preset_ix_nums ( / ix _lstx)
    (setq _lstx nil)
    (build_str)
    (foreach x (list "plc_code_ix" "rack_ix" "group_ix" "slot_ix" "addr_ix"
       "remote_tp_ix" "wire_tag_ix" "desc1_ix" "desc2_ix" "desc3_ix"
       "desc4_ix" "desc5_ix" "volt_ix"
       "plc_inst_ix" "plc_loc_ix" ; ** 23-May-02 NEHolt
       "plc_mod_tag_ix") ; ** 07-Jun-02 NEHolt
      (start_list x)(mapcar 'add_list str)(end_list)
      (set_tile x (itoa (eval (read x))))
; ** 31-Aug-06 NEHolt      
      (setq _lstx (cons (list x (eval (read x))) _lstx))      
    )
    _lstx ; list of saved variable names and original values  ; ** 31-Aug-06 NEHolt - 775764
; ** 31-Aug-06 NEHolt.en    
  )
  ; --
  (defun preset_dev_ix_nums ( / ix xval _lstx)
    (setq _lstx nil)
    (build_str)
    (setq xx 0)
    (repeat 9 ; ** 17-Oct-02 ScottH changed 6 -> 9
      (setq xx (1+ xx))
      (foreach x (list "tag" "desc" "blk" "loc" "inst" "mfg" "cat" "asm"); ** 22-Feb-02 SAH added "inst"
        (start_list (setq xxx (strcat "comp_" x "_ix" (itoa xx))))
        (mapcar 'add_list str)
        (end_list)
        (setq xval (eval (read xxx)))
        (if (AND xval (itoa xval)) (set_tile xxx (itoa xval)))
        (setq _lstx (cons (list xxx (eval (read xxx))) _lstx)) ; ** 31-Aug-06 NEHolt - 775764
    ) )
    _lstx ; list of saved variable names and original values  ** 31-Aug-06 NEHolt - 775764
  )
  ; --
  (defun do_devices ( / dcl_id3 sav_scroll x)
; ** 23-Oct-07 NEHolt - 991766
    (setq x (findfile "wdio.dcl"))
    (if (not x) (setq x (findfile (strcat wdio_sup_path "wdio.dcl"))))
    (if x
      (progn      
        (setq dcl_id3 (load_dialog x))
; ** 23-Oct-07 NEHolt.end        
        (if (not (new_dialog "wdio_dev_dlg" dcl_id3)) (exit))
        (setq saved_values (preset_dev_ix_nums)) ; ** 31-Aug-06 NEHolt - 775764
        ; *** 26-Aug-00 PMM
        (setq sav_scroll scroll) ; save for when go back
        (setq scroll 1)
        (fill_dlg)
        (action_tile "scroll" "(setq scroll (atoi $value))(fill_dlg)")
        ; ***
        (action_tile "comp_blk_ix1" "(setq comp_blk_ix1 (atoi $value))")
        (action_tile "comp_tag_ix1" "(setq comp_tag_ix1 (atoi $value))")
        (action_tile "comp_desc_ix1" "(setq comp_desc_ix1 (atoi $value))")
        (action_tile "comp_loc_ix1" "(setq comp_loc_ix1 (atoi $value))")
        (action_tile "comp_inst_ix1" "(setq comp_inst_ix1 (atoi $value))")    
        (action_tile "comp_mfg_ix1" "(setq comp_mfg_ix1 (atoi $value))")
        (action_tile "comp_cat_ix1" "(setq comp_cat_ix1 (atoi $value))")
        (action_tile "comp_asm_ix1" "(setq comp_asm_ix1 (atoi $value))")
        (action_tile "comp_blk_ix2" "(setq comp_blk_ix2 (atoi $value))")
        (action_tile "comp_tag_ix2" "(setq comp_tag_ix2 (atoi $value))")
        (action_tile "comp_desc_ix2" "(setq comp_desc_ix2 (atoi $value))")
        (action_tile "comp_loc_ix2" "(setq comp_loc_ix2 (atoi $value))")
        (action_tile "comp_inst_ix2" "(setq comp_inst_ix2 (atoi $value))")
        (action_tile "comp_mfg_ix2" "(setq comp_mfg_ix2 (atoi $value))")
        (action_tile "comp_cat_ix2" "(setq comp_cat_ix2 (atoi $value))")
        (action_tile "comp_asm_ix2" "(setq comp_asm_ix2 (atoi $value))")
        (action_tile "comp_blk_ix3" "(setq comp_blk_ix3 (atoi $value))")
        (action_tile "comp_tag_ix3" "(setq comp_tag_ix3 (atoi $value))")
        (action_tile "comp_desc_ix3" "(setq comp_desc_ix3 (atoi $value))")
        (action_tile "comp_loc_ix3" "(setq comp_loc_ix3 (atoi $value))")
        (action_tile "comp_inst_ix3" "(setq comp_inst_ix3 (atoi $value))")    
        (action_tile "comp_mfg_ix3" "(setq comp_mfg_ix3 (atoi $value))")
        (action_tile "comp_cat_ix3" "(setq comp_cat_ix3 (atoi $value))")
        (action_tile "comp_asm_ix3" "(setq comp_asm_ix3 (atoi $value))")
        (action_tile "comp_blk_ix4" "(setq comp_blk_ix4 (atoi $value))")
        (action_tile "comp_tag_ix4" "(setq comp_tag_ix4 (atoi $value))")
        (action_tile "comp_desc_ix4" "(setq comp_desc_ix4 (atoi $value))")
        (action_tile "comp_loc_ix4" "(setq comp_loc_ix4 (atoi $value))")
        (action_tile "comp_inst_ix4" "(setq comp_inst_ix4 (atoi $value))")    
        (action_tile "comp_mfg_ix4" "(setq comp_mfg_ix4 (atoi $value))")
        (action_tile "comp_cat_ix4" "(setq comp_cat_ix4 (atoi $value))")
        (action_tile "comp_asm_ix4" "(setq comp_asm_ix4 (atoi $value))")
        (action_tile "comp_blk_ix5" "(setq comp_blk_ix5 (atoi $value))")
        (action_tile "comp_tag_ix5" "(setq comp_tag_ix5 (atoi $value))")
        (action_tile "comp_desc_ix5" "(setq comp_desc_ix5 (atoi $value))")
        (action_tile "comp_loc_ix5" "(setq comp_loc_ix5 (atoi $value))")
        (action_tile "comp_inst_ix5" "(setq comp_inst_ix5 (atoi $value))")    
        (action_tile "comp_mfg_ix5" "(setq comp_mfg_ix5 (atoi $value))")
        (action_tile "comp_cat_ix5" "(setq comp_cat_ix5 (atoi $value))")
        (action_tile "comp_asm_ix5" "(setq comp_asm_ix5 (atoi $value))")
        (action_tile "more_devices" "(do_devices_more)")
        (action_tile "cancel" "(foreach x saved_values (set (read (car x)) (cadr x)))(done_dialog)") ; ** 31-Aug-06 NEHolt
        (start_dialog)
        (unload_dialog dcl_id3)
        (setq scroll sav_scroll) ; *** 26-Aug-00 PMM
  ) ) )
 ; ** 17-Oct-02 ScottH  added below
 ; Devices 7-9
 ; ** 31-Mar-04 Devices 6-9; LeeH
(defun do_devices_more ( / dcl_idmore sav_scroll csv_delim_ch x)
; ** 23-Oct-07 NEHolt - 991766
    (setq x (findfile "wdio.dcl"))
    (if (not x) (setq x (findfile (strcat wdio_sup_path "wdio.dcl"))))
    (if x
      (progn      
        (setq dcl_idmore (load_dialog x))
; ** 23-Oct-07 NEHolt.end        
        (if (not (new_dialog "wdio_dev_dlg_2nd" dcl_idmore)) (exit))
        (setq saved_values (preset_dev_ix_nums)) ; ** 31-Aug-06 NEHolt - 775764
        (setq sav_scroll scroll) ; save for when go back
        (setq scroll 252); start further into list
        (fill_dlg)
        (action_tile "scroll_2" "(setq scroll (atoi $value))(fill_dlg)")
; *** 31-Mar-04 LeeH; moved "6th device" from "wdio_dev_dlg"    
        (action_tile "comp_blk_ix6" "(setq comp_blk_ix6 (atoi $value))")
        (action_tile "comp_tag_ix6" "(setq comp_tag_ix6 (atoi $value))")
        (action_tile "comp_desc_ix6" "(setq comp_desc_ix6 (atoi $value))")
        (action_tile "comp_loc_ix6" "(setq comp_loc_ix6 (atoi $value))")
        (action_tile "comp_inst_ix6" "(setq comp_inst_ix6 (atoi $value))")    
        (action_tile "comp_mfg_ix6" "(setq comp_mfg_ix6 (atoi $value))")
        (action_tile "comp_cat_ix6" "(setq comp_cat_ix6 (atoi $value))")
        (action_tile "comp_asm_ix6" "(setq comp_asm_ix6 (atoi $value))")
; *** LeeH    
    ; ***
        (action_tile "comp_blk_ix7" "(setq comp_blk_ix7 (atoi $value))")
        (action_tile "comp_tag_ix7" "(setq comp_tag_ix7 (atoi $value))")
        (action_tile "comp_desc_ix7" "(setq comp_desc_ix7 (atoi $value))")
        (action_tile "comp_loc_ix7" "(setq comp_loc_ix7 (atoi $value))")
        (action_tile "comp_inst_ix7" "(setq comp_inst_ix7 (atoi $value))")    
        (action_tile "comp_mfg_ix7" "(setq comp_mfg_ix7 (atoi $value))")
        (action_tile "comp_cat_ix7" "(setq comp_cat_ix7 (atoi $value))")
        (action_tile "comp_asm_ix7" "(setq comp_asm_ix7 (atoi $value))")
        (action_tile "comp_blk_ix8" "(setq comp_blk_ix8 (atoi $value))")
        (action_tile "comp_tag_ix8" "(setq comp_tag_ix8 (atoi $value))")
        (action_tile "comp_desc_ix8" "(setq comp_desc_ix8 (atoi $value))")
        (action_tile "comp_loc_ix8" "(setq comp_loc_ix8 (atoi $value))")
        (action_tile "comp_inst_ix8" "(setq comp_inst_ix8 (atoi $value))")    
        (action_tile "comp_mfg_ix8" "(setq comp_mfg_ix8 (atoi $value))")
        (action_tile "comp_cat_ix8" "(setq comp_cat_ix8 (atoi $value))")
        (action_tile "comp_asm_ix8" "(setq comp_asm_ix8 (atoi $value))")
        (action_tile "comp_blk_ix9" "(setq comp_blk_ix9 (atoi $value))")
        (action_tile "comp_tag_ix9" "(setq comp_tag_ix9 (atoi $value))")
        (action_tile "comp_desc_ix9" "(setq comp_desc_ix9 (atoi $value))")
        (action_tile "comp_loc_ix9" "(setq comp_loc_ix9 (atoi $value))")
        (action_tile "comp_inst_ix9" "(setq comp_inst_ix9 (atoi $value))")    
        (action_tile "comp_mfg_ix9" "(setq comp_mfg_ix9 (atoi $value))")
        (action_tile "comp_cat_ix9" "(setq comp_cat_ix9 (atoi $value))")
        (action_tile "comp_asm_ix9" "(setq comp_asm_ix9 (atoi $value))") 
        (action_tile "cancel" "(foreach x saved_values (set (read (car x)) (cadr x)))(done_dialog)") ; ** 31-Aug-06 NEHolt
        (start_dialog)
        (unload_dialog dcl_idmore)
        (setq scroll sav_scroll)
  ) ) ) 

  ; --- main routine ---
  (if Aw_debug (princ "\nIN:wd_wdiob_csv_dlg"))
  (setq rtrn nil)
  (setq cancel nil)
  (setq maxcolcnt 60) ; ** 13-Jan-03 NEHolt
; *** 14-Feb-00 PMM account for file type XLS
  ; Open file and read in first few lines
  (setq str "")
  (setq l_lst '()) ; *** 26-Aug-00 PMM
  (setq xx 1)
  (repeat maxcolcnt
; ** 15-Dec-04 NEHolt column number header labels not lined up   
    (if (< xx 10)
      ; *** 11-May-07 Long Fan: WD_MSG.MDB messages inconsistencies
      (setq str (strcat str (substr (strcat "  " (c:wd_msg "IO033" nil "Col") (itoa xx) "   ") 1 7)))  ; ** 26-Dec-06 NEHolt
    ; ELSE  
      ; *** 11-May-07 Long Fan: WD_MSG.MDB messages inconsistencies
      (setq str (strcat str (substr (strcat " " (c:wd_msg "IO033" nil "Col") (itoa xx) "   ") 1 7)))  ; ** 26-Dec-06 NEHolt
    )  
; **    
    (setq xx (1+ xx))
  )
  ; *** 26-Aug-00 PMM do this later
  (setq l_lst (cons str l_lst))
;  (setq l_lst (cons "" (list str))) ; add in one blank line
;; ** 23-May-02 NEHolt
  (cond
    ((OR (= ss_fnam_ext "XLS")(= ss_fnam_ext "MDB"))
      (if (AND (not tabnam) (not xlsdata)); no table read yet
        (progn
          (setq tabnam (wdio_get_tabnam ss_fnam ss_fnam_ext))
          (if (not tabnam) (exit))
          (setq x (wdio_read_xls_or_mdb_data ss_fnam tabnam ss_fnam_ext))
          (setq fieldnames (cadr x))
          (setq xlsdata (car x))
      ) )
      ; *** 26-Aug-00 PMM
      ; use field names as first line
      (setq xx 1)
      (setq str "")
; ** 28-Dec-00 NEHolt
      (if (not first_is_data) ; if first line is not first line of first module...
        (progn
; **
          (foreach x fieldnames
            (setq str (strcat str (substr (strcat " " x "           ") 1 6) " "))
          )
          (setq l_lst (cons str l_lst)) ; column field names
      ) )
      (setq l_lst (cons "" l_lst)) ; add in one blank line
      ; just use first 16 lines
      (setq ix 0)
      (while (AND (< ix (length xlsdata)) (< ix 16))
        (setq lst (nth ix xlsdata))
        (setq str "")
        (setq lst2 nil)
        (foreach xx lst
          (setq str (strcat str (substr (strcat xx "           ") 1 6) "|"))
        )
        (setq l_lst (cons str l_lst))
        (setq ix (1+ ix))
        (setq maxcolcnt (max maxcolcnt (length lst)))
      )
      (setq l_lst (reverse l_lst))
    )

    (T ; CSV
      (setq csv_delim_ch (c:ace_getlocalelistsep)) ; get delim char from registry (defaults to ",") ; ** 29-Dec-05 NEHolt
      ; *** 26-Aug-00 PMM
      (setq l_lst (cons "" (list str))) ; add in one blank line
      (setq f (open ss_fnam "r"))
      (if f
        (progn
          (setq ix 0)
          (while (AND (setq dline (read-line f)) (/= dline "") (< ix 16))
            (setq lst (c:wd_delim_str_to_lst dline csv_delim_ch)) ; ** 14-May-05 NEHolt
            (setq str "")
            (setq lst2 nil)

            (foreach xx lst
              (setq str (strcat str (substr (strcat xx "           ") 1 6) "|"))
            )
            (setq l_lst (cons str l_lst))
            (setq ix (1+ ix))
            (setq maxcolcnt (max maxcolcnt (length lst)))
          )
          (close f)
          (setq f nil)
          (setq l_lst (reverse l_lst))
      ) )
  ) )
; ***
  (setq cix 0)
; ** 23-Oct-07 NEHolt - 991766
  (setq x (findfile "wdio.dcl"))
  (if (not x) (setq x (findfile (strcat wdio_sup_path "wdio.dcl"))))
  (if x
    (progn      
      (setq dcl_id2 (load_dialog x))
; ** 23-Oct-07 NEHolt.end        
      (if (not (new_dialog "wdio_csv_dlg" dcl_id2)) (exit))
      (setq scroll 1)
      (setq saved_values (preset_ix_nums)) ; ** 31-Aug-06 NEHolt
      (fill_dlg)
      (action_tile "scroll" "(setq scroll (atoi $value))(fill_dlg)")
      (action_tile "plc_code_ix" "(setq plc_code_ix (atoi $value))")
      (action_tile "rack_ix" "(setq rack_ix (atoi $value))")
      (action_tile "group_ix" "(setq group_ix (atoi $value))")
      (action_tile "slot_ix" "(setq slot_ix (atoi $value))")
      (action_tile "addr_ix" "(setq addr_ix (atoi $value))")
      (action_tile "remote_tp_ix" "(setq remote_tp_ix (atoi $value))")
      (action_tile "wire_tag_ix" "(setq wire_tag_ix (atoi $value))")
  
; ** 23-May-02 NEHolt
      (action_tile "plc_inst_ix" "(setq plc_inst_ix (atoi $value))")
      (action_tile "plc_loc_ix" "(setq plc_loc_ix (atoi $value))")
; ** 07-Jun-02 NEHolt
      (action_tile "plc_mod_tag_ix" "(setq plc_mod_tag_ix (atoi $value))")

    
      (action_tile "desc1_ix" "(setq desc1_ix (atoi $value))")
      (action_tile "desc2_ix" "(setq desc2_ix (atoi $value))")
      (action_tile "desc3_ix" "(setq desc3_ix (atoi $value))")
      (action_tile "desc4_ix" "(setq desc4_ix (atoi $value))")
      (action_tile "desc5_ix" "(setq desc5_ix (atoi $value))")
      (action_tile "volt_ix" "(setq volt_ix (atoi $value))")
      (action_tile "devices" "(do_devices)")
      (action_tile "cancel" "(foreach x saved_values (set (read (car x)) (cadr x)))(done_dialog)") ; ** 31-Aug-06 NEHolt
      (start_dialog)
      (unload_dialog dcl_id2)
  ) )    
  (if Aw_debug (princ "\nOUT:wd_wdiob_csv_dlg"))
)

; -----
(defun wd_wdio_save_wdi_button ( / cfg_fnam f)
  ; write out the current ladder/spreadsheet settings to a file
; ** 13-Oct-03 NEHolt
  ; -- internal routine --
  (defun wdio_rtos_add_leading_zero ( str / )
    ; If call to (rtos ...) yields a return with a decimal point as first char, add in leading zero.
    (if (AND str (= (substr str 1 1) "."))(setq str (strcat "0" str)))
    str ; return original string or string with leading zero added in front of a decimal point
  )
; **
  ; -- main routine --  
  ; get a file name
; ** 24-Jan-01 NEHolt
  (cond
    ((/= GBL_wd_wdio_cfg_fnam nil) ; previously selected file
      (setq cfg_fnam (getfiled (c:wd_msg "IO031" nil "Save Settings") ; ** 17-Mar-04 NEHolt
          GBL_wd_wdio_cfg_fnam "WDI" 1))
    )
    (T
; **
      (setq cfg_fnam (getfiled (c:wd_msg "IO031" nil "Save Settings") ; ** 17-Mar-04 NEHolt
         (strcat wdio_usr_path "demoplc.wdi") "WDI" 1))
  ) )
  (if cfg_fnam
    (progn
      (setq f (open cfg_fnam "w"))
      (if f
        (progn
; ** 24-Jan-01 NEHolt
          (setq GBL_wd_wdio_cfg_fnam cfg_fnam) ; save name
; **
          ; write spreadsheet settings
          (write-line (strcat "(setq plc_code_ix " (itoa plc_code_ix) ")") f)
          (write-line (strcat "(setq rack_ix " (itoa rack_ix) ")") f)
          (write-line (strcat "(setq group_ix " (itoa group_ix) ")") f)
          (write-line (strcat "(setq slot_ix " (itoa slot_ix) ")") f)
          (write-line (strcat "(setq addr_ix " (itoa addr_ix) ")") f)
          (write-line (strcat "(setq wire_tag_ix " (itoa wire_tag_ix) ")") f)
          (write-line (strcat "(setq remote_tp_ix " (itoa remote_tp_ix) ")") f)
; ** 23-May-02 NEHolt          
          (write-line (strcat "(setq plc_inst_ix " (itoa plc_inst_ix) ")") f)
          (write-line (strcat "(setq plc_loc_ix " (itoa plc_loc_ix) ")") f)
; ** 07-Jun-02 NEHolt
          (write-line (strcat "(setq plc_mod_tag_ix " (itoa plc_mod_tag_ix) ")") f)
; **          
          (write-line (strcat "(setq desc1_ix " (itoa desc1_ix) ")") f)
          (write-line (strcat "(setq desc2_ix " (itoa desc2_ix) ")") f)
          (write-line (strcat "(setq desc3_ix " (itoa desc3_ix) ")") f)
          (write-line (strcat "(setq desc4_ix " (itoa desc4_ix) ")") f)
          (write-line (strcat "(setq desc5_ix " (itoa desc5_ix) ")") f)
          (write-line (strcat "(setq volt_ix " (itoa volt_ix) ")") f)
          (write-line (strcat "(setq comp_tag_ix1 " (itoa comp_tag_ix1) ")") f)
          (write-line (strcat "(setq comp_desc_ix1 " (itoa comp_desc_ix1) ")") f)
          (write-line (strcat "(setq comp_blk_ix1 " (itoa comp_blk_ix1) ")") f)
          (write-line (strcat "(setq comp_loc_ix1 " (itoa comp_loc_ix1) ")") f)
          (write-line (strcat "(setq comp_inst_ix1 " (itoa comp_inst_ix1) ")") f); ** 21-Feb-02 SAH
          (write-line (strcat "(setq comp_mfg_ix1 " (itoa comp_mfg_ix1) ")") f)
          (write-line (strcat "(setq comp_cat_ix1 " (itoa comp_cat_ix1) ")") f)
          (write-line (strcat "(setq comp_asm_ix1 " (itoa comp_asm_ix1) ")") f)
          (write-line (strcat "(setq comp_tag_ix2 " (itoa comp_tag_ix2) ")") f)
          (write-line (strcat "(setq comp_desc_ix2 " (itoa comp_desc_ix2) ")") f)
          (write-line (strcat "(setq comp_blk_ix2 " (itoa comp_blk_ix2) ")") f)
          (write-line (strcat "(setq comp_loc_ix2 " (itoa comp_loc_ix2) ")") f)
          (write-line (strcat "(setq comp_inst_ix2 " (itoa comp_inst_ix2) ")") f); ** 21-Feb-02 SAH
          (write-line (strcat "(setq comp_mfg_ix2 " (itoa comp_mfg_ix2) ")") f)
          (write-line (strcat "(setq comp_cat_ix2 " (itoa comp_cat_ix2) ")") f)
          (write-line (strcat "(setq comp_asm_ix2 " (itoa comp_asm_ix2) ")") f)
          (write-line (strcat "(setq comp_tag_ix3 " (itoa comp_tag_ix3) ")") f)
          (write-line (strcat "(setq comp_desc_ix3 " (itoa comp_desc_ix3) ")") f)
          (write-line (strcat "(setq comp_blk_ix3 " (itoa comp_blk_ix3) ")") f)
          (write-line (strcat "(setq comp_loc_ix3 " (itoa comp_loc_ix3) ")") f)
          (write-line (strcat "(setq comp_inst_ix3 " (itoa comp_inst_ix3) ")") f); ** 21-Feb-02 SAH
          (write-line (strcat "(setq comp_mfg_ix3 " (itoa comp_mfg_ix3) ")") f)
          (write-line (strcat "(setq comp_cat_ix3 " (itoa comp_cat_ix3) ")") f)
          (write-line (strcat "(setq comp_asm_ix3 " (itoa comp_asm_ix3) ")") f)
          (write-line (strcat "(setq comp_tag_ix4 " (itoa comp_tag_ix4) ")") f)
          (write-line (strcat "(setq comp_desc_ix4 " (itoa comp_desc_ix4) ")") f)
          (write-line (strcat "(setq comp_blk_ix4 " (itoa comp_blk_ix4) ")") f)
          (write-line (strcat "(setq comp_loc_ix4 " (itoa comp_loc_ix4) ")") f)
          (write-line (strcat "(setq comp_inst_ix4 " (itoa comp_inst_ix4) ")") f); ** 21-Feb-02 SAH
          (write-line (strcat "(setq comp_mfg_ix4 " (itoa comp_mfg_ix4) ")") f)
          (write-line (strcat "(setq comp_cat_ix4 " (itoa comp_cat_ix4) ")") f)
          (write-line (strcat "(setq comp_asm_ix4 " (itoa comp_asm_ix4) ")") f)
          (write-line (strcat "(setq comp_tag_ix5 " (itoa comp_tag_ix5) ")") f)
          (write-line (strcat "(setq comp_desc_ix5 " (itoa comp_desc_ix5) ")") f)
          (write-line (strcat "(setq comp_blk_ix5 " (itoa comp_blk_ix5) ")") f)
          (write-line (strcat "(setq comp_loc_ix5 " (itoa comp_loc_ix5) ")") f)
          (write-line (strcat "(setq comp_inst_ix5 " (itoa comp_inst_ix5) ")") f); ** 21-Feb-02 SAH
          (write-line (strcat "(setq comp_mfg_ix5 " (itoa comp_mfg_ix5) ")") f)
          (write-line (strcat "(setq comp_cat_ix5 " (itoa comp_cat_ix5) ")") f)
          (write-line (strcat "(setq comp_asm_ix5 " (itoa comp_asm_ix5) ")") f)
          (write-line (strcat "(setq comp_tag_ix6 " (itoa comp_tag_ix6) ")") f)
          (write-line (strcat "(setq comp_desc_ix6 " (itoa comp_desc_ix6) ")") f)
          (write-line (strcat "(setq comp_blk_ix6 " (itoa comp_blk_ix6) ")") f)
          (write-line (strcat "(setq comp_loc_ix6 " (itoa comp_loc_ix6) ")") f)
          (write-line (strcat "(setq comp_inst_ix6 " (itoa comp_inst_ix6) ")") f); ** 21-Feb-02 SAH
          (write-line (strcat "(setq comp_mfg_ix6 " (itoa comp_mfg_ix6) ")") f)
          (write-line (strcat "(setq comp_cat_ix6 " (itoa comp_cat_ix6) ")") f)
          (write-line (strcat "(setq comp_asm_ix6 " (itoa comp_asm_ix6) ")") f)
          ; ** 17-Oct-02 ScottH  added below
          (write-line (strcat "(setq comp_tag_ix7 " (itoa comp_tag_ix7) ")") f)
          (write-line (strcat "(setq comp_desc_ix7 " (itoa comp_desc_ix7) ")") f)
          (write-line (strcat "(setq comp_blk_ix7 " (itoa comp_blk_ix7) ")") f)
          (write-line (strcat "(setq comp_loc_ix7 " (itoa comp_loc_ix7) ")") f)
          (write-line (strcat "(setq comp_inst_ix7 " (itoa comp_inst_ix7) ")") f)
          (write-line (strcat "(setq comp_mfg_ix7 " (itoa comp_mfg_ix7) ")") f)
          (write-line (strcat "(setq comp_cat_ix7 " (itoa comp_cat_ix7) ")") f)
          (write-line (strcat "(setq comp_asm_ix7 " (itoa comp_asm_ix7) ")") f)
          (write-line (strcat "(setq comp_tag_ix8 " (itoa comp_tag_ix8) ")") f)
          (write-line (strcat "(setq comp_desc_ix8 " (itoa comp_desc_ix8) ")") f)
          (write-line (strcat "(setq comp_blk_ix8 " (itoa comp_blk_ix8) ")") f)
          (write-line (strcat "(setq comp_loc_ix8 " (itoa comp_loc_ix8) ")") f)
          (write-line (strcat "(setq comp_inst_ix8 " (itoa comp_inst_ix8) ")") f)
          (write-line (strcat "(setq comp_mfg_ix8 " (itoa comp_mfg_ix8) ")") f)
          (write-line (strcat "(setq comp_cat_ix8 " (itoa comp_cat_ix8) ")") f)
          (write-line (strcat "(setq comp_asm_ix8 " (itoa comp_asm_ix8) ")") f)
          (write-line (strcat "(setq comp_tag_ix9 " (itoa comp_tag_ix9) ")") f)
          (write-line (strcat "(setq comp_desc_ix9 " (itoa comp_desc_ix9) ")") f)
          (write-line (strcat "(setq comp_blk_ix9 " (itoa comp_blk_ix9) ")") f)
          (write-line (strcat "(setq comp_loc_ix9 " (itoa comp_loc_ix9) ")") f)
          (write-line (strcat "(setq comp_inst_ix9 " (itoa comp_inst_ix9) ")") f)
          (write-line (strcat "(setq comp_mfg_ix9 " (itoa comp_mfg_ix9) ")") f)
          (write-line (strcat "(setq comp_cat_ix9 " (itoa comp_cat_ix9) ")") f)
          (write-line (strcat "(setq comp_asm_ix9 " (itoa comp_asm_ix9) ")") f)
          ; * * *
          ; ladder settings
; ** 13-Oct-03 NEHolt put "(wdio_rtos_add_leading_zero " prefix call on all "(rtos " calls below          
          (write-line (strcat "(setq first_ladder_XY_org '("
            (wdio_rtos_add_leading_zero (rtos (car first_ladder_XY_org) 2 4)) " "
            (wdio_rtos_add_leading_zero (rtos (cadr first_ladder_XY_org) 2 4)) "))") f)
          (write-line (strcat "(setq ladder_cnt " (itoa ladder_cnt) ")") f)
          (write-line (strcat "(setq ladder_width " (wdio_rtos_add_leading_zero (rtos ladder_width 2 4)) ")") f)
          (write-line (strcat "(setq ladder_2_ladder_dist "
            (wdio_rtos_add_leading_zero (rtos ladder_2_ladder_dist 2 4)) ")") f)
          (write-line (strcat "(setq rung_spacing "
            (wdio_rtos_add_leading_zero (rtos rung_spacing 2 4)) ")") f)
          (write-line (strcat "(setq usr_rv " (wdio_rtos_add_leading_zero (rtos usr_rv 2 4)) ")") f)
          (write-line (strcat "(setq ladder_rung_cnt "
            (itoa ladder_rung_cnt) ")") f)
          (write-line (strcat "(setq rung_skip " (itoa rung_skip) ")") f)
          (write-line (strcat "(setq max_pnt_cnt_per_ldr "
            (itoa max_pnt_cnt_per_ldr) ")") f)
          (write-line (strcat "(setq plc_style " (itoa plc_style) ")") f)
          (write-line (strcat "(setq arrow_style " (itoa arrow_style) ")") f); ** > 2-25-02 ScottH
          (write-line (strcat "(setq plc_input_x_offset "
            (wdio_rtos_add_leading_zero (rtos plc_input_x_offset 2 4))  ")") f)
          (write-line (strcat "(setq plc_output_x_offset "
            (wdio_rtos_add_leading_zero (rtos plc_output_x_offset 2 4))  ")") f)
          (write-line (strcat "(setq plc_input_device_x_offset "
            (wdio_rtos_add_leading_zero (rtos plc_input_device_x_offset 2 4))  ")") f)
          (write-line (strcat "(setq plc_output_device_x_offset "
            (wdio_rtos_add_leading_zero (rtos plc_output_device_x_offset 2 4))  ")") f)
          (write-line (strcat "(setq plc_series_device_spacing "
            (wdio_rtos_add_leading_zero (rtos plc_series_device_spacing 2 4))  ")") f)
          (write-line (strcat "(setq plc_keep_shorted_wire "
            (itoa plc_keep_shorted_wire) ")") f)
          (write-line (strcat "(setq plc_insert_y_offset_rungs_down "
            (itoa plc_insert_y_offset_rungs_down) ")") f)
          (write-line (strcat "(setq always_start_at_top \""
            always_start_at_top "\")") f)
          (write-line (strcat "(setq rung_skip_btwn_module "
            (itoa rung_skip_btwn_module) ")") f)
          (if (AND refnums (> refnums 0))
            (write-line (strcat "(setq refnums " (itoa refnums) ")") f))
          ; general settings
          (write-line (strcat "(setq scale " (wdio_rtos_add_leading_zero (rtos scale 2 4)) ")") f)
          ; Save GBL_wd_scl_plcbld module graphics scaling factor
          (if (AND GBL_wd_scl_plcbld (= (type GBL_wd_scl_plcbld) 'REAL)
                   (not (zerop GBL_wd_scl_plcbld)))
            (write-line (strcat "(setq GBL_wd_scl_plcbld " (wdio_rtos_add_leading_zero (rtos GBL_wd_scl_plcbld 2 4)) ")") f))
          (write-line (strcat "(setvar \"TEXTSIZE\" " (wdio_rtos_add_leading_zero (rtos tsize 2 4)) ")") f)
          (write-line (strcat "(setq tsize " (wdio_rtos_add_leading_zero (rtos tsize 2 4)) ")") f)
          (write-line (strcat "(setq useprototype \""
            (wd_4_convert2_doublebackslash useprototype) "\")") f) ; ** 03-May-07 NEHolt - 923597
          (write-line (strcat "(setq h_or_v_rungs \"" h_or_v_rungs "\")") f)
          (cond
            ((= GBL_wd_scl_plc_borderonly 1) (write-line "(setq GBL_wd_scl_plc_borderonly 1)" f))
            ((= GBL_wd_scl_plc_borderonly 0) (write-line "(setq GBL_wd_scl_plc_borderonly 0)" f))
            (T (write-line "(setq GBL_wd_scl_plc_borderonly nil)" f))
          )
          (if suppress_rails
            (write-line "(setq suppress_rails 1)" f)
          ; ELSE
            (write-line "(setq suppress_rails nil)" f)
          )
; ** 25-Aug-06 NEHolt
          (if use_colskip (write-line (strcat "(setq use_colskip " (itoa use_colskip) ")") f))          
          (if use_skip (write-line (strcat "(setq use_skip " (itoa use_skip) ")") f))          
          (if skipcnt (write-line (strcat "(setq skipcnt " (itoa skipcnt) ")") f))          
          (if colskipcnt (write-line (strcat "(setq colskipcnt " (itoa colskipcnt) ")") f))
; ** 25-Aug-06 NEHolt.en          
          (close f)
          (setq f nil)
      ) )
  ) )
)

; --
(defun wd_wdio_read_settings_data ( cfg_fnam / f data)                          
  (if (AND cfg_fnam (/= cfg_fnam ""))
    (progn
      (if (setq f (open cfg_fnam "r"))
        (progn
          (while (setq data (read-line f))
            (eval (read data))
          )
          (close f)
          (setq f nil)
          (setq GBL_wd_wdio_cfg_fnam cfg_fnam) ; save fnam
  ) ) ) )    
)        
; --
(defun wd_wdio_read_settings ( passed_cfg / cfg_fnam f data)
  ; read settings from previously saved settings
  ; get a file name
  ; "passed_cfg" = nil if prompt for wdi file
  ;              = "" if no config file, use hard-coded defaults
  ;              = <fnam> wdi file name to read
  (if Aw_debug (princ "\nIN:wd_wdio_read_settings"))
  (setq cfg_fnam nil)
  (if (not passed_cfg)
    (progn
      (cond
        ((AND (/= GBL_wd_wdio_cfg_fnam nil) ; previously selected file
              (/= GBL_wd_wdio_cfg_fnam ""))
          (setq cfg_fnam (getfiled (c:wd_msg "IO029" nil "Read Settings From") GBL_wd_wdio_cfg_fnam "WDI" 0)) 
        )
        (T
          (setq cfg_fnam (getfiled (c:wd_msg "IO029" nil "Read Settings From") 
             (strcat wdio_usr_path "demoplc.wdi") "WDI" 0))
      ) )
    )
  ; ELSE
    (progn
      (if (/= passed_cfg "")
        (progn ; make sure file exists
          ; Make sure has wdi extension
          (setq xx (c:wd_split_fnam passed_cfg))
          (setq passed_cfg (strcat (car xx) (cadr xx) ".wdi"))          
          (if (setq x (c:ace_find_file passed_cfg 0))
            (setq cfg_fnam x)
          ; ELSE
            (progn
; ** 28-Oct-06 NEHolt - 831675
              ; One last try
              (if (AND GBL_wd_wdio_cfg_fnam (/= GBL_wd_wdio_cfg_fnam "") 
                       (= (car xx) "")) ; no path included in passed config settings file
                (progn ; look in same folder as the last selected settings file name
                  (if (setq x (findfile (strcat (car (c:wd_split_fnam GBL_wd_wdio_cfg_fnam)) (cadr xx) ".wdi")))
                    (progn
                      (setq cfg_fnam x) ; found it in the original folder
                    )
                  ; ELSE
                    (setq passed_cfg "") ; flag to re-read defaults                        
                  ) 
                )
              ; ELSE
                (setq passed_cfg "") ; flag to re-read defaults  
              ) 
              (if (= passed_cfg "")
                ; Didn't find file, display error alert
                (c:wd_does_file_exist_error "" (strcat (cadr xx) ".wdi"))
              )    
; ** 28-Oct-06 NEHolt.en              
            )
      ) ) )        
      (if (= passed_cfg "")
        (progn
          (user_settings) ; read or re-read hard-coded default settings
          (setq GBL_wd_wdio_cfg_fnam "")
          (setq cfg_fnam "") ; flag return
        )
  ) ) )  
  (wd_wdio_read_settings_data cfg_fnam) ; read the file
      
  (cond
    ((= rung_skip -1)(setq suppress_rungs 1))
  )      
  (if Aw_debug (princ "\nOUT:wd_wdio_read_settings"))  
  cfg_fnam ; return "" if selected file not found, nil=cancel, or full wdi path/filename
)
; --
(princ)









